/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinax.kubernetes.handlers.openshift;

import io.fabric8.kubernetes.client.internal.SerializationUtils;
import io.fabric8.openshift.api.model.BuildConfig;
import io.fabric8.openshift.api.model.BuildConfigBuilder;
import io.fabric8.openshift.api.model.BuildConfigFluent;
import io.fabric8.openshift.api.model.BuildConfigSpecFluent;
import io.fabric8.openshift.api.model.BuildOutputFluent;
import io.fabric8.openshift.api.model.BuildStrategyFluent;
import java.io.IOException;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.Map;
import org.ballerinax.kubernetes.ArtifactManager;
import org.ballerinax.kubernetes.exceptions.KubernetesPluginException;
import org.ballerinax.kubernetes.handlers.AbstractArtifactHandler;
import org.ballerinax.kubernetes.models.openshift.OpenShiftBuildExtensionModel;
import org.ballerinax.kubernetes.utils.DockerImageName;
import org.ballerinax.kubernetes.utils.KubernetesUtils;

public class OpenShiftBuildConfigHandler
extends AbstractArtifactHandler {
    @Override
    public void createArtifacts() throws KubernetesPluginException {
        OpenShiftBuildExtensionModel buildConfigModel = this.dataHolder.getOpenShiftBuildExtensionModel();
        if (null != buildConfigModel) {
            this.generate(buildConfigModel);
            OUT.println();
            OUT.print("\t@openshift:BuildConfig \t\t\t - complete 1/1");
            Map<String, String> instructions = ArtifactManager.getInstructions();
            instructions.put("\tRun the following command to deploy the OpenShift artifacts: ", "\toc apply -f " + this.dataHolder.getK8sArtifactOutputPath().resolve("openshift").toAbsolutePath());
            if (this.dataHolder.getK8sArtifactOutputPath().toString().contains("target")) {
                instructions.put("\tRun the following command to start a build: ", "\toc start-build bc/" + buildConfigModel.getName() + " --from-dir=./target --follow");
            } else {
                instructions.put("\tRun the following command to start a build: ", "\toc start-build bc/" + buildConfigModel.getName() + " --from-dir=. --follow");
            }
            instructions.put("\tRun the following command to deploy the Kubernetes artifacts: ", "\tkubectl apply -f " + this.dataHolder.getK8sArtifactOutputPath());
        }
    }

    private void generate(OpenShiftBuildExtensionModel buildConfigModel) throws KubernetesPluginException {
        try {
            buildConfigModel.setLabels(new LinkedHashMap<String, String>());
            if (null != buildConfigModel.getLabels() && !buildConfigModel.getLabels().containsKey("build")) {
                buildConfigModel.getLabels().put("build", buildConfigModel.getName());
            }
            Path dockerOutputDir = this.dataHolder.getDockerArtifactOutputPath().resolve("Dockerfile");
            DockerImageName dockerImageName = new DockerImageName(this.dataHolder.getDockerModel().getName());
            BuildConfig bc = ((BuildConfigBuilder)((BuildConfigFluent.SpecNested)((BuildConfigSpecFluent.StrategyNested)((BuildStrategyFluent.DockerStrategyNested)((BuildStrategyFluent.DockerStrategyNested)((BuildStrategyFluent.DockerStrategyNested)((BuildConfigFluent.SpecNested)((BuildConfigSpecFluent.SourceNested)((BuildConfigFluent.SpecNested)((BuildConfigSpecFluent.OutputNested)((BuildOutputFluent.ToNested)((BuildOutputFluent.ToNested)((BuildConfigBuilder)((BuildConfigFluent.MetadataNested)((BuildConfigFluent.MetadataNested)((BuildConfigFluent.MetadataNested)((BuildConfigFluent.MetadataNested)new BuildConfigBuilder().withNewMetadata().withName(buildConfigModel.getName())).withLabels(buildConfigModel.getLabels())).withAnnotations(buildConfigModel.getAnnotations())).withNamespace(this.dataHolder.getNamespace())).endMetadata()).withNewSpec().withNewOutput().withNewTo().withKind("ImageStreamTag")).withName(dockerImageName.getRepository() + ":" + dockerImageName.getTag())).endTo()).endOutput()).withNewSource().withNewBinary().endBinary()).endSource()).withNewStrategy().withNewDockerStrategy().withDockerfilePath(this.dataHolder.getUberJarPath().getParent().relativize(dockerOutputDir).toString())).withForcePull(buildConfigModel.isForcePullDockerImage())).withNoCache(buildConfigModel.isBuildDockerWithNoCache())).endDockerStrategy()).endStrategy()).endSpec()).build();
            String resourceQuotaContent = SerializationUtils.dumpWithoutRuntimeStateAsYaml(bc);
            KubernetesUtils.writeToFile(this.dataHolder.getK8sArtifactOutputPath().resolve("openshift"), resourceQuotaContent, "_openshift_bc.yaml");
        }
        catch (IOException e) {
            String errorMessage = "error while generating OpenShift Build Config yaml file: " + buildConfigModel.getName();
            throw new KubernetesPluginException(errorMessage, e);
        }
    }
}

