/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinax.kubernetes.models;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.ballerinax.docker.generator.models.CopyFileModel;
import org.ballerinax.kubernetes.KubernetesConstants;
import org.ballerinax.kubernetes.models.EnvVarValueModel;
import org.ballerinax.kubernetes.models.KubernetesModel;

public class JobModel
extends KubernetesModel {
    protected Map<String, String> nodeSelector;
    private String restartPolicy;
    private int backoffLimit;
    private int activeDeadlineSeconds;
    private String schedule;
    private Map<String, EnvVarValueModel> env;
    private String imagePullPolicy;
    private String image;
    private boolean buildImage;
    private String dockerHost;
    private String username;
    private String password;
    private String baseImage;
    private boolean push;
    private String cmd;
    private String dockerCertPath;
    private Set<String> imagePullSecrets;
    private Set<CopyFileModel> copyFiles;
    private boolean singleYAML;
    private String registry;

    public JobModel() {
        this.labels = new HashMap();
        this.env = new LinkedHashMap<String, EnvVarValueModel>();
        this.copyFiles = new HashSet<CopyFileModel>();
        this.restartPolicy = KubernetesConstants.RestartPolicy.Never.name();
        this.setBaseImage("ballerina/jre8:v1");
        this.setPush(false);
        this.buildImage = true;
        this.nodeSelector = new HashMap<String, String>();
        this.setEnv(new HashMap<String, EnvVarValueModel>());
        this.setImagePullPolicy("IfNotPresent");
        this.activeDeadlineSeconds = 20;
        this.imagePullSecrets = new HashSet<String>();
        this.singleYAML = true;
    }

    public void addLabel(String key, String value) {
        this.labels.put(key, value);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JobModel)) {
            return false;
        }
        JobModel other = (JobModel)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Map<String, String> this$nodeSelector = this.getNodeSelector();
        Map<String, String> other$nodeSelector = other.getNodeSelector();
        if (this$nodeSelector == null ? other$nodeSelector != null : !((Object)this$nodeSelector).equals(other$nodeSelector)) {
            return false;
        }
        String this$restartPolicy = this.getRestartPolicy();
        String other$restartPolicy = other.getRestartPolicy();
        if (this$restartPolicy == null ? other$restartPolicy != null : !this$restartPolicy.equals(other$restartPolicy)) {
            return false;
        }
        if (this.getBackoffLimit() != other.getBackoffLimit()) {
            return false;
        }
        if (this.getActiveDeadlineSeconds() != other.getActiveDeadlineSeconds()) {
            return false;
        }
        String this$schedule = this.getSchedule();
        String other$schedule = other.getSchedule();
        if (this$schedule == null ? other$schedule != null : !this$schedule.equals(other$schedule)) {
            return false;
        }
        Map<String, EnvVarValueModel> this$env = this.getEnv();
        Map<String, EnvVarValueModel> other$env = other.getEnv();
        if (this$env == null ? other$env != null : !((Object)this$env).equals(other$env)) {
            return false;
        }
        String this$imagePullPolicy = this.getImagePullPolicy();
        String other$imagePullPolicy = other.getImagePullPolicy();
        if (this$imagePullPolicy == null ? other$imagePullPolicy != null : !this$imagePullPolicy.equals(other$imagePullPolicy)) {
            return false;
        }
        String this$image = this.getImage();
        String other$image = other.getImage();
        if (this$image == null ? other$image != null : !this$image.equals(other$image)) {
            return false;
        }
        if (this.isBuildImage() != other.isBuildImage()) {
            return false;
        }
        String this$dockerHost = this.getDockerHost();
        String other$dockerHost = other.getDockerHost();
        if (this$dockerHost == null ? other$dockerHost != null : !this$dockerHost.equals(other$dockerHost)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$baseImage = this.getBaseImage();
        String other$baseImage = other.getBaseImage();
        if (this$baseImage == null ? other$baseImage != null : !this$baseImage.equals(other$baseImage)) {
            return false;
        }
        if (this.isPush() != other.isPush()) {
            return false;
        }
        String this$cmd = this.getCmd();
        String other$cmd = other.getCmd();
        if (this$cmd == null ? other$cmd != null : !this$cmd.equals(other$cmd)) {
            return false;
        }
        String this$dockerCertPath = this.getDockerCertPath();
        String other$dockerCertPath = other.getDockerCertPath();
        if (this$dockerCertPath == null ? other$dockerCertPath != null : !this$dockerCertPath.equals(other$dockerCertPath)) {
            return false;
        }
        Set<String> this$imagePullSecrets = this.getImagePullSecrets();
        Set<String> other$imagePullSecrets = other.getImagePullSecrets();
        if (this$imagePullSecrets == null ? other$imagePullSecrets != null : !((Object)this$imagePullSecrets).equals(other$imagePullSecrets)) {
            return false;
        }
        Set<CopyFileModel> this$copyFiles = this.getCopyFiles();
        Set<CopyFileModel> other$copyFiles = other.getCopyFiles();
        if (this$copyFiles == null ? other$copyFiles != null : !((Object)this$copyFiles).equals(other$copyFiles)) {
            return false;
        }
        if (this.isSingleYAML() != other.isSingleYAML()) {
            return false;
        }
        String this$registry = this.getRegistry();
        String other$registry = other.getRegistry();
        return !(this$registry == null ? other$registry != null : !this$registry.equals(other$registry));
    }

    protected boolean canEqual(Object other) {
        return other instanceof JobModel;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Map<String, String> $nodeSelector = this.getNodeSelector();
        result = result * 59 + ($nodeSelector == null ? 43 : ((Object)$nodeSelector).hashCode());
        String $restartPolicy = this.getRestartPolicy();
        result = result * 59 + ($restartPolicy == null ? 43 : $restartPolicy.hashCode());
        result = result * 59 + this.getBackoffLimit();
        result = result * 59 + this.getActiveDeadlineSeconds();
        String $schedule = this.getSchedule();
        result = result * 59 + ($schedule == null ? 43 : $schedule.hashCode());
        Map<String, EnvVarValueModel> $env = this.getEnv();
        result = result * 59 + ($env == null ? 43 : ((Object)$env).hashCode());
        String $imagePullPolicy = this.getImagePullPolicy();
        result = result * 59 + ($imagePullPolicy == null ? 43 : $imagePullPolicy.hashCode());
        String $image = this.getImage();
        result = result * 59 + ($image == null ? 43 : $image.hashCode());
        result = result * 59 + (this.isBuildImage() ? 79 : 97);
        String $dockerHost = this.getDockerHost();
        result = result * 59 + ($dockerHost == null ? 43 : $dockerHost.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $baseImage = this.getBaseImage();
        result = result * 59 + ($baseImage == null ? 43 : $baseImage.hashCode());
        result = result * 59 + (this.isPush() ? 79 : 97);
        String $cmd = this.getCmd();
        result = result * 59 + ($cmd == null ? 43 : $cmd.hashCode());
        String $dockerCertPath = this.getDockerCertPath();
        result = result * 59 + ($dockerCertPath == null ? 43 : $dockerCertPath.hashCode());
        Set<String> $imagePullSecrets = this.getImagePullSecrets();
        result = result * 59 + ($imagePullSecrets == null ? 43 : ((Object)$imagePullSecrets).hashCode());
        Set<CopyFileModel> $copyFiles = this.getCopyFiles();
        result = result * 59 + ($copyFiles == null ? 43 : ((Object)$copyFiles).hashCode());
        result = result * 59 + (this.isSingleYAML() ? 79 : 97);
        String $registry = this.getRegistry();
        result = result * 59 + ($registry == null ? 43 : $registry.hashCode());
        return result;
    }

    public Map<String, String> getNodeSelector() {
        return this.nodeSelector;
    }

    public String getRestartPolicy() {
        return this.restartPolicy;
    }

    public int getBackoffLimit() {
        return this.backoffLimit;
    }

    public int getActiveDeadlineSeconds() {
        return this.activeDeadlineSeconds;
    }

    public String getSchedule() {
        return this.schedule;
    }

    public Map<String, EnvVarValueModel> getEnv() {
        return this.env;
    }

    public String getImagePullPolicy() {
        return this.imagePullPolicy;
    }

    public String getImage() {
        return this.image;
    }

    public boolean isBuildImage() {
        return this.buildImage;
    }

    public String getDockerHost() {
        return this.dockerHost;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getBaseImage() {
        return this.baseImage;
    }

    public boolean isPush() {
        return this.push;
    }

    public String getCmd() {
        return this.cmd;
    }

    public String getDockerCertPath() {
        return this.dockerCertPath;
    }

    public Set<String> getImagePullSecrets() {
        return this.imagePullSecrets;
    }

    public Set<CopyFileModel> getCopyFiles() {
        return this.copyFiles;
    }

    public boolean isSingleYAML() {
        return this.singleYAML;
    }

    public String getRegistry() {
        return this.registry;
    }

    public void setNodeSelector(Map<String, String> nodeSelector) {
        this.nodeSelector = nodeSelector;
    }

    public void setRestartPolicy(String restartPolicy) {
        this.restartPolicy = restartPolicy;
    }

    public void setBackoffLimit(int backoffLimit) {
        this.backoffLimit = backoffLimit;
    }

    public void setActiveDeadlineSeconds(int activeDeadlineSeconds) {
        this.activeDeadlineSeconds = activeDeadlineSeconds;
    }

    public void setSchedule(String schedule) {
        this.schedule = schedule;
    }

    public void setEnv(Map<String, EnvVarValueModel> env) {
        this.env = env;
    }

    public void setImagePullPolicy(String imagePullPolicy) {
        this.imagePullPolicy = imagePullPolicy;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public void setBuildImage(boolean buildImage) {
        this.buildImage = buildImage;
    }

    public void setDockerHost(String dockerHost) {
        this.dockerHost = dockerHost;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setBaseImage(String baseImage) {
        this.baseImage = baseImage;
    }

    public void setPush(boolean push) {
        this.push = push;
    }

    public void setCmd(String cmd) {
        this.cmd = cmd;
    }

    public void setDockerCertPath(String dockerCertPath) {
        this.dockerCertPath = dockerCertPath;
    }

    public void setImagePullSecrets(Set<String> imagePullSecrets) {
        this.imagePullSecrets = imagePullSecrets;
    }

    public void setCopyFiles(Set<CopyFileModel> copyFiles) {
        this.copyFiles = copyFiles;
    }

    public void setSingleYAML(boolean singleYAML) {
        this.singleYAML = singleYAML;
    }

    public void setRegistry(String registry) {
        this.registry = registry;
    }

    public String toString() {
        return "JobModel(nodeSelector=" + this.getNodeSelector() + ", restartPolicy=" + this.getRestartPolicy() + ", backoffLimit=" + this.getBackoffLimit() + ", activeDeadlineSeconds=" + this.getActiveDeadlineSeconds() + ", schedule=" + this.getSchedule() + ", env=" + this.getEnv() + ", imagePullPolicy=" + this.getImagePullPolicy() + ", image=" + this.getImage() + ", buildImage=" + this.isBuildImage() + ", dockerHost=" + this.getDockerHost() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", baseImage=" + this.getBaseImage() + ", push=" + this.isPush() + ", cmd=" + this.getCmd() + ", dockerCertPath=" + this.getDockerCertPath() + ", imagePullSecrets=" + this.getImagePullSecrets() + ", copyFiles=" + this.getCopyFiles() + ", singleYAML=" + this.isSingleYAML() + ", registry=" + this.getRegistry() + ")";
    }
}

