/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinax.kubernetes.models;

import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.ballerinax.docker.generator.models.DockerModel;
import org.ballerinax.kubernetes.models.ConfigMapModel;
import org.ballerinax.kubernetes.models.DeploymentModel;
import org.ballerinax.kubernetes.models.IngressModel;
import org.ballerinax.kubernetes.models.JobModel;
import org.ballerinax.kubernetes.models.PersistentVolumeClaimModel;
import org.ballerinax.kubernetes.models.PodAutoscalerModel;
import org.ballerinax.kubernetes.models.ResourceQuotaModel;
import org.ballerinax.kubernetes.models.SecretModel;
import org.ballerinax.kubernetes.models.ServiceModel;
import org.ballerinax.kubernetes.models.istio.IstioGatewayModel;
import org.ballerinax.kubernetes.models.istio.IstioVirtualServiceModel;
import org.ballerinax.kubernetes.models.openshift.OpenShiftBuildExtensionModel;
import org.ballerinax.kubernetes.models.openshift.OpenShiftRouteModel;

public class KubernetesDataHolder {
    private boolean canProcess;
    private DeploymentModel deploymentModel;
    private DockerModel dockerModel;
    private PodAutoscalerModel podAutoscalerModel;
    private Map<String, ServiceModel> bListenerToK8sServiceMap;
    private Map<String, Set<SecretModel>> bListenerToSecretMap;
    private Set<SecretModel> secretModelSet;
    private Set<IngressModel> ingressModelSet;
    private Set<ConfigMapModel> configMapModelSet;
    private Set<PersistentVolumeClaimModel> volumeClaimModelSet;
    private Set<ResourceQuotaModel> resourceQuotaModels;
    private Map<String, IstioGatewayModel> istioGatewayModels;
    private Map<String, IstioVirtualServiceModel> istioVirtualServiceModels;
    private OpenShiftBuildExtensionModel openShiftBuildExtensionModel;
    private Map<String, OpenShiftRouteModel> openShiftRouteModels;
    private JobModel jobModel;
    private Path uberJarPath;
    private Path k8sArtifactOutputPath;
    private Path dockerArtifactOutputPath;
    private String namespace;
    private Path sourceRoot;
    private boolean isProject = false;

    KubernetesDataHolder(Path sourceRoot) {
        this.sourceRoot = sourceRoot;
        this.bListenerToK8sServiceMap = new HashMap<String, ServiceModel>();
        this.bListenerToSecretMap = new HashMap<String, Set<SecretModel>>();
        this.secretModelSet = new HashSet<SecretModel>();
        this.configMapModelSet = new HashSet<ConfigMapModel>();
        this.volumeClaimModelSet = new HashSet<PersistentVolumeClaimModel>();
        this.ingressModelSet = new HashSet<IngressModel>();
        this.deploymentModel = new DeploymentModel();
        this.resourceQuotaModels = new HashSet<ResourceQuotaModel>();
        this.istioGatewayModels = new LinkedHashMap<String, IstioGatewayModel>();
        this.istioVirtualServiceModels = new LinkedHashMap<String, IstioVirtualServiceModel>();
        this.openShiftRouteModels = new LinkedHashMap<String, OpenShiftRouteModel>();
    }

    public Path getSourceRoot() {
        return this.sourceRoot;
    }

    public boolean isProject() {
        return this.isProject;
    }

    public void setProject(boolean project) {
        this.isProject = project;
    }

    public DeploymentModel getDeploymentModel() {
        return this.deploymentModel;
    }

    public void setDeploymentModel(DeploymentModel deploymentModel) {
        this.deploymentModel = deploymentModel;
    }

    public PodAutoscalerModel getPodAutoscalerModel() {
        return this.podAutoscalerModel;
    }

    public void setPodAutoscalerModel(PodAutoscalerModel podAutoscalerModel) {
        this.podAutoscalerModel = podAutoscalerModel;
    }

    public Map<String, Set<SecretModel>> getSecretModels() {
        return this.bListenerToSecretMap;
    }

    public void addListenerSecret(String listenerName, Set<SecretModel> secretModel) {
        this.bListenerToSecretMap.put(listenerName, secretModel);
    }

    public Set<SecretModel> getSecretModelSet() {
        return this.secretModelSet;
    }

    public void addSecrets(Set<SecretModel> secrets) {
        this.secretModelSet.addAll(secrets);
    }

    public Set<ConfigMapModel> getConfigMapModelSet() {
        return this.configMapModelSet;
    }

    public void addConfigMaps(Set<ConfigMapModel> configMaps) {
        this.configMapModelSet.addAll(configMaps);
    }

    public Set<PersistentVolumeClaimModel> getVolumeClaimModelSet() {
        return this.volumeClaimModelSet;
    }

    public void addPersistentVolumeClaims(Set<PersistentVolumeClaimModel> persistentVolumeClaims) {
        this.volumeClaimModelSet.addAll(persistentVolumeClaims);
    }

    public Set<ResourceQuotaModel> getResourceQuotaModels() {
        return this.resourceQuotaModels;
    }

    public void setResourceQuotaModels(Set<ResourceQuotaModel> resourceQuotaModels) {
        this.resourceQuotaModels = resourceQuotaModels;
    }

    public Map<String, ServiceModel> getbListenerToK8sServiceMap() {
        return this.bListenerToK8sServiceMap;
    }

    public void addBListenerToK8sServiceMap(String listenerName, ServiceModel serviceModel) {
        this.bListenerToK8sServiceMap.put(listenerName, serviceModel);
    }

    public ServiceModel getServiceModel(String listener) {
        return this.bListenerToK8sServiceMap.get(listener);
    }

    public Set<IngressModel> getIngressModelSet() {
        return this.ingressModelSet;
    }

    public void addIngressModel(IngressModel ingressModel) {
        this.ingressModelSet.add(ingressModel);
    }

    public JobModel getJobModel() {
        return this.jobModel;
    }

    public void setJobModel(JobModel jobModel) {
        this.jobModel = jobModel;
    }

    public boolean isCanProcess() {
        return this.canProcess;
    }

    public void setCanProcess(boolean canProcess) {
        this.canProcess = canProcess;
    }

    public Path getUberJarPath() {
        return this.uberJarPath;
    }

    public void setUberJarPath(Path uberJarPath) {
        this.uberJarPath = uberJarPath;
    }

    public Path getK8sArtifactOutputPath() {
        return this.k8sArtifactOutputPath;
    }

    public void setK8sArtifactOutputPath(Path k8sArtifactOutputPath) {
        this.k8sArtifactOutputPath = k8sArtifactOutputPath;
    }

    public Path getDockerArtifactOutputPath() {
        return this.dockerArtifactOutputPath;
    }

    public void setDockerArtifactOutputPath(Path dockerArtifactOutputPath) {
        this.dockerArtifactOutputPath = dockerArtifactOutputPath;
    }

    public DockerModel getDockerModel() {
        return this.dockerModel;
    }

    public void setDockerModel(DockerModel dockerModel) {
        this.dockerModel = dockerModel;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public Map<String, IstioGatewayModel> getIstioGatewayModels() {
        return this.istioGatewayModels;
    }

    public IstioGatewayModel getIstioGatewayModel(String serviceName) {
        return this.istioGatewayModels.get(serviceName);
    }

    public void addIstioGatewayModel(String serviceName, IstioGatewayModel istioGatewayModel) {
        this.istioGatewayModels.put(serviceName, istioGatewayModel);
    }

    public Map<String, IstioVirtualServiceModel> getIstioVirtualServiceModels() {
        return this.istioVirtualServiceModels;
    }

    public IstioVirtualServiceModel getIstioVirtualServiceModel(String serviceName) {
        return this.istioVirtualServiceModels.get(serviceName);
    }

    public void addIstioVirtualServiceModel(String serviceName, IstioVirtualServiceModel istioVirtualServiceModel) {
        this.istioVirtualServiceModels.put(serviceName, istioVirtualServiceModel);
    }

    public OpenShiftBuildExtensionModel getOpenShiftBuildExtensionModel() {
        return this.openShiftBuildExtensionModel;
    }

    public void setOpenShiftBuildExtensionModel(OpenShiftBuildExtensionModel openShiftBuildExtensionModel) {
        this.openShiftBuildExtensionModel = openShiftBuildExtensionModel;
    }

    public Map<String, OpenShiftRouteModel> getOpenShiftRouteModels() {
        return this.openShiftRouteModels;
    }

    public void addOpenShiftRouteModel(String serviceName, OpenShiftRouteModel openShiftRouteModel) {
        this.openShiftRouteModels.put(serviceName, openShiftRouteModel);
    }
}

