/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinax.kubernetes.models.knative;

import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import org.ballerinalang.model.elements.PackageID;
import org.ballerinax.kubernetes.exceptions.KubernetesPluginException;
import org.ballerinax.kubernetes.models.knative.KnativeDataHolder;
import org.ballerinax.kubernetes.utils.KnativeUtils;
import org.wso2.ballerinalang.compiler.util.Names;

public class KnativeContext {
    private static KnativeContext instance;
    private final Map<PackageID, KnativeDataHolder> packageIDtoDataHolderMap = new HashMap<PackageID, KnativeDataHolder>();
    private PackageID currentPackage;

    private KnativeContext() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KnativeContext getInstance() {
        Class<KnativeDataHolder> clazz = KnativeDataHolder.class;
        synchronized (KnativeDataHolder.class) {
            if (instance == null) {
                instance = new KnativeContext();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void addDataHolder(PackageID packageID, Path sourcePath) {
        this.currentPackage = packageID;
        this.packageIDtoDataHolderMap.put(packageID, new KnativeDataHolder(sourcePath));
    }

    public void setCurrentPackage(PackageID packageID) {
        this.currentPackage = packageID;
    }

    public KnativeDataHolder getDataHolder() {
        return this.packageIDtoDataHolderMap.get(this.currentPackage);
    }

    public KnativeDataHolder getDataHolder(PackageID packageID) {
        return this.packageIDtoDataHolderMap.get(packageID);
    }

    public Map<PackageID, KnativeDataHolder> getPackageIDtoDataHolderMap() {
        return this.packageIDtoDataHolderMap;
    }

    public String getServiceName(String dependsOn) throws KubernetesPluginException {
        String packageName = dependsOn.substring(0, dependsOn.indexOf(Names.VERSION_SEPARATOR.value));
        String listener = dependsOn.substring(dependsOn.indexOf(Names.VERSION_SEPARATOR.value) + 1);
        for (PackageID packageID : this.packageIDtoDataHolderMap.keySet()) {
            if (!packageName.equals(packageID.name.value)) continue;
            return this.getDataHolder(packageID).getbListenerToK8sServiceMap().get(listener).getName();
        }
        throw new KubernetesPluginException("dependent listener " + dependsOn + " is not annotated with @kubernetes:Service{}");
    }

    public String getDeploymentNameFromListener(String dependsOn) throws KubernetesPluginException {
        if (KnativeUtils.isBlank(dependsOn) || !dependsOn.contains(Names.VERSION_SEPARATOR.value) || dependsOn.indexOf(Names.VERSION_SEPARATOR.value) <= 1) {
            throw new KubernetesPluginException("@kubernetes:Deployment{} invalid dependsOn format specified " + dependsOn);
        }
        String packageName = dependsOn.substring(0, dependsOn.indexOf(Names.VERSION_SEPARATOR.value));
        for (PackageID packageID : this.packageIDtoDataHolderMap.keySet()) {
            if (!packageName.equals(packageID.name.value)) continue;
            return this.getDataHolder(packageID).getServiceModel().getName();
        }
        throw new KubernetesPluginException("dependent listener " + dependsOn + " not found.");
    }
}

