/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinax.kubernetes.models.knative;

import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.ballerinax.docker.generator.models.DockerModel;
import org.ballerinax.kubernetes.models.knative.ConfigMapModel;
import org.ballerinax.kubernetes.models.knative.KnativeContainerModel;
import org.ballerinax.kubernetes.models.knative.PodAutoscalerModel;
import org.ballerinax.kubernetes.models.knative.ResourceQuotaModel;
import org.ballerinax.kubernetes.models.knative.SecretModel;
import org.ballerinax.kubernetes.models.knative.ServiceModel;

public class KnativeDataHolder {
    private boolean canProcess;
    private ServiceModel serviceModel;
    private DockerModel dockerModel;
    private PodAutoscalerModel podAutoscalerModel;
    private Map<String, KnativeContainerModel> bListenerToK8sServiceMap;
    private Map<String, Set<SecretModel>> bListenerToSecretMap;
    private Set<SecretModel> secretModelSet;
    private Set<ConfigMapModel> configMapModelSet;
    private Set<ResourceQuotaModel> resourceQuotaModels;
    private Path uberJarPath;
    private Path k8sArtifactOutputPath;
    private Path dockerArtifactOutputPath;
    private String namespace;
    private Path sourceRoot;
    private boolean isProject = false;

    KnativeDataHolder(Path sourceRoot) {
        this.sourceRoot = sourceRoot;
        this.bListenerToK8sServiceMap = new HashMap<String, KnativeContainerModel>();
        this.bListenerToSecretMap = new HashMap<String, Set<SecretModel>>();
        this.secretModelSet = new HashSet<SecretModel>();
        this.configMapModelSet = new HashSet<ConfigMapModel>();
        this.serviceModel = new ServiceModel();
        this.resourceQuotaModels = new HashSet<ResourceQuotaModel>();
    }

    public Path getSourceRoot() {
        return this.sourceRoot;
    }

    public boolean isProject() {
        return this.isProject;
    }

    public void setProject(boolean project) {
        this.isProject = project;
    }

    public ServiceModel getServiceModel() {
        return this.serviceModel;
    }

    public void setServiceModel(ServiceModel serviceModel) {
        this.serviceModel = serviceModel;
    }

    public PodAutoscalerModel getPodAutoscalerModel() {
        return this.podAutoscalerModel;
    }

    public void setPodAutoscalerModel(PodAutoscalerModel podAutoscalerModel) {
        this.podAutoscalerModel = podAutoscalerModel;
    }

    public Map<String, Set<SecretModel>> getSecretModels() {
        return this.bListenerToSecretMap;
    }

    public void addListenerSecret(String listenerName, Set<SecretModel> secretModel) {
        this.bListenerToSecretMap.put(listenerName, secretModel);
    }

    public Set<SecretModel> getSecretModelSet() {
        return this.secretModelSet;
    }

    public void addSecrets(Set<SecretModel> secrets) {
        this.secretModelSet.addAll(secrets);
    }

    public Set<ConfigMapModel> getConfigMapModelSet() {
        return this.configMapModelSet;
    }

    public void addConfigMaps(Set<ConfigMapModel> configMaps) {
        this.configMapModelSet.addAll(configMaps);
    }

    public Set<ResourceQuotaModel> getResourceQuotaModels() {
        return this.resourceQuotaModels;
    }

    public void setResourceQuotaModels(Set<ResourceQuotaModel> resourceQuotaModels) {
        this.resourceQuotaModels = resourceQuotaModels;
    }

    public Map<String, KnativeContainerModel> getbListenerToK8sServiceMap() {
        return this.bListenerToK8sServiceMap;
    }

    public void addBListenerToK8sServiceMap(String listenerName, KnativeContainerModel knativeContainerModel) {
        this.bListenerToK8sServiceMap.put(listenerName, knativeContainerModel);
    }

    public KnativeContainerModel getServiceModel(String listener) {
        return this.bListenerToK8sServiceMap.get(listener);
    }

    public boolean isCanProcess() {
        return this.canProcess;
    }

    public void setCanProcess(boolean canProcess) {
        this.canProcess = canProcess;
    }

    public Path getUberJarPath() {
        return this.uberJarPath;
    }

    public void setUberJarPath(Path uberJarPath) {
        this.uberJarPath = uberJarPath;
    }

    public Path getK8sArtifactOutputPath() {
        return this.k8sArtifactOutputPath;
    }

    public void setK8sArtifactOutputPath(Path k8sArtifactOutputPath) {
        this.k8sArtifactOutputPath = k8sArtifactOutputPath;
    }

    public Path getDockerArtifactOutputPath() {
        return this.dockerArtifactOutputPath;
    }

    public void setDockerArtifactOutputPath(Path dockerArtifactOutputPath) {
        this.dockerArtifactOutputPath = dockerArtifactOutputPath;
    }

    public DockerModel getDockerModel() {
        return this.dockerModel;
    }

    public void setDockerModel(DockerModel dockerModel) {
        this.dockerModel = dockerModel;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }
}

