/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinax.kubernetes.processors;

import org.ballerinax.kubernetes.exceptions.KubernetesPluginException;
import org.ballerinax.kubernetes.models.KubernetesContext;
import org.ballerinax.kubernetes.processors.AnnotationProcessor;
import org.ballerinax.kubernetes.processors.ConfigMapAnnotationProcessor;
import org.ballerinax.kubernetes.processors.DeploymentAnnotationProcessor;
import org.ballerinax.kubernetes.processors.HPAAnnotationProcessor;
import org.ballerinax.kubernetes.processors.IngressAnnotationProcessor;
import org.ballerinax.kubernetes.processors.JobAnnotationProcessor;
import org.ballerinax.kubernetes.processors.ResourceQuotaAnnotationPreprocessor;
import org.ballerinax.kubernetes.processors.SecretAnnotationProcessor;
import org.ballerinax.kubernetes.processors.ServiceAnnotationProcessor;
import org.ballerinax.kubernetes.processors.VolumeClaimAnnotationProcessor;
import org.ballerinax.kubernetes.processors.istio.IstioGatewayAnnotationProcessor;
import org.ballerinax.kubernetes.processors.istio.IstioVirtualServiceAnnotationProcessor;
import org.ballerinax.kubernetes.processors.openshift.OpenShiftRouteProcessor;

public class AnnotationProcessorFactory {
    public static AnnotationProcessor getAnnotationProcessorInstance(String type) throws KubernetesPluginException {
        KubernetesContext.getInstance().getDataHolder().setCanProcess(true);
        KubernetesAnnotation kubernetesAnnotation = KubernetesAnnotation.valueOf(type);
        switch (kubernetesAnnotation) {
            case Service: {
                return new ServiceAnnotationProcessor();
            }
            case Ingress: {
                return new IngressAnnotationProcessor();
            }
            case HPA: {
                return new HPAAnnotationProcessor();
            }
            case Deployment: {
                return new DeploymentAnnotationProcessor();
            }
            case Secret: {
                return new SecretAnnotationProcessor();
            }
            case ConfigMap: {
                return new ConfigMapAnnotationProcessor();
            }
            case PersistentVolumeClaim: {
                return new VolumeClaimAnnotationProcessor();
            }
            case Job: {
                return new JobAnnotationProcessor();
            }
            case ResourceQuota: {
                return new ResourceQuotaAnnotationPreprocessor();
            }
            case Gateway: {
                return new IstioGatewayAnnotationProcessor();
            }
            case VirtualService: {
                return new IstioVirtualServiceAnnotationProcessor();
            }
            case Route: {
                return new OpenShiftRouteProcessor();
            }
        }
        KubernetesContext.getInstance().getDataHolder().setCanProcess(false);
        throw new KubernetesPluginException("error while getting annotation processor for type: " + type);
    }

    private static enum KubernetesAnnotation {
        Service,
        Ingress,
        HPA,
        Deployment,
        Secret,
        ConfigMap,
        PersistentVolumeClaim,
        Job,
        ResourceQuota,
        Gateway,
        VirtualService,
        Route;

    }
}

