/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinax.kubernetes.processors;

import java.util.List;
import org.ballerinalang.model.tree.AnnotationAttachmentNode;
import org.ballerinalang.model.tree.FunctionNode;
import org.ballerinalang.model.tree.ServiceNode;
import org.ballerinax.kubernetes.exceptions.KubernetesPluginException;
import org.ballerinax.kubernetes.models.KubernetesContext;
import org.ballerinax.kubernetes.models.PodAutoscalerModel;
import org.ballerinax.kubernetes.processors.AbstractAnnotationProcessor;
import org.ballerinax.kubernetes.utils.KubernetesUtils;
import org.wso2.ballerinalang.compiler.tree.BLangAnnotationAttachment;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRecordLiteral;

public class HPAAnnotationProcessor
extends AbstractAnnotationProcessor {
    @Override
    public void processAnnotation(ServiceNode serviceNode, AnnotationAttachmentNode attachmentNode) throws KubernetesPluginException {
        this.processHPA(attachmentNode);
    }

    @Override
    public void processAnnotation(FunctionNode functionNode, AnnotationAttachmentNode attachmentNode) throws KubernetesPluginException {
        if (!"main".equals(functionNode.getName().getValue())) {
            throw new KubernetesPluginException("@kubernetes:HPA{} annotation must be attached to a main function.");
        }
        this.processHPA(attachmentNode);
    }

    private void processHPA(AnnotationAttachmentNode attachmentNode) throws KubernetesPluginException {
        PodAutoscalerModel podAutoscalerModel = new PodAutoscalerModel();
        List<BLangRecordLiteral.BLangRecordKeyValueField> keyValues = KubernetesUtils.convertRecordFields(((BLangRecordLiteral)((BLangAnnotationAttachment)attachmentNode).expr).getFields());
        for (BLangRecordLiteral.BLangRecordKeyValueField keyValue : keyValues) {
            PodAutoscalerConfiguration podAutoscalerConfiguration = PodAutoscalerConfiguration.valueOf(keyValue.getKey().toString());
            switch (podAutoscalerConfiguration) {
                case name: {
                    podAutoscalerModel.setName(KubernetesUtils.getValidName(KubernetesUtils.getStringValue(keyValue.getValue())));
                    break;
                }
                case labels: {
                    podAutoscalerModel.setLabels(KubernetesUtils.getMap(keyValue.getValue()));
                    break;
                }
                case annotations: {
                    podAutoscalerModel.setAnnotations(KubernetesUtils.getMap(keyValue.getValue()));
                    break;
                }
                case cpuPercentage: {
                    podAutoscalerModel.setCpuPercentage(KubernetesUtils.getIntValue(keyValue.getValue()));
                    break;
                }
                case minReplicas: {
                    podAutoscalerModel.setMinReplicas(KubernetesUtils.getIntValue(keyValue.getValue()));
                    break;
                }
                case maxReplicas: {
                    podAutoscalerModel.setMaxReplicas(KubernetesUtils.getIntValue(keyValue.getValue()));
                    break;
                }
            }
        }
        KubernetesContext.getInstance().getDataHolder().setPodAutoscalerModel(podAutoscalerModel);
    }

    private static enum PodAutoscalerConfiguration {
        name,
        labels,
        annotations,
        minReplicas,
        maxReplicas,
        cpuPercentage;

    }
}

