/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinax.kubernetes.processors;

import org.ballerinax.kubernetes.exceptions.KubernetesPluginException;
import org.ballerinax.kubernetes.models.knative.KnativeContext;
import org.ballerinax.kubernetes.processors.AnnotationProcessor;
import org.ballerinax.kubernetes.processors.knative.KnativeConfigMapAnnotationProcessor;
import org.ballerinax.kubernetes.processors.knative.KnativeSecretAnnotationProcesser;
import org.ballerinax.kubernetes.processors.knative.KnativeServiceAnnotationProcessor;

public class KnativeAnnotationProcessorFactory {
    public static AnnotationProcessor getAnnotationProcessorInstance(String type) throws KubernetesPluginException {
        KnativeContext.getInstance().getDataHolder().setCanProcess(true);
        KnativeAnnotation knativeAnnotation = KnativeAnnotation.valueOf(type);
        switch (knativeAnnotation) {
            case Service: {
                return new KnativeServiceAnnotationProcessor();
            }
            case Secret: {
                return new KnativeSecretAnnotationProcesser();
            }
            case ConfigMap: {
                return new KnativeConfigMapAnnotationProcessor();
            }
        }
        KnativeContext.getInstance().getDataHolder().setCanProcess(false);
        throw new KubernetesPluginException("error while getting annotation processor for type: " + type);
    }

    private static enum KnativeAnnotation {
        Service,
        HPA,
        Secret,
        ConfigMap,
        ResourceQuota;

    }
}

