/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinax.kubernetes.processors;

import java.util.HashSet;
import java.util.List;
import org.ballerinalang.model.tree.AnnotationAttachmentNode;
import org.ballerinalang.model.tree.FunctionNode;
import org.ballerinalang.model.tree.ServiceNode;
import org.ballerinax.kubernetes.exceptions.KubernetesPluginException;
import org.ballerinax.kubernetes.models.KubernetesContext;
import org.ballerinax.kubernetes.models.PersistentVolumeClaimModel;
import org.ballerinax.kubernetes.processors.AbstractAnnotationProcessor;
import org.ballerinax.kubernetes.utils.KubernetesUtils;
import org.wso2.ballerinalang.compiler.tree.BLangAnnotationAttachment;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangListConstructorExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRecordLiteral;

public class VolumeClaimAnnotationProcessor
extends AbstractAnnotationProcessor {
    @Override
    public void processAnnotation(ServiceNode serviceNode, AnnotationAttachmentNode attachmentNode) throws KubernetesPluginException {
        this.processVolumeClaims(attachmentNode);
    }

    @Override
    public void processAnnotation(FunctionNode functionNode, AnnotationAttachmentNode attachmentNode) throws KubernetesPluginException {
        if (!"main".equals(functionNode.getName().getValue())) {
            throw new KubernetesPluginException("@kubernetes:PersistentVolumeClaim annotation must be attached to a main function.");
        }
        this.processVolumeClaims(attachmentNode);
    }

    private void processVolumeClaims(AnnotationAttachmentNode attachmentNode) throws KubernetesPluginException {
        HashSet<PersistentVolumeClaimModel> volumeClaimModels = new HashSet<PersistentVolumeClaimModel>();
        List<BLangRecordLiteral.BLangRecordKeyValueField> keyValues = KubernetesUtils.convertRecordFields(((BLangRecordLiteral)((BLangAnnotationAttachment)attachmentNode).expr).getFields());
        for (BLangRecordLiteral.BLangRecordKeyValueField keyValue : keyValues) {
            List secretAnnotation = ((BLangListConstructorExpr)keyValue.valueExpr).exprs;
            for (BLangExpression bLangExpression : secretAnnotation) {
                PersistentVolumeClaimModel claimModel = new PersistentVolumeClaimModel();
                List<BLangRecordLiteral.BLangRecordKeyValueField> annotationValues = KubernetesUtils.convertRecordFields(((BLangRecordLiteral)bLangExpression).getFields());
                for (BLangRecordLiteral.BLangRecordKeyValueField annotation : annotationValues) {
                    VolumeClaimConfig volumeMountConfig = VolumeClaimConfig.valueOf(annotation.getKey().toString());
                    switch (volumeMountConfig) {
                        case name: {
                            claimModel.setName(KubernetesUtils.getValidName(KubernetesUtils.getStringValue(annotation.getValue())));
                            break;
                        }
                        case labels: {
                            claimModel.setLabels(KubernetesUtils.getMap(keyValue.getValue()));
                            break;
                        }
                        case annotations: {
                            claimModel.setAnnotations(KubernetesUtils.getMap(keyValue.getValue()));
                            break;
                        }
                        case mountPath: {
                            claimModel.setMountPath(KubernetesUtils.getStringValue(annotation.getValue()));
                            break;
                        }
                        case accessMode: {
                            claimModel.setAccessMode(KubernetesUtils.getStringValue(annotation.getValue()));
                            break;
                        }
                        case volumeClaimSize: {
                            claimModel.setVolumeClaimSize(KubernetesUtils.getStringValue(annotation.getValue()));
                            break;
                        }
                        case readOnly: {
                            claimModel.setReadOnly(KubernetesUtils.getBooleanValue(annotation.getValue()));
                            break;
                        }
                    }
                }
                volumeClaimModels.add(claimModel);
            }
        }
        KubernetesContext.getInstance().getDataHolder().addPersistentVolumeClaims(volumeClaimModels);
    }

    private static enum VolumeClaimConfig {
        name,
        labels,
        annotations,
        mountPath,
        readOnly,
        accessMode,
        volumeClaimSize;

    }
}

