/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinax.kubernetes.processors.istio;

import java.util.LinkedList;
import java.util.List;
import org.ballerinalang.model.tree.AnnotationAttachmentNode;
import org.ballerinalang.model.tree.ServiceNode;
import org.ballerinalang.model.tree.SimpleVariableNode;
import org.ballerinalang.model.tree.expressions.ExpressionNode;
import org.ballerinax.kubernetes.exceptions.KubernetesPluginException;
import org.ballerinax.kubernetes.models.KubernetesContext;
import org.ballerinax.kubernetes.models.istio.IstioGatewayModel;
import org.ballerinax.kubernetes.models.istio.IstioPortModel;
import org.ballerinax.kubernetes.models.istio.IstioServerModel;
import org.ballerinax.kubernetes.processors.AbstractAnnotationProcessor;
import org.ballerinax.kubernetes.utils.KubernetesUtils;
import org.wso2.ballerinalang.compiler.tree.BLangAnnotationAttachment;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangListConstructorExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRecordLiteral;

public class IstioGatewayAnnotationProcessor
extends AbstractAnnotationProcessor {
    @Override
    public void processAnnotation(ServiceNode serviceNode, AnnotationAttachmentNode attachmentNode) throws KubernetesPluginException {
        List<BLangRecordLiteral.BLangRecordKeyValueField> keyValues = KubernetesUtils.convertRecordFields(((BLangRecordLiteral)((BLangAnnotationAttachment)attachmentNode).expr).getFields());
        IstioGatewayModel gwModel = this.processIstioGatewayAnnotation(keyValues);
        if (KubernetesUtils.isBlank(gwModel.getName())) {
            gwModel.setName(KubernetesUtils.getValidName(serviceNode.getName().getValue()) + "-istio-gw");
        }
        this.setDefaultValues(gwModel);
        KubernetesContext.getInstance().getDataHolder().addIstioGatewayModel(serviceNode.getName().getValue(), gwModel);
    }

    @Override
    public void processAnnotation(SimpleVariableNode variableNode, AnnotationAttachmentNode attachmentNode) throws KubernetesPluginException {
        List<BLangRecordLiteral.BLangRecordKeyValueField> keyValues = KubernetesUtils.convertRecordFields(((BLangRecordLiteral)((BLangAnnotationAttachment)attachmentNode).expr).getFields());
        IstioGatewayModel gwModel = this.processIstioGatewayAnnotation(keyValues);
        if (KubernetesUtils.isBlank(gwModel.getName())) {
            gwModel.setName(KubernetesUtils.getValidName(variableNode.getName().getValue()) + "-istio-gw");
        }
        this.setDefaultValues(gwModel);
        KubernetesContext.getInstance().getDataHolder().addIstioGatewayModel(variableNode.getName().getValue(), gwModel);
    }

    private void setDefaultValues(IstioGatewayModel gwModel) {
        if (null == gwModel.getServers() || gwModel.getServers().size() == 0) {
            LinkedList<IstioServerModel> serversModel = new LinkedList<IstioServerModel>();
            IstioServerModel serverModel = new IstioServerModel();
            IstioPortModel portModel = new IstioPortModel();
            portModel.setNumber(80);
            portModel.setProtocol("HTTP");
            portModel.setName("http");
            serverModel.setPort(portModel);
            if (null == serverModel.getHosts() || serverModel.getHosts().size() == 0) {
                LinkedList<String> hosts = new LinkedList<String>();
                hosts.add("*");
                serverModel.setHosts(hosts);
            }
            serversModel.add(serverModel);
            gwModel.setServers(serversModel);
        }
    }

    private IstioGatewayModel processIstioGatewayAnnotation(List<BLangRecordLiteral.BLangRecordKeyValueField> gatewayFields) throws KubernetesPluginException {
        IstioGatewayModel gatewayModel = new IstioGatewayModel();
        block7: for (BLangRecordLiteral.BLangRecordKeyValueField gatewayField : gatewayFields) {
            switch (GatewayConfig.valueOf(gatewayField.getKey().toString())) {
                case name: {
                    gatewayModel.setName(KubernetesUtils.getValidName(KubernetesUtils.getStringValue(gatewayField.getValue())));
                    continue block7;
                }
                case labels: {
                    gatewayModel.setLabels(KubernetesUtils.getMap(gatewayField.getValue()));
                    continue block7;
                }
                case annotations: {
                    gatewayModel.setAnnotations(KubernetesUtils.getMap(gatewayField.getValue()));
                    continue block7;
                }
                case selector: {
                    gatewayModel.setSelector(KubernetesUtils.getMap(gatewayField.getValue()));
                    continue block7;
                }
                case servers: {
                    this.processIstioGatewayServerAnnotation(gatewayModel, (BLangListConstructorExpr)gatewayField.getValue());
                    continue block7;
                }
            }
            throw new KubernetesPluginException("unknown field found for istio gateway.");
        }
        return gatewayModel;
    }

    private void processIstioGatewayServerAnnotation(IstioGatewayModel gatewayModel, BLangListConstructorExpr serversField) throws KubernetesPluginException {
        LinkedList<IstioServerModel> servers = new LinkedList<IstioServerModel>();
        for (ExpressionNode serverRecord : serversField.getExpressions()) {
            if (!(serverRecord instanceof BLangRecordLiteral)) continue;
            BLangRecordLiteral serverFieldRecord = (BLangRecordLiteral)serverRecord;
            IstioServerModel server = new IstioServerModel();
            block6: for (BLangRecordLiteral.BLangRecordKeyValueField serverField : KubernetesUtils.convertRecordFields(serverFieldRecord.getFields())) {
                switch (ServerConfig.valueOf(serverField.getKey().toString())) {
                    case port: {
                        BLangRecordLiteral portRecord = (BLangRecordLiteral)serverField.getValue();
                        this.processIstioGatewayPortAnnotation(server, KubernetesUtils.convertRecordFields(portRecord.getFields()));
                        continue block6;
                    }
                    case hosts: {
                        server.setHosts(KubernetesUtils.getList(serverField.getValue()));
                        continue block6;
                    }
                    case tls: {
                        BLangRecordLiteral tlsRecord = (BLangRecordLiteral)serverField.getValue();
                        this.processIstioGatewayTLSAnnotation(server, KubernetesUtils.convertRecordFields(tlsRecord.getFields()));
                        continue block6;
                    }
                }
                throw new KubernetesPluginException("unknown field found for istio gateway server.");
            }
            servers.add(server);
        }
        gatewayModel.setServers(servers);
    }

    private void processIstioGatewayPortAnnotation(IstioServerModel server, List<BLangRecordLiteral.BLangRecordKeyValueField> portFields) throws KubernetesPluginException {
        IstioPortModel portModel = new IstioPortModel();
        block5: for (BLangRecordLiteral.BLangRecordKeyValueField portField : portFields) {
            switch (PortConfig.valueOf(portField.getKey().toString())) {
                case number: {
                    portModel.setNumber(Integer.parseInt(portField.getValue().toString()));
                    continue block5;
                }
                case protocol: {
                    portModel.setProtocol(portField.getValue().toString());
                    continue block5;
                }
                case name: {
                    portModel.setName(portField.getValue().toString());
                    continue block5;
                }
            }
            throw new KubernetesPluginException("unknown field found for istio gateway server port.");
        }
        server.setPort(portModel);
    }

    private void processIstioGatewayTLSAnnotation(IstioServerModel server, List<BLangRecordLiteral.BLangRecordKeyValueField> tlsFields) throws KubernetesPluginException {
        IstioServerModel.TLSOptions tlsOptions = new IstioServerModel.TLSOptions();
        block8: for (BLangRecordLiteral.BLangRecordKeyValueField tlsField : tlsFields) {
            switch (TLSOptionConfig.valueOf(tlsField.getKey().toString())) {
                case httpsRedirect: {
                    tlsOptions.setHttpsRedirect(Boolean.parseBoolean(tlsField.getValue().toString()));
                    continue block8;
                }
                case mode: {
                    tlsOptions.setMode(tlsField.getValue().toString());
                    continue block8;
                }
                case serverCertificate: {
                    tlsOptions.setServerCertificate(tlsField.getValue().toString());
                    continue block8;
                }
                case privateKey: {
                    tlsOptions.setPrivateKey(tlsField.getValue().toString());
                    continue block8;
                }
                case caCertificates: {
                    tlsOptions.setCaCertificates(tlsField.getValue().toString());
                    continue block8;
                }
                case subjectAltNames: {
                    tlsOptions.setSubjectAltNames(KubernetesUtils.getList(tlsField.getValue()));
                    continue block8;
                }
            }
            throw new KubernetesPluginException("unknown field found for istio gateway server tls options.");
        }
        server.setTls(tlsOptions);
    }

    private static enum GatewayConfig {
        name,
        labels,
        annotations,
        selector,
        servers;

    }

    private static enum ServerConfig {
        port,
        hosts,
        tls;

    }

    private static enum PortConfig {
        number,
        protocol,
        name;

    }

    private static enum TLSOptionConfig {
        httpsRedirect,
        mode,
        serverCertificate,
        privateKey,
        caCertificates,
        subjectAltNames;

    }
}

