/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinax.kubernetes.processors.istio;

import java.util.LinkedList;
import java.util.List;
import org.ballerinalang.model.tree.AnnotationAttachmentNode;
import org.ballerinalang.model.tree.ServiceNode;
import org.ballerinalang.model.tree.SimpleVariableNode;
import org.ballerinalang.model.tree.expressions.ExpressionNode;
import org.ballerinax.kubernetes.exceptions.KubernetesPluginException;
import org.ballerinax.kubernetes.models.KubernetesContext;
import org.ballerinax.kubernetes.models.istio.IstioDestination;
import org.ballerinax.kubernetes.models.istio.IstioDestinationWeight;
import org.ballerinax.kubernetes.models.istio.IstioHttpRoute;
import org.ballerinax.kubernetes.models.istio.IstioVirtualServiceModel;
import org.ballerinax.kubernetes.processors.AbstractAnnotationProcessor;
import org.ballerinax.kubernetes.utils.KubernetesUtils;
import org.wso2.ballerinalang.compiler.tree.BLangAnnotationAttachment;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangListConstructorExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRecordLiteral;

public class IstioVirtualServiceAnnotationProcessor
extends AbstractAnnotationProcessor {
    @Override
    public void processAnnotation(ServiceNode serviceNode, AnnotationAttachmentNode attachmentNode) throws KubernetesPluginException {
        List<BLangRecordLiteral.BLangRecordKeyValueField> keyValues = KubernetesUtils.convertRecordFields(((BLangRecordLiteral)((BLangAnnotationAttachment)attachmentNode).expr).getFields());
        IstioVirtualServiceModel vsModel = this.processIstioVSAnnotation(keyValues);
        if (KubernetesUtils.isBlank(vsModel.getName())) {
            vsModel.setName(KubernetesUtils.getValidName(serviceNode.getName().getValue()) + "-istio-vs");
        }
        this.setDefaultValues(vsModel);
        KubernetesContext.getInstance().getDataHolder().addIstioVirtualServiceModel(serviceNode.getName().getValue(), vsModel);
    }

    @Override
    public void processAnnotation(SimpleVariableNode variableNode, AnnotationAttachmentNode attachmentNode) throws KubernetesPluginException {
        List<BLangRecordLiteral.BLangRecordKeyValueField> keyValues = KubernetesUtils.convertRecordFields(((BLangRecordLiteral)((BLangAnnotationAttachment)attachmentNode).expr).getFields());
        IstioVirtualServiceModel vsModel = this.processIstioVSAnnotation(keyValues);
        if (KubernetesUtils.isBlank(vsModel.getName())) {
            vsModel.setName(KubernetesUtils.getValidName(variableNode.getName().getValue()) + "-istio-vs");
        }
        this.setDefaultValues(vsModel);
        KubernetesContext.getInstance().getDataHolder().addIstioVirtualServiceModel(variableNode.getName().getValue(), vsModel);
    }

    private void setDefaultValues(IstioVirtualServiceModel vsModel) {
        if (null == vsModel.getHosts() || vsModel.getHosts().size() == 0) {
            LinkedList<String> hosts = new LinkedList<String>();
            hosts.add("*");
            vsModel.setHosts(hosts);
        }
    }

    private IstioVirtualServiceModel processIstioVSAnnotation(List<BLangRecordLiteral.BLangRecordKeyValueField> vsFields) throws KubernetesPluginException {
        IstioVirtualServiceModel vsModel = new IstioVirtualServiceModel();
        block8: for (BLangRecordLiteral.BLangRecordKeyValueField vsField : vsFields) {
            switch (VSConfig.valueOf(vsField.getKey().toString())) {
                case name: {
                    vsModel.setName(KubernetesUtils.getValidName(KubernetesUtils.getStringValue(vsField.getValue())));
                    continue block8;
                }
                case labels: {
                    vsModel.setLabels(KubernetesUtils.getMap(vsField.getValue()));
                    continue block8;
                }
                case annotations: {
                    vsModel.setAnnotations(KubernetesUtils.getMap(vsField.getValue()));
                    continue block8;
                }
                case hosts: {
                    vsModel.setHosts(KubernetesUtils.getList(vsField.getValue()));
                    continue block8;
                }
                case gateways: {
                    vsModel.setGateways(KubernetesUtils.getList(vsField.getValue()));
                    continue block8;
                }
                case http: {
                    BLangListConstructorExpr httpFields = (BLangListConstructorExpr)vsField.getValue();
                    List<IstioHttpRoute> httpModels = this.processHttpAnnotation(httpFields);
                    vsModel.setHttp(httpModels);
                    continue block8;
                }
            }
            throw new KubernetesPluginException("unknown field found for istio virtual service: " + vsField.getKey().toString());
        }
        return vsModel;
    }

    private List<IstioHttpRoute> processHttpAnnotation(BLangListConstructorExpr httpArray) throws KubernetesPluginException {
        LinkedList<IstioHttpRoute> httpRoutes = new LinkedList<IstioHttpRoute>();
        for (ExpressionNode expression : httpArray.getExpressions()) {
            BLangRecordLiteral httpFields = (BLangRecordLiteral)expression;
            IstioHttpRoute httpRoute = new IstioHttpRoute();
            block6: for (BLangRecordLiteral.BLangRecordKeyValueField httpField : KubernetesUtils.convertRecordFields(httpFields.getFields())) {
                switch (HttpRouteConfig.valueOf(httpField.getKey().toString())) {
                    case route: {
                        BLangListConstructorExpr routeFields = (BLangListConstructorExpr)httpField.getValue();
                        httpRoute.setRoute(this.processRoutesAnnotation(routeFields));
                        continue block6;
                    }
                    case timeout: {
                        httpRoute.setTimeout(KubernetesUtils.getLongValue(httpField.getValue()));
                        continue block6;
                    }
                    case appendHeaders: {
                        httpRoute.setAppendHeaders(KubernetesUtils.getMap(httpField.getValue()));
                        continue block6;
                    }
                }
                throw new KubernetesPluginException("unknown field found for istio virtual service: " + httpField.getKey().toString());
            }
            httpRoutes.add(httpRoute);
        }
        return httpRoutes;
    }

    private List<IstioDestinationWeight> processRoutesAnnotation(BLangListConstructorExpr routeArray) throws KubernetesPluginException {
        LinkedList<IstioDestinationWeight> destinationWeights = new LinkedList<IstioDestinationWeight>();
        for (ExpressionNode expression : routeArray.getExpressions()) {
            BLangRecordLiteral routeFields = (BLangRecordLiteral)expression;
            IstioDestinationWeight destinationWeight = new IstioDestinationWeight();
            block5: for (BLangRecordLiteral.BLangRecordKeyValueField routeField : KubernetesUtils.convertRecordFields(routeFields.getFields())) {
                switch (DestinationWeightConfig.valueOf(routeField.getKey().toString())) {
                    case destination: {
                        BLangRecordLiteral destinationFields = (BLangRecordLiteral)routeField.getValue();
                        IstioDestination destination = this.processDestinationAnnotation(destinationFields);
                        destinationWeight.setDestination(destination);
                        continue block5;
                    }
                    case weight: {
                        destinationWeight.setWeight(KubernetesUtils.getIntValue(routeField.getValue()));
                        continue block5;
                    }
                }
                throw new KubernetesPluginException("unknown field found for istio virtual service: " + routeField.getKey().toString());
            }
            destinationWeights.add(destinationWeight);
        }
        return destinationWeights;
    }

    private IstioDestination processDestinationAnnotation(BLangRecordLiteral destinationFields) throws KubernetesPluginException {
        IstioDestination destination = new IstioDestination();
        block5: for (BLangRecordLiteral.BLangRecordKeyValueField destinationField : KubernetesUtils.convertRecordFields(destinationFields.getFields())) {
            switch (DestinationConfig.valueOf(destinationField.getKey().toString())) {
                case host: {
                    destination.setHost(KubernetesUtils.getStringValue(destinationField.getValue()));
                    continue block5;
                }
                case subset: {
                    destination.setSubset(KubernetesUtils.getStringValue(destinationField.getValue()));
                    continue block5;
                }
                case port: {
                    destination.setPort(KubernetesUtils.getIntValue(destinationField.getValue()));
                    continue block5;
                }
            }
            throw new KubernetesPluginException("unknown field found for istio virtual service.");
        }
        return destination;
    }

    private static enum VSConfig {
        name,
        labels,
        annotations,
        hosts,
        gateways,
        http;

    }

    private static enum HttpRouteConfig {
        route,
        timeout,
        appendHeaders;

    }

    private static enum DestinationWeightConfig {
        destination,
        weight;

    }

    private static enum DestinationConfig {
        host,
        subset,
        port;

    }
}

