/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinax.kubernetes.processors.knative;

import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.ballerinalang.model.tree.AnnotationAttachmentNode;
import org.ballerinalang.model.tree.FunctionNode;
import org.ballerinalang.model.tree.IdentifierNode;
import org.ballerinalang.model.tree.ServiceNode;
import org.ballerinax.kubernetes.exceptions.KubernetesPluginException;
import org.ballerinax.kubernetes.models.knative.ConfigMapModel;
import org.ballerinax.kubernetes.models.knative.KnativeContext;
import org.ballerinax.kubernetes.processors.AbstractAnnotationProcessor;
import org.ballerinax.kubernetes.utils.KnativeUtils;
import org.wso2.ballerinalang.compiler.tree.BLangAnnotationAttachment;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangListConstructorExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRecordLiteral;

public class KnativeConfigMapAnnotationProcessor
extends AbstractAnnotationProcessor {
    @Override
    public void processAnnotation(ServiceNode serviceNode, AnnotationAttachmentNode attachmentNode) throws KubernetesPluginException {
        this.processConfigMaps(serviceNode.getName(), attachmentNode);
    }

    @Override
    public void processAnnotation(FunctionNode functionNode, AnnotationAttachmentNode attachmentNode) throws KubernetesPluginException {
        if (!"main".equals(functionNode.getName().getValue())) {
            throw new KubernetesPluginException("@kubernetes:ConfigMap{} annotation cannot be attached to a non main function.");
        }
        this.processConfigMaps(functionNode.getName(), attachmentNode);
    }

    private void processConfigMaps(IdentifierNode nodeID, AnnotationAttachmentNode attachmentNode) throws KubernetesPluginException {
        HashSet<ConfigMapModel> configMapModels = new HashSet<ConfigMapModel>();
        List<BLangRecordLiteral.BLangRecordKeyValueField> keyValues = KnativeUtils.convertRecordFields(((BLangRecordLiteral)((BLangAnnotationAttachment)attachmentNode).expr).getFields());
        block16: for (BLangRecordLiteral.BLangRecordKeyValueField keyValue : keyValues) {
            String key;
            switch (key = keyValue.getKey().toString()) {
                case "configMaps": {
                    List configAnnotation = ((BLangListConstructorExpr)keyValue.valueExpr).exprs;
                    for (BLangExpression bLangExpression : configAnnotation) {
                        ConfigMapModel configMapModel = new ConfigMapModel();
                        List<BLangRecordLiteral.BLangRecordKeyValueField> annotationValues = KnativeUtils.convertRecordFields(((BLangRecordLiteral)bLangExpression).getFields());
                        for (BLangRecordLiteral.BLangRecordKeyValueField annotation : annotationValues) {
                            ConfigMapMountConfig volumeMountConfig = ConfigMapMountConfig.valueOf(annotation.getKey().toString());
                            switch (volumeMountConfig) {
                                case name: {
                                    configMapModel.setName(KnativeUtils.getValidName(KnativeUtils.getStringValue(annotation.getValue())));
                                    break;
                                }
                                case labels: {
                                    configMapModel.setLabels(KnativeUtils.getMap(keyValue.getValue()));
                                    break;
                                }
                                case annotations: {
                                    configMapModel.setAnnotations(KnativeUtils.getMap(keyValue.getValue()));
                                    break;
                                }
                                case mountPath: {
                                    Path mountPath = Paths.get(KnativeUtils.getStringValue(annotation.getValue()), new String[0]);
                                    Path homePath = Paths.get("/home/ballerina", new String[0]);
                                    Path runtimePath = Paths.get("/ballerina/runtime", new String[0]);
                                    Path confPath = Paths.get("/home/ballerina/conf/", new String[0]);
                                    if (mountPath.equals(homePath)) {
                                        throw new KubernetesPluginException("@kubernetes:ConfigMap{} mount path cannot be ballerina home: /home/ballerina");
                                    }
                                    if (mountPath.equals(runtimePath)) {
                                        throw new KubernetesPluginException("@kubernetes:ConfigMap{} mount path cannot be ballerina runtime: /ballerina/runtime");
                                    }
                                    if (mountPath.equals(confPath)) {
                                        throw new KubernetesPluginException("@kubernetes:ConfigMap{} mount path cannot be ballerina conf file mount path: /home/ballerina/conf/");
                                    }
                                    configMapModel.setMountPath(KnativeUtils.getStringValue(annotation.getValue()));
                                    break;
                                }
                                case data: {
                                    List data = ((BLangListConstructorExpr)annotation.valueExpr).exprs;
                                    configMapModel.setData(this.getDataForConfigMap(data));
                                    break;
                                }
                                case readOnly: {
                                    configMapModel.setReadOnly(KnativeUtils.getBooleanValue(annotation.getValue()));
                                    break;
                                }
                            }
                        }
                        if (KnativeUtils.isBlank(configMapModel.getName())) {
                            configMapModel.setName(KnativeUtils.getValidName(nodeID.getValue()) + "-config-map");
                        }
                        if (configMapModel.getData() == null || configMapModel.getData().size() <= 0) continue;
                        configMapModels.add(configMapModel);
                    }
                    continue block16;
                }
                case "conf": {
                    configMapModels.add(this.getBallerinaConfConfigMap(keyValue.getValue().toString(), nodeID.getValue()));
                    break;
                }
            }
        }
        KnativeContext.getInstance().getDataHolder().addConfigMaps(configMapModels);
    }

    private Map<String, String> getDataForConfigMap(List<BLangExpression> data) throws KubernetesPluginException {
        HashMap<String, String> dataMap = new HashMap<String, String>();
        for (BLangExpression bLangExpression : data) {
            Path dataFilePath = Paths.get(((BLangLiteral)bLangExpression).getValue().toString(), new String[0]);
            if (!dataFilePath.isAbsolute()) {
                dataFilePath = KnativeContext.getInstance().getDataHolder().getSourceRoot().resolve(dataFilePath);
            }
            String key = String.valueOf(dataFilePath.getFileName());
            String content = new String(KnativeUtils.readFileContent(dataFilePath), StandardCharsets.UTF_8);
            dataMap.put(key, content);
        }
        return dataMap;
    }

    private ConfigMapModel getBallerinaConfConfigMap(String configFilePath, String serviceName) throws KubernetesPluginException {
        ConfigMapModel configMapModel = new ConfigMapModel();
        configMapModel.setName(KnativeUtils.getValidName(serviceName) + "-ballerina-conf" + "-config-map");
        configMapModel.setMountPath("/home/ballerina/conf/");
        Path dataFilePath = Paths.get(configFilePath, new String[0]);
        if (!dataFilePath.isAbsolute()) {
            dataFilePath = KnativeContext.getInstance().getDataHolder().getSourceRoot().resolve(dataFilePath).normalize();
        }
        String content = new String(KnativeUtils.readFileContent(dataFilePath), StandardCharsets.UTF_8);
        HashMap<String, String> dataMap = new HashMap<String, String>();
        dataMap.put("ballerina.conf", content);
        configMapModel.setData(dataMap);
        configMapModel.setBallerinaConf(configFilePath);
        configMapModel.setReadOnly(false);
        return configMapModel;
    }

    private static enum ConfigMapMountConfig {
        name,
        labels,
        annotations,
        mountPath,
        readOnly,
        data;

    }
}

