/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinax.kubernetes.specs;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.Affinity;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.HostAlias;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.PodDNSConfig;
import io.fabric8.kubernetes.api.model.PodReadinessGate;
import io.fabric8.kubernetes.api.model.PodSecurityContext;
import io.fabric8.kubernetes.api.model.Toleration;
import io.fabric8.kubernetes.api.model.Volume;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"apiVersion", "kind", "metadata", "containerConcurrency", "containers", "imagePullSecrets", "initContainers", "readinessGates", "securityContext", "serviceAccount", "serviceAccountName", "tolerations", "timeoutSeconds", "volumes"})
@JsonDeserialize(using=JsonDeserializer.None.class)
public class KnativePodSpec
implements KubernetesResource {
    private static final long serialVersionUID = 6106269076155338045L;
    @JsonProperty(value="containerConcurrency")
    @Valid
    private Integer containerConcurrency;
    @JsonProperty(value="timeoutSeconds")
    @Valid
    private Integer timeoutSeconds;
    @JsonProperty(value="containers")
    @Valid
    private List<Container> containers = new ArrayList<Container>();
    @JsonProperty(value="imagePullSecrets")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @Valid
    private List<LocalObjectReference> imagePullSecrets = new ArrayList<LocalObjectReference>();
    @JsonProperty(value="initContainers")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @Valid
    private List<Container> initContainers = new ArrayList<Container>();
    @JsonProperty(value="readinessGates")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @Valid
    private List<PodReadinessGate> readinessGates = new ArrayList<PodReadinessGate>();
    @JsonProperty(value="securityContext")
    @Valid
    private PodSecurityContext securityContext;
    @JsonProperty(value="serviceAccount")
    private String serviceAccount;
    @JsonProperty(value="serviceAccountName")
    private String serviceAccountName;
    @JsonProperty(value="tolerations")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @Valid
    private List<Toleration> tolerations = new ArrayList<Toleration>();
    @JsonProperty(value="volumes")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @Valid
    private List<Volume> volumes = new ArrayList<Volume>();
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public KnativePodSpec() {
    }

    public KnativePodSpec(Long activeDeadlineSeconds, Affinity affinity, Boolean automountServiceAccountToken, Integer containerConcurrency, List<Container> containers, PodDNSConfig dnsConfig, String dnsPolicy, Boolean enableServiceLinks, List<HostAlias> hostAliases, Boolean hostIPC, Boolean hostNetwork, Boolean hostPID, String hostname, List<LocalObjectReference> imagePullSecrets, List<Container> initContainers, String nodeName, Map<String, String> nodeSelector, Integer priority, String priorityClassName, List<PodReadinessGate> readinessGates, String restartPolicy, String runtimeClassName, String schedulerName, PodSecurityContext securityContext, String serviceAccount, String serviceAccountName, Boolean shareProcessNamespace, String subdomain, Long terminationGracePeriodSeconds, List<Toleration> tolerations, Integer timeoutSeconds, List<Volume> volumes) {
        this.containerConcurrency = containerConcurrency;
        this.containers = containers;
        this.imagePullSecrets = imagePullSecrets;
        this.initContainers = initContainers;
        this.readinessGates = readinessGates;
        this.securityContext = securityContext;
        this.serviceAccount = serviceAccount;
        this.serviceAccountName = serviceAccountName;
        this.tolerations = tolerations;
        this.volumes = volumes;
        this.timeoutSeconds = timeoutSeconds;
    }

    @JsonProperty(value="containerConcurrency")
    public Integer getContainerConcurrency() {
        return this.containerConcurrency;
    }

    @JsonProperty(value="containerConcurrency")
    public void setContainerConcurrency(Integer containerConcurrency) {
        this.containerConcurrency = containerConcurrency;
    }

    @JsonProperty(value="timeoutSeconds")
    public Integer getTimeOutSeconds() {
        return this.timeoutSeconds;
    }

    @JsonProperty(value="timeoutSeconds")
    public void setTimeOutSeconds(Integer timeoutSeconds) {
        this.timeoutSeconds = timeoutSeconds;
    }

    @JsonProperty(value="containers")
    public List<Container> getContainers() {
        return this.containers;
    }

    @JsonProperty(value="containers")
    public void setContainers(List<Container> containers) {
        this.containers = containers;
    }

    @JsonProperty(value="imagePullSecrets")
    public List<LocalObjectReference> getImagePullSecrets() {
        return this.imagePullSecrets;
    }

    @JsonProperty(value="imagePullSecrets")
    public void setImagePullSecrets(List<LocalObjectReference> imagePullSecrets) {
        this.imagePullSecrets = imagePullSecrets;
    }

    @JsonProperty(value="initContainers")
    public List<Container> getInitContainers() {
        return this.initContainers;
    }

    @JsonProperty(value="initContainers")
    public void setInitContainers(List<Container> initContainers) {
        this.initContainers = initContainers;
    }

    @JsonProperty(value="readinessGates")
    public List<PodReadinessGate> getReadinessGates() {
        return this.readinessGates;
    }

    @JsonProperty(value="readinessGates")
    public void setReadinessGates(List<PodReadinessGate> readinessGates) {
        this.readinessGates = readinessGates;
    }

    @JsonProperty(value="securityContext")
    public PodSecurityContext getSecurityContext() {
        return this.securityContext;
    }

    @JsonProperty(value="securityContext")
    public void setSecurityContext(PodSecurityContext securityContext) {
        this.securityContext = securityContext;
    }

    @JsonProperty(value="serviceAccount")
    public String getServiceAccount() {
        return this.serviceAccount;
    }

    @JsonProperty(value="serviceAccount")
    public void setServiceAccount(String serviceAccount) {
        this.serviceAccount = serviceAccount;
    }

    @JsonProperty(value="serviceAccountName")
    public String getServiceAccountName() {
        return this.serviceAccountName;
    }

    @JsonProperty(value="serviceAccountName")
    public void setServiceAccountName(String serviceAccountName) {
        this.serviceAccountName = serviceAccountName;
    }

    @JsonProperty(value="tolerations")
    public List<Toleration> getTolerations() {
        return this.tolerations;
    }

    @JsonProperty(value="tolerations")
    public void setTolerations(List<Toleration> tolerations) {
        this.tolerations = tolerations;
    }

    @JsonProperty(value="volumes")
    public List<Volume> getVolumes() {
        return this.volumes;
    }

    @JsonProperty(value="volumes")
    public void setVolumes(List<Volume> volumes) {
        this.volumes = volumes;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }
}

