/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinax.kubernetes.utils;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class DependencyValidator {
    private Map<String, Node> nodesMap = new HashMap<String, Node>();

    private Node getOrCreateNode(String nodeName) {
        Node currentNode;
        if (!this.nodesMap.containsKey(nodeName)) {
            currentNode = new Node(nodeName);
            this.nodesMap.put(nodeName, currentNode);
        } else {
            currentNode = this.nodesMap.get(nodeName);
        }
        return currentNode;
    }

    public boolean validateDependency(String ... dependencyChain) {
        String nodeName = dependencyChain[0];
        Node node = this.getOrCreateNode(nodeName);
        for (int i = 1; i < dependencyChain.length; ++i) {
            if (node.addChild(this.getOrCreateNode(dependencyChain[i]))) continue;
            return false;
        }
        return true;
    }

    private static class Node
    implements Comparable<Node> {
        Set<Node> children = new HashSet<Node>();
        String dependencies;

        Node(String dependencies) {
            this.dependencies = dependencies;
        }

        private boolean addChild(Node n) {
            if (n.allDescendants().contains(this)) {
                return false;
            }
            this.children.add(n);
            return true;
        }

        Set<Node> allDescendants() {
            TreeSet<Node> all = new TreeSet<Node>();
            for (Node c : this.children) {
                all.add(c);
                all.addAll(c.allDescendants());
            }
            return all;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Node node = (Node)o;
            return this.dependencies != null ? this.dependencies.equals(node.dependencies) : node.dependencies == null;
        }

        public int hashCode() {
            return this.dependencies != null ? this.dependencies.hashCode() : 0;
        }

        @Override
        public int compareTo(Node o) {
            return this.dependencies.compareTo(o.dependencies);
        }
    }
}

