/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.messaging.broker.common.data.types;

import io.ballerina.messaging.broker.common.data.types.EncodableData;
import io.netty.buffer.ByteBuf;

public class ShortInt
implements EncodableData {
    private final short value;

    private ShortInt(short value) {
        this.value = value;
    }

    @Override
    public long getSize() {
        return 2L;
    }

    @Override
    public void write(ByteBuf buf) {
        buf.writeShort((int)this.value);
    }

    public short getShort() {
        return this.value;
    }

    public int hashCode() {
        return this.value;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        return obj instanceof ShortInt && this.value == ((ShortInt)obj).value;
    }

    public static ShortInt parse(ByteBuf buf) {
        return new ShortInt(buf.readShort());
    }

    public static ShortInt parse(short value) {
        return new ShortInt(value);
    }

    @Override
    public String toString() {
        return String.valueOf(this.value);
    }
}

