/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver;

import com.google.gson.JsonObject;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.locks.Lock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.ballerinalang.langserver.BallerinaLanguageServer;
import org.ballerinalang.langserver.DocumentServiceOperationContext;
import org.ballerinalang.langserver.LSContextOperation;
import org.ballerinalang.langserver.LSGlobalContext;
import org.ballerinalang.langserver.LSGlobalContextKeys;
import org.ballerinalang.langserver.client.ExtendedLanguageClient;
import org.ballerinalang.langserver.codeaction.CodeActionRouter;
import org.ballerinalang.langserver.codeaction.CodeActionUtil;
import org.ballerinalang.langserver.codelenses.CodeLensUtil;
import org.ballerinalang.langserver.codelenses.LSCodeLensesProviderHolder;
import org.ballerinalang.langserver.common.CommonKeys;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.commons.LSContext;
import org.ballerinalang.langserver.commons.capability.LSClientCapabilities;
import org.ballerinalang.langserver.commons.codeaction.CodeActionKeys;
import org.ballerinalang.langserver.commons.codeaction.CodeActionNodeType;
import org.ballerinalang.langserver.commons.workspace.LSDocumentIdentifier;
import org.ballerinalang.langserver.commons.workspace.WorkspaceDocumentManager;
import org.ballerinalang.langserver.compiler.DocumentServiceKeys;
import org.ballerinalang.langserver.compiler.LSClientLogger;
import org.ballerinalang.langserver.compiler.LSCompilerCache;
import org.ballerinalang.langserver.compiler.LSCompilerUtil;
import org.ballerinalang.langserver.compiler.LSModuleCompiler;
import org.ballerinalang.langserver.compiler.common.LSCustomErrorStrategy;
import org.ballerinalang.langserver.compiler.common.LSDocumentIdentifierImpl;
import org.ballerinalang.langserver.compiler.config.LSClientConfigHolder;
import org.ballerinalang.langserver.compiler.exception.CompilationFailedException;
import org.ballerinalang.langserver.compiler.format.FormattingVisitorEntry;
import org.ballerinalang.langserver.compiler.format.TextDocumentFormatUtil;
import org.ballerinalang.langserver.compiler.sourcegen.FormattingSourceGen;
import org.ballerinalang.langserver.completions.exceptions.CompletionContextNotSupportedException;
import org.ballerinalang.langserver.completions.util.CompletionUtil;
import org.ballerinalang.langserver.diagnostic.DiagnosticsHelper;
import org.ballerinalang.langserver.exception.UserErrorException;
import org.ballerinalang.langserver.extensions.ballerina.semantichighlighter.HighlightingFailedException;
import org.ballerinalang.langserver.extensions.ballerina.semantichighlighter.SemanticHighlightProvider;
import org.ballerinalang.langserver.implementation.GotoImplementationCustomErrorStrategy;
import org.ballerinalang.langserver.implementation.GotoImplementationUtil;
import org.ballerinalang.langserver.signature.SignatureHelpUtil;
import org.ballerinalang.langserver.signature.SignatureTreeVisitor;
import org.ballerinalang.langserver.symbols.SymbolFindingVisitor;
import org.ballerinalang.langserver.util.Debouncer;
import org.ballerinalang.langserver.util.definition.DefinitionUtil;
import org.ballerinalang.langserver.util.references.ReferencesUtil;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.CodeLens;
import org.eclipse.lsp4j.CodeLensParams;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionList;
import org.eclipse.lsp4j.CompletionParams;
import org.eclipse.lsp4j.DidChangeTextDocumentParams;
import org.eclipse.lsp4j.DidCloseTextDocumentParams;
import org.eclipse.lsp4j.DidOpenTextDocumentParams;
import org.eclipse.lsp4j.DidSaveTextDocumentParams;
import org.eclipse.lsp4j.DocumentFormattingParams;
import org.eclipse.lsp4j.DocumentHighlight;
import org.eclipse.lsp4j.DocumentSymbol;
import org.eclipse.lsp4j.DocumentSymbolParams;
import org.eclipse.lsp4j.Hover;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.LocationLink;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.ReferenceParams;
import org.eclipse.lsp4j.RenameParams;
import org.eclipse.lsp4j.SignatureHelp;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.TextDocumentContentChangeEvent;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.TextDocumentPositionParams;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.services.TextDocumentService;
import org.wso2.ballerinalang.compiler.semantics.model.Scope;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BInvokableSymbol;
import org.wso2.ballerinalang.compiler.tree.BLangCompilationUnit;
import org.wso2.ballerinalang.compiler.tree.BLangNodeVisitor;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;

class BallerinaTextDocumentService
implements TextDocumentService {
    private static final int DIAG_PUSH_DEBOUNCE_DELAY = 750;
    private final BallerinaLanguageServer languageServer;
    private final WorkspaceDocumentManager docManager;
    private final DiagnosticsHelper diagnosticsHelper;
    private LSClientCapabilities clientCapabilities;
    private boolean enableStdlibDefinition = true;
    private final Debouncer diagPushDebouncer;

    BallerinaTextDocumentService(LSGlobalContext globalContext) {
        this.languageServer = globalContext.get(LSGlobalContextKeys.LANGUAGE_SERVER_KEY);
        this.docManager = globalContext.get(LSGlobalContextKeys.DOCUMENT_MANAGER_KEY);
        this.diagnosticsHelper = globalContext.get(LSGlobalContextKeys.DIAGNOSTIC_HELPER_KEY);
        LSClientConfigHolder.getInstance().register((oldConfig, newConfig) -> {
            this.enableStdlibDefinition = newConfig.getGoToDefinition().isEnableStdlib();
        });
        this.diagPushDebouncer = new Debouncer(750);
    }

    void setClientCapabilities(LSClientCapabilities clientCapabilities) {
        this.clientCapabilities = clientCapabilities;
    }

    public CompletableFuture<Either<List<CompletionItem>, CompletionList>> completion(CompletionParams position) {
        ArrayList completions = new ArrayList();
        return CompletableFuture.supplyAsync(() -> {
            String fileUri = position.getTextDocument().getUri();
            Optional<Path> completionPath = CommonUtil.getPathFromURI(fileUri);
            if (!completionPath.isPresent() || CommonUtil.isCachedExternalSource(fileUri)) {
                return Either.forLeft((Object)completions);
            }
            Path compilationPath = LSCompilerUtil.getUntitledFilePath((String)completionPath.toString()).orElse(completionPath.get());
            Optional lock = this.docManager.lockFile(compilationPath);
            LSContext context = ((DocumentServiceOperationContext.ServiceOperationContextBuilder)new DocumentServiceOperationContext.ServiceOperationContextBuilder(LSContextOperation.TXT_COMPLETION).withCommonParams((TextDocumentPositionParams)position, fileUri, this.docManager)).withCompletionParams(this.clientCapabilities.getTextDocCapabilities().getCompletion()).build();
            try {
                CompletionUtil.pruneSource(context);
                LSModuleCompiler.getBLangPackage((LSContext)context, (WorkspaceDocumentManager)this.docManager, null, (boolean)false, (boolean)false);
                this.docManager.resetPrunedContent(Paths.get(URI.create(fileUri)));
                context.put(DocumentServiceKeys.CURRENT_DOC_IMPORTS_KEY, CommonUtil.getCurrentFileImports(context));
                CompletionUtil.resolveSymbols(context);
                completions.addAll(CompletionUtil.getCompletionItems(context));
            }
            catch (CompletionContextNotSupportedException completionContextNotSupportedException) {
            }
            catch (Throwable e) {
                String msg = "Operation 'text/completion' failed!";
                LSClientLogger.logError((String)msg, (Throwable)e, (TextDocumentIdentifier)position.getTextDocument(), (Position[])new Position[]{position.getPosition()});
            }
            finally {
                lock.ifPresent(Lock::unlock);
            }
            return Either.forLeft((Object)completions);
        });
    }

    public CompletableFuture<CompletionItem> resolveCompletionItem(CompletionItem unresolved) {
        return null;
    }

    public CompletableFuture<Hover> hover(TextDocumentPositionParams position) {
        return CompletableFuture.supplyAsync(() -> {
            Hover hover;
            String fileUri = position.getTextDocument().getUri();
            if (CommonUtil.isCachedExternalSource(fileUri)) {
                return null;
            }
            LSContext context = ((DocumentServiceOperationContext.ServiceOperationContextBuilder)new DocumentServiceOperationContext.ServiceOperationContextBuilder(LSContextOperation.TXT_HOVER).withCommonParams(position, fileUri, this.docManager)).withHoverParams().build();
            try {
                hover = ReferencesUtil.getHover(context);
            }
            catch (Throwable e) {
                String msg = "Operation 'text/hover' failed!";
                LSClientLogger.logError((String)msg, (Throwable)e, (TextDocumentIdentifier)position.getTextDocument(), (Position[])new Position[]{position.getPosition()});
                hover = new Hover();
                ArrayList<Either> contents = new ArrayList<Either>();
                contents.add(Either.forLeft((Object)""));
                hover.setContents(contents);
            }
            return hover;
        });
    }

    public CompletableFuture<SignatureHelp> signatureHelp(TextDocumentPositionParams position) {
        return CompletableFuture.supplyAsync(() -> {
            String uri = position.getTextDocument().getUri();
            Optional<Path> sigFilePath = CommonUtil.getPathFromURI(uri);
            if (!sigFilePath.isPresent() || CommonUtil.isCachedExternalSource(uri)) {
                return new SignatureHelp();
            }
            Path compilationPath = LSCompilerUtil.getUntitledFilePath((String)sigFilePath.toString()).orElse(sigFilePath.get());
            Optional lock = this.docManager.lockFile(compilationPath);
            LSContext context = ((DocumentServiceOperationContext.ServiceOperationContextBuilder)new DocumentServiceOperationContext.ServiceOperationContextBuilder(LSContextOperation.TXT_SIGNATURE).withCommonParams(position, uri, this.docManager)).withSignatureParams(this.clientCapabilities.getTextDocCapabilities().getSignatureHelp()).build();
            try {
                SignatureHelpUtil.pruneSource(context);
                BLangPackage bLangPackage = LSModuleCompiler.getBLangPackage((LSContext)context, (WorkspaceDocumentManager)this.docManager, LSCustomErrorStrategy.class, (boolean)false, (boolean)false);
                this.docManager.resetPrunedContent(Paths.get(URI.create(uri)));
                SignatureTreeVisitor signatureTreeVisitor = new SignatureTreeVisitor(context);
                bLangPackage.accept((BLangNodeVisitor)signatureTreeVisitor);
                int activeParamIndex = 0;
                List visibleSymbols = (List)context.get(CommonKeys.VISIBLE_SYMBOLS_KEY);
                if (visibleSymbols == null) {
                    throw new Exception("Couldn't find the symbol, visible symbols are NULL!");
                }
                ArrayList signatures = new ArrayList();
                ArrayList symbols = new ArrayList(visibleSymbols);
                Pair<Optional<String>, Integer> funcPathAndParamIndexPair = SignatureHelpUtil.getFunctionInvocationDetails(context);
                Optional funcPath = (Optional)funcPathAndParamIndexPair.getLeft();
                activeParamIndex = (Integer)funcPathAndParamIndexPair.getRight();
                funcPath.ifPresent(pathStr -> {
                    Optional<Scope.ScopeEntry> searchSymbol = SignatureHelpUtil.getFuncScopeEntry(context, pathStr, symbols);
                    searchSymbol.ifPresent(entry -> {
                        if (entry.symbol instanceof BInvokableSymbol) {
                            BInvokableSymbol symbol = (BInvokableSymbol)entry.symbol;
                            signatures.add(SignatureHelpUtil.getSignatureInformation(symbol, context));
                        }
                    });
                });
                SignatureHelp signatureHelp = new SignatureHelp();
                signatureHelp.setActiveParameter(Integer.valueOf(activeParamIndex));
                signatureHelp.setActiveSignature(Integer.valueOf(0));
                signatureHelp.setSignatures(signatures);
                SignatureHelp signatureHelp2 = signatureHelp;
                return signatureHelp2;
            }
            catch (UserErrorException e) {
                LSClientLogger.notifyUser((String)"Signature Help", (Throwable)e);
                SignatureHelp signatureTreeVisitor = new SignatureHelp();
                return signatureTreeVisitor;
            }
            catch (Throwable e) {
                String msg = "Operation 'text/signature' failed!";
                LSClientLogger.logError((String)msg, (Throwable)e, (TextDocumentIdentifier)position.getTextDocument(), (Position[])new Position[]{position.getPosition()});
                SignatureHelp signatureHelp = new SignatureHelp();
                return signatureHelp;
            }
            finally {
                lock.ifPresent(Lock::unlock);
            }
        });
    }

    public CompletableFuture<Either<List<? extends Location>, List<? extends LocationLink>>> definition(TextDocumentPositionParams position) {
        return CompletableFuture.supplyAsync(() -> {
            String fileUri = position.getTextDocument().getUri();
            LSContext context = ((DocumentServiceOperationContext.ServiceOperationContextBuilder)new DocumentServiceOperationContext.ServiceOperationContextBuilder(LSContextOperation.TXT_DEFINITION).withCommonParams(position, fileUri, this.docManager)).withDefinitionParams(fileUri).withStdLibDefinitionParam(this.enableStdlibDefinition).build();
            try {
                return Either.forLeft(DefinitionUtil.getDefinition(context));
            }
            catch (UserErrorException e) {
                LSClientLogger.notifyUser((String)"Goto Definition", (Throwable)e);
                return Either.forLeft(new ArrayList());
            }
            catch (Throwable e) {
                String msg = "Operation 'text/definition' failed!";
                LSClientLogger.logError((String)msg, (Throwable)e, (TextDocumentIdentifier)position.getTextDocument(), (Position[])new Position[]{position.getPosition()});
                return Either.forLeft(new ArrayList());
            }
        });
    }

    public CompletableFuture<List<? extends Location>> references(ReferenceParams params) {
        return CompletableFuture.supplyAsync(() -> {
            String fileUri = params.getTextDocument().getUri();
            if (CommonUtil.isCachedExternalSource(fileUri)) {
                return null;
            }
            TextDocumentPositionParams pos = new TextDocumentPositionParams(params.getTextDocument(), params.getPosition());
            LSContext context = ((DocumentServiceOperationContext.ServiceOperationContextBuilder)new DocumentServiceOperationContext.ServiceOperationContextBuilder(LSContextOperation.TXT_REFERENCES).withCommonParams(pos, fileUri, this.docManager)).withReferencesParams().build();
            try {
                boolean includeDeclaration = params.getContext().isIncludeDeclaration();
                return ReferencesUtil.getReferences(context, includeDeclaration);
            }
            catch (UserErrorException e) {
                LSClientLogger.notifyUser((String)"Find References", (Throwable)e);
                return new ArrayList();
            }
            catch (Throwable e) {
                String msg = "Operation 'text/references' failed!";
                LSClientLogger.logError((String)msg, (Throwable)e, (TextDocumentIdentifier)params.getTextDocument(), (Position[])new Position[]{params.getPosition()});
                return new ArrayList();
            }
        });
    }

    public CompletableFuture<List<? extends DocumentHighlight>> documentHighlight(TextDocumentPositionParams position) {
        return null;
    }

    public CompletableFuture<List<Either<SymbolInformation, DocumentSymbol>>> documentSymbol(DocumentSymbolParams params) {
        return CompletableFuture.supplyAsync(() -> {
            String fileUri = params.getTextDocument().getUri();
            Optional<Path> docSymbolFilePath = CommonUtil.getPathFromURI(fileUri);
            if (!docSymbolFilePath.isPresent() || CommonUtil.isCachedExternalSource(fileUri)) {
                return new ArrayList();
            }
            Path compilationPath = LSCompilerUtil.getUntitledFilePath((String)docSymbolFilePath.toString()).orElse(docSymbolFilePath.get());
            Optional lock = this.docManager.lockFile(compilationPath);
            try {
                LSContext context = new DocumentServiceOperationContext.ServiceOperationContextBuilder(LSContextOperation.TXT_DOC_SYMBOL).withDocumentSymbolParams(fileUri).build();
                BLangPackage bLangPackage = LSModuleCompiler.getBLangPackage((LSContext)context, (WorkspaceDocumentManager)this.docManager, LSCustomErrorStrategy.class, (boolean)false, (boolean)false);
                Optional<BLangCompilationUnit> documentCUnit = bLangPackage.getCompilationUnits().stream().filter(cUnit -> fileUri.endsWith(cUnit.getName())).findFirst();
                documentCUnit.ifPresent(cUnit -> {
                    SymbolFindingVisitor visitor = new SymbolFindingVisitor(context);
                    cUnit.accept((BLangNodeVisitor)visitor);
                });
                List list = (List)context.get(DocumentServiceKeys.SYMBOL_LIST_KEY);
                return list;
            }
            catch (UserErrorException e) {
                LSClientLogger.notifyUser((String)"Document Symbols", (Throwable)e);
                ArrayList bLangPackage = new ArrayList();
                return bLangPackage;
            }
            catch (Throwable e) {
                String msg = "Operation 'text/documentSymbol' failed!";
                LSClientLogger.logError((String)msg, (Throwable)e, (TextDocumentIdentifier)params.getTextDocument(), (Position[])new Position[]{null});
                ArrayList arrayList = new ArrayList();
                return arrayList;
            }
            finally {
                lock.ifPresent(Lock::unlock);
            }
        });
    }

    public CompletableFuture<List<Either<Command, CodeAction>>> codeAction(CodeActionParams params) {
        return CompletableFuture.supplyAsync(() -> {
            List<Object> actions = new ArrayList();
            TextDocumentIdentifier identifier = params.getTextDocument();
            String fileUri = identifier.getUri();
            Optional<Path> filePath = CommonUtil.getPathFromURI(fileUri);
            if (!filePath.isPresent() || CommonUtil.isCachedExternalSource(fileUri)) {
                return new ArrayList();
            }
            Path compilationPath = LSCompilerUtil.getUntitledFilePath((String)filePath.get().toString()).orElse(filePath.get());
            Optional lock = this.docManager.lockFile(compilationPath);
            int line = params.getRange().getStart().getLine();
            int col = params.getRange().getStart().getCharacter();
            TextDocumentPositionParams positionParams = new TextDocumentPositionParams(params.getTextDocument(), new Position(line, col));
            LSContext context = ((DocumentServiceOperationContext.ServiceOperationContextBuilder)new DocumentServiceOperationContext.ServiceOperationContextBuilder(LSContextOperation.TXT_CODE_ACTION).withCommonParams(positionParams, fileUri, this.docManager)).withCodeActionParams(params.getRange().getStart()).build();
            try {
                CodeActionNodeType nodeType = CodeActionUtil.topLevelNodeInLine(context, identifier, line, this.docManager);
                List rangeDiagnostics = params.getContext().getDiagnostics();
                List allDiagnostics = (List)context.get(CodeActionKeys.DIAGNOSTICS_KEY);
                actions = CodeActionRouter.getBallerinaCodeActions(nodeType, context, rangeDiagnostics, allDiagnostics);
            }
            catch (UserErrorException e) {
                LSClientLogger.notifyUser((String)"Code Action", (Throwable)e);
            }
            catch (Throwable e) {
                String msg = "Operation 'text/codeAction' failed!";
                Range range = params.getRange();
                LSClientLogger.logError((String)msg, (Throwable)e, (TextDocumentIdentifier)params.getTextDocument(), (Position[])new Position[]{range.getStart(), range.getEnd()});
            }
            finally {
                lock.ifPresent(Lock::unlock);
            }
            return actions.stream().map(Either::forRight).collect(Collectors.toList());
        });
    }

    public CompletableFuture<List<? extends CodeLens>> codeLens(CodeLensParams params) {
        return CompletableFuture.supplyAsync(() -> {
            if (!LSCodeLensesProviderHolder.getInstance().isEnabled()) {
                this.clientCapabilities.getTextDocCapabilities().setCodeLens(null);
                return new ArrayList();
            }
            String fileUri = params.getTextDocument().getUri();
            Optional<Path> docSymbolFilePath = CommonUtil.getPathFromURI(fileUri);
            if (!docSymbolFilePath.isPresent() || CommonUtil.isCachedExternalSource(fileUri)) {
                return new ArrayList();
            }
            Path compilationPath = LSCompilerUtil.getUntitledFilePath((String)docSymbolFilePath.toString()).orElse(docSymbolFilePath.get());
            Optional lock = this.docManager.lockFile(compilationPath);
            try {
                List<CodeLens> lenses = CodeLensUtil.compileAndGetCodeLenses(fileUri, this.docManager);
                this.docManager.setCodeLenses(compilationPath, lenses);
                List<CodeLens> list = lenses;
                return list;
            }
            catch (UserErrorException e) {
                LSClientLogger.notifyUser((String)"Code Lens", (Throwable)e);
                List list = this.docManager.getCodeLenses(compilationPath);
                return list;
            }
            catch (Throwable e) {
                String msg = "Operation 'text/codeLens' failed!";
                LSClientLogger.logError((String)msg, (Throwable)e, (TextDocumentIdentifier)params.getTextDocument(), (Position[])new Position[]{null});
                List list = this.docManager.getCodeLenses(compilationPath);
                return list;
            }
            finally {
                lock.ifPresent(Lock::unlock);
            }
        });
    }

    public CompletableFuture<CodeLens> resolveCodeLens(CodeLens unresolved) {
        return null;
    }

    public CompletableFuture<List<? extends TextEdit>> formatting(DocumentFormattingParams params) {
        return CompletableFuture.supplyAsync(() -> {
            TextEdit textEdit = new TextEdit();
            String fileUri = params.getTextDocument().getUri();
            Optional<Path> formattingFilePath = CommonUtil.getPathFromURI(fileUri);
            if (!formattingFilePath.isPresent() || CommonUtil.isCachedExternalSource(fileUri)) {
                return Collections.singletonList(textEdit);
            }
            Path compilationPath = LSCompilerUtil.getUntitledFilePath((String)formattingFilePath.toString()).orElse(formattingFilePath.get());
            Optional lock = this.docManager.lockFile(compilationPath);
            try {
                LSContext formatCtx = new DocumentServiceOperationContext.ServiceOperationContextBuilder(LSContextOperation.TXT_FORMATTING).withFormattingParams(fileUri).build();
                JsonObject ast = TextDocumentFormatUtil.getAST((Path)formattingFilePath.get(), (WorkspaceDocumentManager)this.docManager, (LSContext)formatCtx);
                JsonObject model = ast.getAsJsonObject("model");
                FormattingSourceGen.build((JsonObject)model, (String)"CompilationUnit");
                FormattingVisitorEntry formattingUtil = new FormattingVisitorEntry();
                formattingUtil.accept(model);
                String textEditContent = FormattingSourceGen.getSourceOf((JsonObject)model);
                Matcher matcher = Pattern.compile("\r\n|\r|\n").matcher(textEditContent);
                int totalLines = 0;
                while (matcher.find()) {
                    ++totalLines;
                }
                int lastNewLineCharIndex = Math.max(textEditContent.lastIndexOf(10), textEditContent.lastIndexOf(13));
                int lastCharCol = textEditContent.substring(lastNewLineCharIndex + 1).length();
                Range range = new Range(new Position(0, 0), new Position(totalLines, lastCharCol));
                textEdit = new TextEdit(range, textEditContent);
                List<TextEdit> list = Collections.singletonList(textEdit);
                return list;
            }
            catch (UserErrorException e) {
                LSClientLogger.notifyUser((String)"Formatting", (Throwable)e);
                List<TextEdit> ast = Collections.singletonList(textEdit);
                return ast;
            }
            catch (Throwable e) {
                String msg = "Operation 'text/formatting' failed!";
                LSClientLogger.logError((String)msg, (Throwable)e, (TextDocumentIdentifier)params.getTextDocument(), (Position[])new Position[]{null});
                List<TextEdit> list = Collections.singletonList(textEdit);
                return list;
            }
            finally {
                lock.ifPresent(Lock::unlock);
            }
        });
    }

    public CompletableFuture<WorkspaceEdit> rename(RenameParams params) {
        return CompletableFuture.supplyAsync(() -> {
            String fileUri = params.getTextDocument().getUri();
            if (CommonUtil.isCachedExternalSource(fileUri)) {
                return null;
            }
            Position position = params.getPosition();
            TextDocumentPositionParams pos = new TextDocumentPositionParams(params.getTextDocument(), position);
            LSContext context = ((DocumentServiceOperationContext.ServiceOperationContextBuilder)new DocumentServiceOperationContext.ServiceOperationContextBuilder(LSContextOperation.TXT_RENAME).withCommonParams(pos, fileUri, this.docManager)).withRenameParams().build();
            try {
                return ReferencesUtil.getRenameWorkspaceEdits(context, params.getNewName());
            }
            catch (UserErrorException e) {
                LSClientLogger.notifyUser((String)"Rename", (Throwable)e);
                return null;
            }
            catch (Throwable e) {
                String msg = "Operation 'text/rename' failed!";
                LSClientLogger.logError((String)msg, (Throwable)e, (TextDocumentIdentifier)params.getTextDocument(), (Position[])new Position[]{params.getPosition()});
                return null;
            }
        });
    }

    public CompletableFuture<Either<List<? extends Location>, List<? extends LocationLink>>> implementation(TextDocumentPositionParams position) {
        return CompletableFuture.supplyAsync(() -> {
            String fileUri = position.getTextDocument().getUri();
            if (CommonUtil.isCachedExternalSource(fileUri)) {
                return null;
            }
            ArrayList<Location> implementationLocations = new ArrayList<Location>();
            LSContext context = ((DocumentServiceOperationContext.ServiceOperationContextBuilder)new DocumentServiceOperationContext.ServiceOperationContextBuilder(LSContextOperation.TXT_IMPL).withCommonParams(position, fileUri, this.docManager)).build();
            LSDocumentIdentifierImpl lsDocument = new LSDocumentIdentifierImpl(fileUri);
            Path implementationPath = lsDocument.getPath();
            Path compilationPath = LSCompilerUtil.getUntitledFilePath((String)implementationPath.toString()).orElse(implementationPath);
            Optional lock = this.docManager.lockFile(compilationPath);
            try {
                BLangPackage bLangPkg = LSModuleCompiler.getBLangPackage((LSContext)context, (WorkspaceDocumentManager)this.docManager, GotoImplementationCustomErrorStrategy.class, (boolean)false, (boolean)false);
                List<Location> locations = GotoImplementationUtil.getImplementationLocation(bLangPkg, context, position.getPosition(), lsDocument.getProjectRoot());
                implementationLocations.addAll(locations);
            }
            catch (UserErrorException e) {
                LSClientLogger.notifyUser((String)"Goto Implementation", (Throwable)e);
                Either locations = null;
                return locations;
            }
            catch (Throwable e) {
                String msg = "Operation 'text/implementation' failed!";
                LSClientLogger.logError((String)msg, (Throwable)e, (TextDocumentIdentifier)position.getTextDocument(), (Position[])new Position[]{position.getPosition()});
            }
            finally {
                lock.ifPresent(Lock::unlock);
            }
            return Either.forLeft(implementationLocations);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void didOpen(DidOpenTextDocumentParams params) {
        Path compilationPath;
        String docUri = params.getTextDocument().getUri();
        try {
            compilationPath = Paths.get(new URL(docUri).toURI());
        }
        catch (MalformedURLException | URISyntaxException e) {
            compilationPath = null;
        }
        if (compilationPath != null) {
            TextDocumentIdentifier identifier;
            String msg;
            String content = params.getTextDocument().getText();
            Optional lock = this.docManager.lockFile(compilationPath);
            try {
                this.docManager.openFile(Paths.get(new URL(docUri).toURI()), content);
                LSClientLogger.logTrace((String)("Operation '" + LSContextOperation.TXT_DID_OPEN.getName() + "' {fileUri: '" + compilationPath + "'} updated}"));
                ExtendedLanguageClient client = this.languageServer.getClient();
                LSContext context = ((DocumentServiceOperationContext.ServiceOperationContextBuilder)new DocumentServiceOperationContext.ServiceOperationContextBuilder(LSContextOperation.TXT_DID_OPEN).withCommonParams(null, docUri, this.docManager)).withStdLibDefinitionParam(this.enableStdlibDefinition).build();
                String fileUri = (String)context.get(DocumentServiceKeys.FILE_URI_KEY);
                if (CommonUtil.isCachedExternalSource(fileUri)) {
                    context.put(DocumentServiceKeys.IS_CACHE_SUPPORTED, (Object)true);
                    context.put(DocumentServiceKeys.IS_CACHE_OUTDATED_SUPPORTED, (Object)true);
                    LSModuleCompiler.getBLangPackages((LSContext)context, (WorkspaceDocumentManager)this.docManager, LSCustomErrorStrategy.class, (boolean)false, (boolean)true, (boolean)true);
                    CommonUtil.updateStdLibCache(context);
                    return;
                }
                LSDocumentIdentifierImpl lsDocument = new LSDocumentIdentifierImpl(fileUri);
                this.diagnosticsHelper.compileAndSendDiagnostics(client, context, (LSDocumentIdentifier)lsDocument, this.docManager);
                if (this.clientCapabilities.getExperimentalCapabilities().isSemanticSyntaxEnabled()) {
                    SemanticHighlightProvider.sendHighlights(client, context, this.docManager);
                }
                CommonUtil.updateStdLibCache(context);
            }
            catch (CompilationFailedException e) {
                msg = "Computing 'diagnostics' failed!";
                identifier = new TextDocumentIdentifier(params.getTextDocument().getUri());
                LSClientLogger.logError((String)msg, (Throwable)e, (TextDocumentIdentifier)identifier, (Position[])new Position[]{null});
            }
            catch (HighlightingFailedException e) {
                msg = "Semantic highlighting failed!";
                identifier = new TextDocumentIdentifier(params.getTextDocument().getUri());
                LSClientLogger.logError((String)msg, (Throwable)e, (TextDocumentIdentifier)identifier, (Position[])new Position[]{null});
            }
            catch (Throwable e) {
                msg = "Operation 'text/didOpen' failed!";
                identifier = new TextDocumentIdentifier(params.getTextDocument().getUri());
                LSClientLogger.logError((String)msg, (Throwable)e, (TextDocumentIdentifier)identifier, (Position[])new Position[]{null});
            }
            finally {
                lock.ifPresent(Lock::unlock);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void didChange(DidChangeTextDocumentParams params) {
        String fileUri = params.getTextDocument().getUri();
        Optional<Path> changedPath = CommonUtil.getPathFromURI(fileUri);
        if (!changedPath.isPresent() || CommonUtil.isCachedExternalSource(fileUri)) {
            return;
        }
        Path compilationPath = LSCompilerUtil.getUntitledFilePath((String)changedPath.toString()).orElse(changedPath.get());
        Optional lock = this.docManager.lockFile(compilationPath);
        try {
            List changes = params.getContentChanges();
            for (TextDocumentContentChangeEvent changeEvent : changes) {
                this.docManager.updateFile(compilationPath, changeEvent.getText());
            }
            LSClientLogger.logTrace((String)("Operation '" + LSContextOperation.TXT_DID_CHANGE.getName() + "' {fileUri: '" + compilationPath + "'} updated}"));
            ExtendedLanguageClient client = this.languageServer.getClient();
            this.diagPushDebouncer.call(compilationPath, () -> {
                Optional nLock = this.docManager.lockFile(compilationPath);
                try {
                    LSContext context = ((DocumentServiceOperationContext.ServiceOperationContextBuilder)new DocumentServiceOperationContext.ServiceOperationContextBuilder(LSContextOperation.DIAGNOSTICS).withStdLibDefinitionParam(this.enableStdlibDefinition).withCommonParams(null, fileUri, this.docManager)).build();
                    String fileURI = params.getTextDocument().getUri();
                    LSDocumentIdentifierImpl lsDocument = new LSDocumentIdentifierImpl(fileURI);
                    this.diagnosticsHelper.compileAndSendDiagnostics(client, context, (LSDocumentIdentifier)lsDocument, this.docManager);
                    if (this.clientCapabilities.getExperimentalCapabilities().isSemanticSyntaxEnabled()) {
                        SemanticHighlightProvider.sendHighlights(client, context, this.docManager);
                    }
                    LSCompilerCache.clear((LSContext)context, (String)lsDocument.getProjectRoot());
                    CommonUtil.updateStdLibCache(context);
                }
                catch (CompilationFailedException e) {
                    String msg = "Computing 'diagnostics' failed!";
                    LSClientLogger.logError((String)msg, (Throwable)e, (TextDocumentIdentifier)params.getTextDocument(), (Position[])new Position[]{null});
                }
                catch (HighlightingFailedException e) {
                    String msg = "Semantic highlighting failed!";
                    TextDocumentIdentifier identifier = new TextDocumentIdentifier(params.getTextDocument().getUri());
                    LSClientLogger.logError((String)msg, (Throwable)e, (TextDocumentIdentifier)identifier, (Position[])new Position[]{null});
                }
                catch (Throwable e) {
                    String msg = "Operation 'text/didChange' failed!";
                    TextDocumentIdentifier identifier = new TextDocumentIdentifier(params.getTextDocument().getUri());
                    LSClientLogger.logError((String)msg, (Throwable)e, (TextDocumentIdentifier)identifier, (Position[])new Position[]{null});
                }
                finally {
                    nLock.ifPresent(Lock::unlock);
                }
            });
        }
        catch (Throwable e) {
            String msg = "Operation 'text/didChange' failed!";
            LSClientLogger.logError((String)msg, (Throwable)e, (TextDocumentIdentifier)params.getTextDocument(), (Position[])new Position[]{null});
        }
        finally {
            lock.ifPresent(Lock::unlock);
        }
    }

    public void didClose(DidCloseTextDocumentParams params) {
        String docUri = params.getTextDocument().getUri();
        Optional<Path> closedPath = CommonUtil.getPathFromURI(docUri);
        if (!closedPath.isPresent()) {
            return;
        }
        try {
            Path compilationPath = LSCompilerUtil.getUntitledFilePath((String)closedPath.toString()).orElse(closedPath.get());
            this.docManager.closeFile(compilationPath);
        }
        catch (Throwable e) {
            String msg = "Operation 'text/didClose' failed!";
            LSClientLogger.logError((String)msg, (Throwable)e, (TextDocumentIdentifier)params.getTextDocument(), (Position[])new Position[]{null});
        }
    }

    public void didSave(DidSaveTextDocumentParams params) {
    }
}

