/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver;

import java.util.HashMap;
import java.util.Map;
import org.ballerinalang.langserver.Experimental;
import org.ballerinalang.langserver.commons.capability.ExperimentalClientCapabilities;
import org.ballerinalang.langserver.commons.capability.LSClientCapabilities;
import org.eclipse.lsp4j.TextDocumentClientCapabilities;
import org.eclipse.lsp4j.WorkspaceClientCapabilities;

public class LSClientCapabilitiesImpl
implements LSClientCapabilities {
    private ExperimentalClientCapabilities experimentalCapabilities;
    private WorkspaceClientCapabilities workspaceCapabilities;
    private TextDocumentClientCapabilities textDocCapabilities;

    LSClientCapabilitiesImpl(TextDocumentClientCapabilities textDocCapabilities, WorkspaceClientCapabilities workspaceCapabilities, HashMap experimentalClientCapabilities) {
        this.textDocCapabilities = textDocCapabilities != null ? textDocCapabilities : new TextDocumentClientCapabilities();
        this.workspaceCapabilities = workspaceCapabilities != null ? workspaceCapabilities : new WorkspaceClientCapabilities();
        this.experimentalCapabilities = experimentalClientCapabilities != null ? this.parseCapabilities(experimentalClientCapabilities) : new ExperimentalClientCapabilitiesImpl();
    }

    public ExperimentalClientCapabilities getExperimentalCapabilities() {
        return this.experimentalCapabilities;
    }

    public WorkspaceClientCapabilities getWorkspaceCapabilities() {
        return this.workspaceCapabilities;
    }

    public TextDocumentClientCapabilities getTextDocCapabilities() {
        return this.textDocCapabilities;
    }

    private ExperimentalClientCapabilities parseCapabilities(Map<String, Object> experimentalCapabilities) {
        Object introspection = experimentalCapabilities.get(Experimental.INTROSPECTION.getValue());
        boolean introspectionEnabled = introspection instanceof Boolean && (Boolean)introspection != false;
        Object semanticHighlighter = experimentalCapabilities.get(Experimental.SEMANTIC_SYNTAX_HIGHLIGHTER.getValue());
        boolean semanticHighlighterEnabled = semanticHighlighter instanceof Boolean && (Boolean)semanticHighlighter != false;
        Object showTextDocument = experimentalCapabilities.get(Experimental.SHOW_TEXT_DOCUMENT.getValue());
        boolean showTextDocumentEnabled = showTextDocument instanceof Boolean && (Boolean)showTextDocument != false;
        ExperimentalClientCapabilitiesImpl capabilities = new ExperimentalClientCapabilitiesImpl();
        capabilities.setIntrospectionEnabled(introspectionEnabled);
        capabilities.setSemanticSyntaxEnabled(semanticHighlighterEnabled);
        capabilities.setShowTextDocumentEnabled(showTextDocumentEnabled);
        return capabilities;
    }

    public static class ExperimentalClientCapabilitiesImpl
    implements ExperimentalClientCapabilities {
        private boolean introspectionEnabled = false;
        private boolean semanticSyntaxEnabled = false;
        private boolean showTextDocumentEnabled = false;

        public boolean isIntrospectionEnabled() {
            return this.introspectionEnabled;
        }

        public boolean isSemanticSyntaxEnabled() {
            return this.semanticSyntaxEnabled;
        }

        public boolean isShowTextDocumentEnabled() {
            return this.showTextDocumentEnabled;
        }

        private void setIntrospectionEnabled(boolean introspectionEnabled) {
            this.introspectionEnabled = introspectionEnabled;
        }

        private void setSemanticSyntaxEnabled(boolean semanticSyntaxEnabled) {
            this.semanticSyntaxEnabled = semanticSyntaxEnabled;
        }

        private void setShowTextDocumentEnabled(boolean showTextDocumentEnabled) {
            this.showTextDocumentEnabled = showTextDocumentEnabled;
        }
    }
}

