/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.codeaction.providers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import org.ballerinalang.langserver.codeaction.providers.AbstractCodeActionProvider;
import org.ballerinalang.langserver.common.constants.CommandConstants;
import org.ballerinalang.langserver.commons.LSContext;
import org.ballerinalang.langserver.commons.codeaction.CodeActionNodeType;
import org.ballerinalang.langserver.commons.command.CommandArgument;
import org.ballerinalang.langserver.compiler.DocumentServiceKeys;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.Position;

public class ChangeAbstractTypeObjCodeAction
extends AbstractCodeActionProvider {
    private static final String NO_IMPL_FOUND_FOR_FUNCTION = "no implementation found for the function";
    private static final String ABSTRACT_OBJECT = "in abstract object";

    @Override
    public List<CodeAction> getDiagBasedCodeActions(CodeActionNodeType nodeType, LSContext lsContext, List<Diagnostic> diagnosticsOfRange, List<Diagnostic> allDiagnostics) {
        ArrayList<CodeAction> actions = new ArrayList<CodeAction>();
        for (Diagnostic diagnostic2 : diagnosticsOfRange) {
            CodeAction codeAction;
            if (!diagnostic2.getMessage().contains(ABSTRACT_OBJECT) || (codeAction = ChangeAbstractTypeObjCodeAction.getChangeAbstractTypeCommand(diagnostic2, lsContext)) == null) continue;
            actions.add(codeAction);
        }
        HashMap rangeToDiagnostics = new HashMap();
        diagnosticsOfRange.stream().filter(diagnostic -> diagnostic.getMessage().startsWith(NO_IMPL_FOUND_FOR_FUNCTION)).forEach(diagnostic -> rangeToDiagnostics.put(diagnostic.getRange(), diagnostic));
        rangeToDiagnostics.values().forEach(diagnostic -> {
            CodeAction codeAction = ChangeAbstractTypeObjCodeAction.getNoImplementationFoundCommand(diagnostic, lsContext);
            if (codeAction != null) {
                actions.add(codeAction);
            }
        });
        return actions;
    }

    @Override
    public List<CodeAction> getNodeBasedCodeActions(CodeActionNodeType nodeType, LSContext lsContext, List<Diagnostic> allDiagnostics) {
        throw new UnsupportedOperationException("Not supported");
    }

    private static CodeAction getChangeAbstractTypeCommand(Diagnostic diagnostic, LSContext context) {
        String diagnosticMessage = diagnostic.getMessage();
        Position position = diagnostic.getRange().getStart();
        int line = position.getLine();
        int column = position.getCharacter();
        String uri = (String)context.get(DocumentServiceKeys.FILE_URI_KEY);
        CommandArgument lineArg = new CommandArgument("node.line", "" + line);
        CommandArgument colArg = new CommandArgument("node.column", "" + column);
        CommandArgument uriArg = new CommandArgument("doc.uri", uri);
        ArrayList diagnostics = new ArrayList();
        Matcher matcher = CommandConstants.FUNC_IN_ABSTRACT_OBJ_PATTERN.matcher(diagnosticMessage);
        if (matcher.find() && matcher.groupCount() > 1) {
            String objectName = matcher.group(2);
            int colonIndex = objectName.lastIndexOf(":");
            String simpleObjName = colonIndex > -1 ? objectName.substring(colonIndex + 1) : objectName;
            List<Object> args = Arrays.asList(lineArg, colArg, uriArg);
            String commandTitle = String.format("Make '%s' an Non-Abstract Object", simpleObjName);
            CodeAction action = new CodeAction(commandTitle);
            action.setKind("quickfix");
            action.setCommand(new Command(commandTitle, "CHANGE_ABSTRACT_TYPE_OBJ", args));
            action.setDiagnostics(diagnostics);
            return action;
        }
        return null;
    }

    private static CodeAction getNoImplementationFoundCommand(Diagnostic diagnostic, LSContext context) {
        String diagnosticMessage = diagnostic.getMessage();
        Position position = diagnostic.getRange().getStart();
        int line = position.getLine();
        int column = position.getCharacter();
        String uri = (String)context.get(DocumentServiceKeys.FILE_URI_KEY);
        CommandArgument lineArg = new CommandArgument("node.line", "" + line);
        CommandArgument colArg = new CommandArgument("node.column", "" + column);
        CommandArgument uriArg = new CommandArgument("doc.uri", uri);
        ArrayList diagnostics = new ArrayList();
        Matcher matcher = CommandConstants.NO_IMPL_FOUND_FOR_FUNCTION_PATTERN.matcher(diagnosticMessage);
        if (matcher.find() && matcher.groupCount() > 1) {
            String objectName = matcher.group(2);
            int colonIndex = objectName.lastIndexOf(":");
            String simpleObjName = colonIndex > -1 ? objectName.substring(colonIndex + 1) : objectName;
            List<Object> args = Arrays.asList(lineArg, colArg, uriArg);
            String commandTitle = String.format("Make '%s' an Abstract Object", simpleObjName);
            CodeAction action = new CodeAction(commandTitle);
            action.setKind("quickfix");
            action.setCommand(new Command(commandTitle, "CHANGE_ABSTRACT_TYPE_OBJ", args));
            action.setDiagnostics(diagnostics);
            return action;
        }
        return null;
    }
}

