/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.codeaction.providers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.ballerinalang.langserver.codeaction.providers.AbstractCodeActionProvider;
import org.ballerinalang.langserver.common.constants.CommandConstants;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.commons.LSContext;
import org.ballerinalang.langserver.commons.codeaction.CodeActionNodeType;
import org.ballerinalang.langserver.compiler.DocumentServiceKeys;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextDocumentEdit;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.VersionedTextDocumentIdentifier;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.wso2.ballerinalang.compiler.tree.BLangImportPackage;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;
import org.wso2.ballerinalang.compiler.util.diagnotic.DiagnosticPos;

public class OptimizeAllImportsCodeAction
extends AbstractCodeActionProvider {
    private static final String UNUSED_IMPORT_MODULE = "unused import module";

    public OptimizeAllImportsCodeAction() {
        super(Collections.singletonList(CodeActionNodeType.IMPORTS));
    }

    @Override
    public List<CodeAction> getNodeBasedCodeActions(CodeActionNodeType nodeType, LSContext context, List<Diagnostic> allDiagnostics) {
        ArrayList<CodeAction> actions = new ArrayList<CodeAction>();
        String uri = (String)context.get(DocumentServiceKeys.FILE_URI_KEY);
        BLangPackage bLangPackage = (BLangPackage)context.get(DocumentServiceKeys.CURRENT_BLANG_PACKAGE_CONTEXT_KEY);
        List<BLangImportPackage> fileImports = CommonUtil.getCurrentFileImports(context);
        if (bLangPackage == null || fileImports == null || fileImports.isEmpty()) {
            return actions;
        }
        ArrayList<ImmutablePair> toBeRemovedImports = new ArrayList<ImmutablePair>();
        for (Diagnostic diagnostic : allDiagnostics) {
            Matcher matcher;
            if (!diagnostic.getMessage().startsWith(UNUSED_IMPORT_MODULE) || !(matcher = CommandConstants.UNUSED_IMPORT_MODULE_PATTERN.matcher(diagnostic.getMessage())).find()) continue;
            String pkgName = matcher.group(1).trim();
            String version = matcher.groupCount() > 1 && matcher.group(2) != null ? ":" + matcher.group(2) : "";
            int aliasIndex = version.indexOf(" as ");
            if (aliasIndex > 0) {
                version = version.substring(0, aliasIndex);
            }
            toBeRemovedImports.add(new ImmutablePair((Object)pkgName, (Object)version));
        }
        if (fileImports.size() <= 1 && toBeRemovedImports.size() == 0) {
            return actions;
        }
        int importSLine = fileImports.get((int)0).pos.sLine - 1;
        int importELine = fileImports.get((int)0).pos.eLine - 1;
        int importSCol = fileImports.get((int)0).pos.sCol - 1;
        int importECol = fileImports.get((int)0).pos.eCol - 1;
        for (int i = 0; i < fileImports.size(); ++i) {
            boolean rmMatched;
            BLangImportPackage importPkg = fileImports.get(i);
            DiagnosticPos pos = importPkg.getPosition();
            String orgName = importPkg.orgName.value;
            String alias = importPkg.alias.value;
            String version = importPkg.version.value;
            if (importSLine > pos.sLine) {
                importSLine = pos.sLine;
            }
            if (importELine < pos.eLine) {
                importELine = pos.eLine;
            }
            if (importECol < pos.eCol) {
                importECol = pos.eCol;
            }
            if (!(rmMatched = toBeRemovedImports.stream().anyMatch(rmImport -> ((String)rmImport.getLeft()).equals(orgName + "/" + alias) && ((String)rmImport.getRight()).equals(version)))) continue;
            fileImports.remove(i);
            --i;
        }
        List orderedImports = fileImports.stream().sorted(Comparator.comparing(o -> o.orgName.value).thenComparing(o -> o.getAlias().value)).collect(Collectors.toList());
        StringBuilder editText = new StringBuilder();
        for (BLangImportPackage importPkg : orderedImports) {
            editText.append("import ").append(importPkg.orgName.value).append("/").append(importPkg.alias.value);
            String version = importPkg.version.value;
            if (!version.isEmpty()) {
                editText.append(" version ").append(version);
            }
            editText.append(";").append(System.lineSeparator());
        }
        Range range = new Range(new Position(importSLine, importSCol), new Position(importELine, importECol));
        List<TextEdit> edits = Collections.singletonList(new TextEdit(range, editText.toString()));
        CodeAction action = new CodeAction("Optimize All Imports");
        action.setKind("quickfix");
        action.setEdit(new WorkspaceEdit(Collections.singletonList(Either.forLeft((Object)new TextDocumentEdit(new VersionedTextDocumentIdentifier(uri, null), edits)))));
        action.setDiagnostics(null);
        actions.add(action);
        return actions;
    }

    @Override
    public List<CodeAction> getDiagBasedCodeActions(CodeActionNodeType nodeType, LSContext context, List<Diagnostic> diagnosticsOfRange, List<Diagnostic> allDiagnostics) {
        throw new UnsupportedOperationException("Not supported");
    }
}

