/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.codeaction.providers;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import org.ballerinalang.langserver.codeaction.providers.AbstractCodeActionProvider;
import org.ballerinalang.langserver.command.CommandUtil;
import org.ballerinalang.langserver.common.constants.CommandConstants;
import org.ballerinalang.langserver.commons.LSContext;
import org.ballerinalang.langserver.commons.codeaction.CodeActionNodeType;
import org.ballerinalang.langserver.commons.workspace.WorkspaceDocumentException;
import org.ballerinalang.langserver.commons.workspace.WorkspaceDocumentManager;
import org.ballerinalang.langserver.compiler.DocumentServiceKeys;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextDocumentEdit;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.VersionedTextDocumentIdentifier;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.lsp4j.jsonrpc.messages.Either;

public class TaintedParamCodeAction
extends AbstractCodeActionProvider {
    @Override
    public List<CodeAction> getDiagBasedCodeActions(CodeActionNodeType nodeType, LSContext lsContext, List<Diagnostic> diagnosticsOfRange, List<Diagnostic> allDiagnostics) {
        ArrayList<CodeAction> actions = new ArrayList<CodeAction>();
        for (Diagnostic diagnostic : diagnosticsOfRange) {
            CodeAction codeAction;
            if (!diagnostic.getMessage().toLowerCase(Locale.ROOT).contains("tainted value passed to untainted parameter") || (codeAction = TaintedParamCodeAction.getTaintedParamCommand(diagnostic, lsContext)) == null) continue;
            actions.add(codeAction);
        }
        return actions;
    }

    @Override
    public List<CodeAction> getNodeBasedCodeActions(CodeActionNodeType nodeType, LSContext lsContext, List<Diagnostic> allDiagnostics) {
        throw new UnsupportedOperationException("Not supported");
    }

    private static CodeAction getTaintedParamCommand(Diagnostic diagnostic, LSContext context) {
        String diagnosticMessage = diagnostic.getMessage();
        ArrayList diagnostics = new ArrayList();
        String uri = (String)context.get(DocumentServiceKeys.FILE_URI_KEY);
        try {
            Matcher matcher = CommandConstants.TAINTED_PARAM_PATTERN.matcher(diagnosticMessage);
            if (matcher.find() && matcher.groupCount() > 0) {
                String param = matcher.group(1);
                String commandTitle = String.format("Mark '%s' as Untainted", param);
                CodeAction action = new CodeAction(commandTitle);
                action.setKind("quickfix");
                action.setDiagnostics(diagnostics);
                Range range = diagnostic.getRange();
                WorkspaceDocumentManager documentManager = (WorkspaceDocumentManager)context.get(DocumentServiceKeys.DOC_MANAGER_KEY);
                String content = CommandUtil.getContentOfRange(documentManager, uri, range);
                matcher = CommandConstants.NO_CONCAT_PATTERN.matcher(content);
                String editText = matcher.find() ? "<@untained>  " + content : "<@untained> (" + content + ")";
                ArrayList<TextEdit> edits = new ArrayList<TextEdit>();
                edits.add(new TextEdit(range, editText));
                VersionedTextDocumentIdentifier identifier = new VersionedTextDocumentIdentifier(uri, null);
                action.setEdit(new WorkspaceEdit(Collections.singletonList(Either.forLeft((Object)new TextDocumentEdit(identifier, edits)))));
                return action;
            }
        }
        catch (IOException | WorkspaceDocumentException throwable) {
            // empty catch block
        }
        return null;
    }
}

