/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.codelenses;

import java.util.ArrayList;
import java.util.List;
import org.ballerinalang.langserver.common.LSNodeVisitor;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.tree.BLangBlockFunctionBody;
import org.wso2.ballerinalang.compiler.tree.BLangCompilationUnit;
import org.wso2.ballerinalang.compiler.tree.BLangFunction;
import org.wso2.ballerinalang.compiler.tree.BLangNode;
import org.wso2.ballerinalang.compiler.tree.BLangNodeVisitor;
import org.wso2.ballerinalang.compiler.tree.BLangService;
import org.wso2.ballerinalang.compiler.tree.BLangSimpleVariable;
import org.wso2.ballerinalang.compiler.tree.BLangWorker;
import org.wso2.ballerinalang.compiler.tree.statements.BLangBlockStmt;
import org.wso2.ballerinalang.compiler.tree.statements.BLangForeach;
import org.wso2.ballerinalang.compiler.tree.statements.BLangIf;
import org.wso2.ballerinalang.compiler.tree.statements.BLangSimpleVariableDef;
import org.wso2.ballerinalang.compiler.tree.statements.BLangStatement;
import org.wso2.ballerinalang.compiler.tree.statements.BLangWhile;
import org.wso2.ballerinalang.compiler.tree.types.BLangObjectTypeNode;

public class EndpointFindVisitor
extends LSNodeVisitor {
    private List<BLangNode> endpoints = new ArrayList<BLangNode>();

    public List<BLangNode> getEndpoints() {
        return this.endpoints;
    }

    @Override
    public void visit(BLangCompilationUnit compilationUnit) {
        List topLevelNodes = compilationUnit.getTopLevelNodes();
        topLevelNodes.stream().filter(CommonUtil.checkInvalidTypesDefs()).forEach(topLevelNode -> this.acceptNode((BLangNode)topLevelNode));
    }

    @Override
    public void visit(BLangSimpleVariable varNode) {
        List<BLangSimpleVariable> variables = this.resolveEndpoints(varNode);
        this.endpoints.addAll(variables);
    }

    @Override
    public void visit(BLangSimpleVariableDef varNode) {
        if (varNode.var != null) {
            List<BLangSimpleVariable> variables = this.resolveEndpoints(varNode.var);
            this.endpoints.addAll(variables);
        }
    }

    @Override
    public void visit(BLangFunction funcNode) {
        if (funcNode.body != null) {
            this.acceptNode((BLangNode)funcNode.body);
        }
    }

    @Override
    public void visit(BLangBlockFunctionBody body) {
        for (BLangStatement stmt : body.stmts) {
            stmt.accept((BLangNodeVisitor)this);
        }
    }

    @Override
    public void visit(BLangService serviceNode) {
        ((BLangObjectTypeNode)serviceNode.serviceTypeDefinition.typeNode).getFunctions().stream().filter(bLangFunction -> (bLangFunction.symbol.flags & 0x40000) == 262144).forEach(this::acceptNode);
    }

    private void acceptNode(BLangNode node) {
        node.accept((BLangNodeVisitor)this);
    }

    private List<BLangSimpleVariable> resolveEndpoints(BLangSimpleVariable variable) {
        ArrayList<BLangSimpleVariable> list = new ArrayList<BLangSimpleVariable>();
        boolean isClientObj = CommonUtil.isClientObject((BSymbol)variable.symbol);
        if (isClientObj) {
            list.add(variable);
        }
        return list;
    }

    @Override
    public void visit(BLangBlockStmt blockNode) {
        blockNode.stmts.forEach(this::acceptNode);
    }

    @Override
    public void visit(BLangIf ifNode) {
        this.acceptNode((BLangNode)ifNode.body);
        if (ifNode.elseStmt != null) {
            this.acceptNode((BLangNode)ifNode.elseStmt);
        }
    }

    @Override
    public void visit(BLangWhile whileNode) {
        this.acceptNode((BLangNode)whileNode.body);
    }

    @Override
    public void visit(BLangWorker workerNode) {
        this.acceptNode((BLangNode)workerNode.body);
    }

    @Override
    public void visit(BLangForeach foreach) {
        this.acceptNode((BLangNode)foreach.body);
    }
}

