/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.codelenses;

import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import org.ballerinalang.langserver.commons.codelenses.spi.LSCodeLensesProvider;
import org.ballerinalang.langserver.compiler.config.LSClientConfigHolder;

public class LSCodeLensesProviderHolder {
    private static final List<LSCodeLensesProvider> providers = new ArrayList<LSCodeLensesProvider>();
    private static final LSCodeLensesProviderHolder INSTANCE = new LSCodeLensesProviderHolder();
    private boolean isEnabled = true;

    private LSCodeLensesProviderHolder() {
        ServiceLoader<LSCodeLensesProvider> providers = ServiceLoader.load(LSCodeLensesProvider.class);
        for (LSCodeLensesProvider executor : providers) {
            if (executor == null || !executor.isEnabled()) continue;
            LSCodeLensesProviderHolder.providers.add(executor);
        }
        LSClientConfigHolder.getInstance().register((oldConfig, newConfig) -> {
            this.isEnabled = newConfig.getCodeLens().getAll().isEnabled();
        });
    }

    public static LSCodeLensesProviderHolder getInstance() {
        return INSTANCE;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public List<LSCodeLensesProvider> getProviders() {
        ArrayList<LSCodeLensesProvider> activeProviders = new ArrayList<LSCodeLensesProvider>();
        for (LSCodeLensesProvider provider : providers) {
            if (provider == null || !provider.isEnabled()) continue;
            activeProviders.add(provider);
        }
        return activeProviders;
    }
}

