/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.command.docs;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.ballerinalang.langserver.command.docs.DocAttachmentInfo;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.commons.LSContext;
import org.ballerinalang.langserver.commons.codeaction.CodeActionNodeType;
import org.ballerinalang.model.elements.Flag;
import org.ballerinalang.model.symbols.SymbolKind;
import org.ballerinalang.model.tree.Node;
import org.ballerinalang.model.tree.TopLevelNode;
import org.ballerinalang.model.types.TypeKind;
import org.eclipse.lsp4j.Position;
import org.wso2.ballerinalang.compiler.tree.BLangAnnotationAttachment;
import org.wso2.ballerinalang.compiler.tree.BLangFunction;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;
import org.wso2.ballerinalang.compiler.tree.BLangService;
import org.wso2.ballerinalang.compiler.tree.BLangSimpleVariable;
import org.wso2.ballerinalang.compiler.tree.BLangTypeDefinition;
import org.wso2.ballerinalang.compiler.tree.BLangVariable;
import org.wso2.ballerinalang.compiler.tree.types.BLangObjectTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangRecordTypeNode;
import org.wso2.ballerinalang.compiler.util.diagnotic.DiagnosticPos;

public class DocumentationGenerator {
    private DocumentationGenerator() {
    }

    public static DocAttachmentInfo getDocumentationEditForNode(Node node) {
        DocAttachmentInfo docAttachmentInfo = null;
        switch (node.getKind()) {
            case FUNCTION: {
                if (((BLangFunction)node).markdownDocumentationAttachment != null) break;
                docAttachmentInfo = DocumentationGenerator.getFunctionNodeDocumentation((BLangFunction)node);
                break;
            }
            case TYPE_DEFINITION: {
                if (((BLangTypeDefinition)node).markdownDocumentationAttachment != null || !(((BLangTypeDefinition)node).typeNode instanceof BLangRecordTypeNode) && !(((BLangTypeDefinition)node).typeNode instanceof BLangObjectTypeNode)) break;
                docAttachmentInfo = DocumentationGenerator.getRecordOrObjectDocumentation((BLangTypeDefinition)node);
                break;
            }
            case SERVICE: {
                if (((BLangService)node).markdownDocumentationAttachment != null) break;
                BLangService bLangService = (BLangService)node;
                docAttachmentInfo = DocumentationGenerator.getServiceNodeDocumentation(bLangService);
                break;
            }
        }
        return docAttachmentInfo;
    }

    public static DocAttachmentInfo getDocumentationEditForNodeByPosition(String topLevelNodeType, BLangPackage bLangPkg, int line, LSContext context) {
        DocAttachmentInfo docAttachmentInfo = null;
        CodeActionNodeType codeActionNodeType = CodeActionNodeType.getNodeTypeByName((String)topLevelNodeType);
        switch (codeActionNodeType) {
            case FUNCTION: 
            case OBJECT_FUNCTION: {
                docAttachmentInfo = DocumentationGenerator.getFunctionDocumentationByPosition(bLangPkg, line, context);
                break;
            }
            case SERVICE: {
                docAttachmentInfo = DocumentationGenerator.getServiceDocumentationByPosition(bLangPkg, line, context);
                break;
            }
            case RESOURCE: {
                docAttachmentInfo = DocumentationGenerator.getResourceDocumentationByPosition(bLangPkg, line, context);
                break;
            }
            case RECORD: 
            case OBJECT: {
                docAttachmentInfo = DocumentationGenerator.getTypeNodeDocumentationByPosition(bLangPkg, line, context);
                break;
            }
        }
        return docAttachmentInfo;
    }

    private static DocAttachmentInfo getServiceNodeDocumentation(BLangService bLangService) {
        DiagnosticPos servicePos = CommonUtil.toZeroBasedPosition(bLangService.getPosition());
        List annotations = bLangService.getAnnotationAttachments();
        Position docStart = DocumentationGenerator.getDocumentationStartPosition(bLangService.getPosition(), annotations);
        return new DocAttachmentInfo(DocumentationGenerator.getDocumentationAttachment(null, servicePos.getStartColumn()), docStart);
    }

    private static DocAttachmentInfo getFunctionDocumentationByPosition(BLangPackage pkg, int line, LSContext ctx) {
        ArrayList<BLangFunction> filteredFunctions = new ArrayList<BLangFunction>();
        for (TopLevelNode topLevelNode : CommonUtil.getCurrentFileTopLevelNodes(pkg, ctx)) {
            if (topLevelNode instanceof BLangFunction) {
                filteredFunctions.add((BLangFunction)topLevelNode);
                continue;
            }
            if (!(topLevelNode instanceof BLangTypeDefinition) || !(((BLangTypeDefinition)topLevelNode).typeNode instanceof BLangObjectTypeNode)) continue;
            filteredFunctions.addAll(((BLangObjectTypeNode)((BLangTypeDefinition)topLevelNode).typeNode).getFunctions());
        }
        for (BLangFunction filteredFunction : filteredFunctions) {
            DiagnosticPos functionPos = CommonUtil.toZeroBasedPosition(filteredFunction.getPosition());
            int functionStart = functionPos.getStartLine();
            if (functionStart != line) continue;
            return DocumentationGenerator.getFunctionNodeDocumentation(filteredFunction);
        }
        return null;
    }

    private static DocAttachmentInfo getResourceDocumentationByPosition(BLangPackage pkg, int line, LSContext ctx) {
        ArrayList filteredFunctions = new ArrayList();
        CommonUtil.getCurrentFileTopLevelNodes(pkg, ctx).stream().filter(topLevelNode -> topLevelNode instanceof BLangService).map(topLevelNode -> (BLangService)topLevelNode).forEach(bLangService -> {
            BLangObjectTypeNode serviceType = (BLangObjectTypeNode)bLangService.serviceTypeDefinition.getTypeNode();
            filteredFunctions.addAll(serviceType.getFunctions());
        });
        for (BLangFunction bLangFunction : filteredFunctions) {
            List annotations = bLangFunction.annAttachments;
            int firstAnnotationStart = -1;
            DiagnosticPos resourcePosition = CommonUtil.toZeroBasedPosition(bLangFunction.getPosition());
            if (!annotations.isEmpty()) {
                firstAnnotationStart = CommonUtil.toZeroBasedPosition(((BLangAnnotationAttachment)annotations.get(0)).getPosition()).getStartLine();
            }
            if ((!annotations.isEmpty() || line != resourcePosition.getStartLine()) && (annotations.isEmpty() || line < firstAnnotationStart || line > resourcePosition.getEndLine())) continue;
            return DocumentationGenerator.getFunctionNodeDocumentation(bLangFunction);
        }
        return null;
    }

    private static DocAttachmentInfo getFunctionNodeDocumentation(BLangFunction bLangFunction) {
        ArrayList<String> attributes = new ArrayList<String>();
        DiagnosticPos functionPos = CommonUtil.toZeroBasedPosition(bLangFunction.getPosition());
        List annotations = bLangFunction.getAnnotationAttachments();
        Position docStart = DocumentationGenerator.getDocumentationStartPosition(bLangFunction.getPosition(), annotations);
        int offset = functionPos.getStartColumn();
        ArrayList<BLangVariable> params = new ArrayList<BLangVariable>(bLangFunction.getParameters());
        if (bLangFunction.getRestParameters() != null) {
            params.add((BLangVariable)bLangFunction.getRestParameters());
        }
        params.sort(new FunctionArgsComparator());
        params.forEach(param -> attributes.add(DocumentationGenerator.getDocAttributeFromBLangVariable((BLangSimpleVariable)param, offset)));
        if (bLangFunction.symbol.retType.getKind() != TypeKind.NIL) {
            attributes.add(DocumentationGenerator.getReturnFieldDescription(offset));
        }
        return new DocAttachmentInfo(DocumentationGenerator.getDocumentationAttachment(attributes, functionPos.getStartColumn()), docStart);
    }

    private static DocAttachmentInfo getRecordOrObjectDocumentation(BLangTypeDefinition typeDef) {
        ArrayList<String> attributes = new ArrayList<String>();
        ArrayList fields = new ArrayList();
        DiagnosticPos structPos = CommonUtil.toZeroBasedPosition(typeDef.getPosition());
        List annotations = typeDef.getAnnotationAttachments();
        Position docStart = DocumentationGenerator.getDocumentationStartPosition(typeDef.getPosition(), annotations);
        if (typeDef.typeNode instanceof BLangObjectTypeNode) {
            fields.addAll(((BLangObjectTypeNode)typeDef.typeNode).fields);
        } else if (typeDef.typeNode instanceof BLangRecordTypeNode) {
            fields.addAll(((BLangRecordTypeNode)typeDef.typeNode).fields);
        }
        int offset = structPos.getStartColumn();
        fields.forEach(bLangVariable -> attributes.add(DocumentationGenerator.getDocAttributeFromBLangVariable(bLangVariable, offset)));
        return new DocAttachmentInfo(DocumentationGenerator.getDocumentationAttachment(attributes, structPos.getStartColumn()), docStart);
    }

    private static DocAttachmentInfo getServiceDocumentationByPosition(BLangPackage pkg, int line, LSContext ctx) {
        for (TopLevelNode topLevelNode : CommonUtil.getCurrentFileTopLevelNodes(pkg, ctx)) {
            if (!(topLevelNode instanceof BLangService) || topLevelNode.getPosition().getStartLine() - 1 != line) continue;
            BLangService serviceNode = (BLangService)topLevelNode;
            return DocumentationGenerator.getServiceNodeDocumentation(serviceNode);
        }
        return null;
    }

    private static DocAttachmentInfo getTypeNodeDocumentationByPosition(BLangPackage pkg, int line, LSContext ctx) {
        for (TopLevelNode topLevelNode : CommonUtil.getCurrentFileTopLevelNodes(pkg, ctx)) {
            if (!(topLevelNode instanceof BLangTypeDefinition)) continue;
            BLangTypeDefinition typeDef = (BLangTypeDefinition)topLevelNode;
            DiagnosticPos typeNodePos = CommonUtil.toZeroBasedPosition(typeDef.getPosition());
            if (typeDef.symbol.kind != SymbolKind.OBJECT && typeDef.symbol.kind != SymbolKind.RECORD || typeNodePos.getStartLine() != line) continue;
            return DocumentationGenerator.getTypeNodeDocumentation((BLangTypeDefinition)topLevelNode);
        }
        return null;
    }

    private static DocAttachmentInfo getTypeNodeDocumentation(BLangTypeDefinition typeNode) {
        ArrayList<String> attributes = new ArrayList<String>();
        DiagnosticPos typeNodePos = CommonUtil.toZeroBasedPosition(typeNode.getPosition());
        int offset = typeNodePos.getStartColumn();
        List annotations = typeNode.getAnnotationAttachments();
        Position docStart = DocumentationGenerator.getDocumentationStartPosition(typeNode.getPosition(), annotations);
        ArrayList publicFields = new ArrayList();
        if (typeNode.symbol.kind == SymbolKind.OBJECT) {
            publicFields.addAll(((BLangObjectTypeNode)typeNode.typeNode).getFields().stream().filter(field -> field.getFlags().contains(Flag.PUBLIC)).collect(Collectors.toList()));
        } else if (typeNode.symbol.kind == SymbolKind.RECORD) {
            publicFields.addAll(((BLangRecordTypeNode)typeNode.typeNode).getFields());
        }
        publicFields.forEach(variableNode -> attributes.add(DocumentationGenerator.getDocAttributeFromBLangVariable((BLangSimpleVariable)variableNode, offset)));
        return new DocAttachmentInfo(DocumentationGenerator.getDocumentationAttachment(attributes, offset), docStart);
    }

    private static String getDocAttributeFromBLangVariable(BLangSimpleVariable bLangVariable, int offset) {
        return DocumentationGenerator.getDocumentationAttribute(bLangVariable.getName().getValue(), offset);
    }

    private static String getDocumentationAttribute(String field, int offset) {
        String offsetStr = String.join((CharSequence)"", Collections.nCopies(offset, " "));
        return String.format("%s# + %s - %s Parameter Description", offsetStr, field, field);
    }

    private static String getReturnFieldDescription(int offset) {
        String offsetStr = String.join((CharSequence)"", Collections.nCopies(offset, " "));
        return String.format("%s# + return - Return Value Description", offsetStr);
    }

    private static String getDocumentationAttachment(List<String> attributes, int offset) {
        String offsetStr = String.join((CharSequence)"", Collections.nCopies(offset, " "));
        if (attributes == null || attributes.isEmpty()) {
            return String.format("# Description%n%s", offsetStr);
        }
        String joinedList = String.join((CharSequence)" \r\n", attributes);
        return String.format("# Description%n%s#%n%s%n%s", offsetStr, joinedList, offsetStr);
    }

    private static Position getDocumentationStartPosition(DiagnosticPos nodePos, List<BLangAnnotationAttachment> annotations) {
        DiagnosticPos startPos = annotations.isEmpty() ? CommonUtil.toZeroBasedPosition(nodePos) : CommonUtil.toZeroBasedPosition(annotations.get(0).getPosition());
        return new Position(startPos.getStartLine(), startPos.getStartColumn());
    }

    private static class FunctionArgsComparator
    implements Serializable,
    Comparator<BLangVariable> {
        private static final long serialVersionUID = 1L;

        private FunctionArgsComparator() {
        }

        @Override
        public int compare(BLangVariable arg1, BLangVariable arg2) {
            return arg1.getPosition().getStartColumn() - arg2.getPosition().getStartColumn();
        }
    }
}

