/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.command.executors;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.ballerinalang.langserver.command.CommandUtil;
import org.ballerinalang.langserver.commons.LSContext;
import org.ballerinalang.langserver.commons.command.ExecuteCommandKeys;
import org.ballerinalang.langserver.commons.command.LSCommandExecutorException;
import org.ballerinalang.langserver.commons.command.spi.LSCommandExecutor;
import org.ballerinalang.langserver.commons.workspace.WorkspaceDocumentManager;
import org.ballerinalang.langserver.compiler.DocumentServiceKeys;
import org.ballerinalang.langserver.compiler.LSModuleCompiler;
import org.ballerinalang.langserver.compiler.common.LSCustomErrorStrategy;
import org.ballerinalang.langserver.compiler.exception.CompilationFailedException;
import org.ballerinalang.model.Whitespace;
import org.ballerinalang.util.diagnostic.Diagnostic;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextDocumentEdit;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.VersionedTextDocumentIdentifier;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.services.LanguageClient;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;
import org.wso2.ballerinalang.compiler.tree.BLangTypeDefinition;

public class ChangeAbstractTypeObjExecutor
implements LSCommandExecutor {
    public static final String COMMAND = "CHANGE_ABSTRACT_TYPE_OBJ";

    public Object execute(LSContext context) throws LSCommandExecutorException {
        String documentUri = null;
        int sLine = -1;
        int sCol = -1;
        VersionedTextDocumentIdentifier textDocumentIdentifier = new VersionedTextDocumentIdentifier();
        for (Object arg : (List)context.get(ExecuteCommandKeys.COMMAND_ARGUMENTS_KEY)) {
            String argKey = ((JsonObject)arg).get("argumentK").getAsString();
            String argVal = ((JsonObject)arg).get("argumentV").getAsString();
            switch (argKey) {
                case "doc.uri": {
                    documentUri = argVal;
                    textDocumentIdentifier.setUri(documentUri);
                    context.put(DocumentServiceKeys.FILE_URI_KEY, (Object)documentUri);
                    break;
                }
                case "node.line": {
                    sLine = Integer.parseInt(argVal);
                    break;
                }
                case "node.column": {
                    sCol = Integer.parseInt(argVal);
                    break;
                }
            }
        }
        if (sLine == -1 || sCol == -1 || documentUri == null) {
            throw new LSCommandExecutorException("Invalid parameters received for the change abstract type command!");
        }
        int line = sLine;
        int col = sCol;
        WorkspaceDocumentManager docManager = (WorkspaceDocumentManager)context.get(DocumentServiceKeys.DOC_MANAGER_KEY);
        try {
            TextEdit textEdit;
            StringBuilder str;
            boolean isFirst;
            BLangPackage bLangPackage = LSModuleCompiler.getBLangPackage((LSContext)context, (WorkspaceDocumentManager)docManager, LSCustomErrorStrategy.class, (boolean)false, (boolean)false);
            Optional<BLangTypeDefinition> objType = bLangPackage.topLevelNodes.stream().filter(topLevelNode -> {
                if (topLevelNode instanceof BLangTypeDefinition) {
                    Diagnostic.DiagnosticPosition pos = topLevelNode.getPosition();
                    return (pos.getStartLine() == line || pos.getEndLine() == line || pos.getStartLine() < line && pos.getEndLine() > line) && pos.getStartColumn() <= col && pos.getEndColumn() <= col;
                }
                return false;
            }).findAny().map(t -> (BLangTypeDefinition)t);
            if (!objType.isPresent()) {
                throw new LSCommandExecutorException("Could not locate the object node!");
            }
            boolean isAbstract = (objType.get().symbol.flags & 0x1000) == 4096;
            Iterator iterator = objType.get().getWS().iterator();
            if (!isAbstract) {
                Whitespace next;
                int colBeforeObjKeyword = objType.get().pos.sCol;
                isFirst = true;
                str = new StringBuilder();
                while (iterator.hasNext() && !"object".equals((next = (Whitespace)iterator.next()).getPrevious())) {
                    if (!isFirst) {
                        str.append(next.getWs());
                    }
                    str.append(next.getPrevious());
                    isFirst = false;
                }
                String editText = " abstract";
                Position position = new Position(objType.get().pos.sLine - 1, (colBeforeObjKeyword += str.toString().length()) - 1);
                textEdit = new TextEdit(new Range(position, position), editText);
            } else {
                int colBeforeLeftBrace = objType.get().pos.sCol;
                isFirst = true;
                str = new StringBuilder();
                boolean skipNextWS = false;
                boolean loop = true;
                while (iterator.hasNext() && loop) {
                    Whitespace next = (Whitespace)iterator.next();
                    String prev = next.getPrevious();
                    if ("{".equals(prev)) {
                        loop = false;
                    }
                    if (!isFirst) {
                        String ws = next.getWs();
                        if (!skipNextWS) {
                            str.append(ws);
                        } else {
                            skipNextWS = false;
                        }
                        colBeforeLeftBrace += ws.length();
                    }
                    if (!"abstract".equals(prev)) {
                        str.append(prev);
                    } else {
                        skipNextWS = true;
                    }
                    colBeforeLeftBrace += prev.length();
                    isFirst = false;
                }
                String editText = str.toString();
                Position start = new Position(objType.get().pos.sLine - 1, objType.get().pos.sCol - 1);
                Position end = new Position(objType.get().pos.sLine - 1, (colBeforeLeftBrace += str.toString().length()) - 1);
                textEdit = new TextEdit(new Range(start, end), editText);
            }
            LanguageClient client = (LanguageClient)context.get(ExecuteCommandKeys.LANGUAGE_CLIENT_KEY);
            ArrayList<TextEdit> edits = new ArrayList<TextEdit>();
            edits.add(textEdit);
            TextDocumentEdit textDocumentEdit = new TextDocumentEdit(textDocumentIdentifier, edits);
            return CommandUtil.applyWorkspaceEdit(Collections.singletonList(Either.forLeft((Object)textDocumentEdit)), client);
        }
        catch (CompilationFailedException e) {
            throw new LSCommandExecutorException("Error while compiling the source!");
        }
    }

    public String getCommand() {
        return COMMAND;
    }
}

