/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.command.testgen.template;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.ballerinalang.langserver.command.testgen.TestGenerator;
import org.ballerinalang.langserver.command.testgen.TestGeneratorException;
import org.ballerinalang.langserver.command.testgen.renderer.RendererOutput;
import org.ballerinalang.langserver.command.testgen.template.AbstractTestTemplate;
import org.ballerinalang.langserver.command.testgen.template.PlaceHolder;
import org.ballerinalang.langserver.command.testgen.template.type.FunctionTemplate;
import org.ballerinalang.langserver.command.testgen.template.type.HttpServiceTemplate;
import org.ballerinalang.langserver.command.testgen.template.type.WSServiceTemplate;
import org.wso2.ballerinalang.compiler.tree.BLangFunction;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;
import org.wso2.ballerinalang.compiler.tree.BLangService;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypeInit;

public class RootTemplate
extends AbstractTestTemplate {
    public static final String LINE_FEED = System.lineSeparator();
    private final List<Pair<BLangService, BLangTypeInit>> httpServices = new ArrayList<Pair<BLangService, BLangTypeInit>>();
    private final List<Pair<BLangService, BLangTypeInit>> httpWSServices = new ArrayList<Pair<BLangService, BLangTypeInit>>();
    private final List<String[]> httpWSClientServices = new ArrayList<String[]>();
    private final List<BLangFunction> functions = new ArrayList<BLangFunction>();

    private RootTemplate(BLangPackage bLangPackage, BiConsumer<Integer, Integer> focusLineAcceptor) {
        super(bLangPackage, focusLineAcceptor);
    }

    public RootTemplate(String fileName, BLangPackage builtTestFile, BiConsumer<Integer, Integer> focusLineAcceptor) {
        super(builtTestFile, focusLineAcceptor);
        builtTestFile.getServices().forEach(service -> {
            String owner = service.listenerType.tsymbol.owner.name.value;
            String serviceTypeName = service.listenerType.tsymbol.name.value;
            Optional<BLangTypeInit> optionalServiceInit = TestGenerator.getServiceInit(builtTestFile, service);
            optionalServiceInit.ifPresent(init -> {
                if ("http".equals(owner)) {
                    switch (serviceTypeName) {
                        case "Listener": {
                            this.httpServices.add((Pair<BLangService, BLangTypeInit>)new ImmutablePair(service, init));
                            break;
                        }
                        case "WebSocketListener": {
                            this.httpWSServices.add((Pair<BLangService, BLangTypeInit>)new ImmutablePair(service, init));
                            break;
                        }
                    }
                }
            });
        });
        builtTestFile.getFunctions().stream().filter(func -> fileName.equals(func.pos.src.cUnitName)).forEach(this.functions::add);
    }

    public static RootTemplate fromFunction(BLangFunction function, BLangPackage builtTestFile, BiConsumer<Integer, Integer> focusLineAcceptor) {
        RootTemplate rootTemplate = new RootTemplate(builtTestFile, focusLineAcceptor);
        rootTemplate.functions.add(function);
        return rootTemplate;
    }

    public static RootTemplate fromHttpService(BLangService service, BLangTypeInit init, BLangPackage builtTestFile, BiConsumer<Integer, Integer> focusLineAcceptor) {
        RootTemplate rootTemplate = new RootTemplate(builtTestFile, focusLineAcceptor);
        rootTemplate.httpServices.add((Pair<BLangService, BLangTypeInit>)new ImmutablePair((Object)service, (Object)init));
        return rootTemplate;
    }

    public static RootTemplate fromHttpWSService(BLangService service, BLangTypeInit init, BLangPackage builtTestFile, BiConsumer<Integer, Integer> focusLineAcceptor) {
        RootTemplate rootTemplate = new RootTemplate(builtTestFile, focusLineAcceptor);
        rootTemplate.httpWSServices.add((Pair<BLangService, BLangTypeInit>)new ImmutablePair((Object)service, (Object)init));
        return rootTemplate;
    }

    @Override
    public void render(RendererOutput rendererOutput) throws TestGeneratorException {
        BLangTypeInit init;
        BLangService service;
        BiConsumer<String, String> importsAcceptor = (orgName, alias) -> {
            if (this.isNonExistImport((String)orgName, (String)alias)) {
                rendererOutput.append(PlaceHolder.IMPORTS, "import " + orgName + "/" + alias + ";" + LINE_FEED);
                this.imports.add(new ImmutablePair(orgName, alias));
                this.focusLineAcceptor.accept(null, 1);
            }
        };
        importsAcceptor.accept("ballerina", "test");
        importsAcceptor.accept("ballerina", "log");
        if (this.httpServices.size() > 0 || this.httpWSServices.size() > 0 || this.httpWSClientServices.size() > 0) {
            importsAcceptor.accept("ballerina", "http");
        }
        for (BLangFunction bLangFunction : this.functions) {
            TestGenerator.TestFunctionGenerator generator = new TestGenerator.TestFunctionGenerator(importsAcceptor, this.builtTestFile.packageID, bLangFunction);
            new FunctionTemplate(this.builtTestFile, bLangFunction, this.focusLineAcceptor, generator).render(rendererOutput);
        }
        for (Pair pair : this.httpServices) {
            service = (BLangService)pair.getLeft();
            init = (BLangTypeInit)pair.getRight();
            new HttpServiceTemplate(this.builtTestFile, service, init, this.focusLineAcceptor).render(rendererOutput);
        }
        for (Pair pair : this.httpWSServices) {
            service = (BLangService)pair.getLeft();
            init = (BLangTypeInit)pair.getRight();
            new WSServiceTemplate(this.builtTestFile, service, init, this.focusLineAcceptor).render(rendererOutput);
        }
    }
}

