/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.command.testgen.template.type;

import java.util.List;
import java.util.function.BiConsumer;
import org.ballerinalang.langserver.command.testgen.TestGenerator;
import org.ballerinalang.langserver.command.testgen.TestGeneratorException;
import org.ballerinalang.langserver.command.testgen.renderer.RendererOutput;
import org.ballerinalang.langserver.command.testgen.renderer.TemplateBasedRendererOutput;
import org.ballerinalang.langserver.command.testgen.template.AbstractTestTemplate;
import org.ballerinalang.langserver.command.testgen.template.PlaceHolder;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.wso2.ballerinalang.compiler.semantics.model.types.BNilType;
import org.wso2.ballerinalang.compiler.tree.BLangFunction;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;

public class FunctionTemplate
extends AbstractTestTemplate {
    private final String testFunctionName;
    private final List<String> functionInvocations;
    private final String dataProviderBasedFunctionInvocation;
    private final String dataProviderReturnType;
    private final String dataProviderReturnValue;
    private final String testFunctionParams;
    private final boolean hasReturnType;
    private final boolean hasParams;

    public FunctionTemplate(BLangPackage builtTestFile, BLangFunction function, BiConsumer<Integer, Integer> focusLineAcceptor, TestGenerator.TestFunctionGenerator generator) {
        super(builtTestFile, focusLineAcceptor);
        String functionName = function.name.value;
        this.testFunctionName = this.getSafeName("test" + FunctionTemplate.upperCaseFirstLetter(functionName));
        this.hasReturnType = function.returnTypeNode != null && !(function.returnTypeNode.type instanceof BNilType);
        this.hasParams = generator.getParamsCount() > 0;
        this.functionInvocations = generator.getTargetFuncInvocations();
        this.dataProviderBasedFunctionInvocation = this.hasReturnType ? generator.getTargetFuncReturnType() + " actual = " + generator.getTargetFuncInvocation() + ";" : generator.getTargetFuncInvocation() + ";";
        this.testFunctionParams = generator.getTestFuncParams();
        this.dataProviderReturnType = generator.getDataProviderReturnType();
        this.dataProviderReturnValue = generator.getDataProviderReturnValue();
    }

    @Override
    public void render(RendererOutput rendererOutput) throws TestGeneratorException {
        String filename = this.hasReturnType ? "returnTypedFunction.bal" : (this.hasParams ? "voidFunction.bal" : "voidFunctionNoParams.bal");
        TemplateBasedRendererOutput functionOutput = new TemplateBasedRendererOutput(filename);
        functionOutput.put(PlaceHolder.OTHER.get("testFunctionName"), this.testFunctionName);
        functionOutput.put(PlaceHolder.OTHER.get("dataProviderReturnType"), this.dataProviderReturnType);
        functionOutput.put(PlaceHolder.OTHER.get("dataProviderReturnValue"), this.dataProviderReturnValue);
        functionOutput.put(PlaceHolder.OTHER.get("testFunctionParams"), this.testFunctionParams);
        String functionInvocationLine = this.dataProviderBasedFunctionInvocation;
        if (!this.hasReturnType && !this.hasParams) {
            functionInvocationLine = "    " + this.functionInvocations.get(0) + ";";
        }
        functionOutput.put(PlaceHolder.OTHER.get("actual"), functionInvocationLine);
        rendererOutput.setFocusLineAcceptor(this.testFunctionName, this.focusLineAcceptor);
        rendererOutput.append(PlaceHolder.CONTENT, CommonUtil.LINE_SEPARATOR + functionOutput.getRenderedContent());
    }
}

