/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.common.utils.completion;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.CommonToken;
import org.ballerinalang.langserver.common.CommonKeys;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.commons.LSContext;
import org.ballerinalang.langserver.commons.completion.LSCompletionItem;
import org.ballerinalang.langserver.completions.SymbolCompletionItem;
import org.ballerinalang.langserver.completions.builder.BFunctionCompletionItemBuilder;
import org.ballerinalang.langserver.completions.builder.BVariableCompletionItemBuilder;
import org.ballerinalang.langserver.sourceprune.SourcePruneKeys;
import org.eclipse.lsp4j.CompletionItem;
import org.wso2.ballerinalang.compiler.semantics.model.Scope;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BConstantSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BConstructorSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BInvokableSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BVarSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.types.BField;
import org.wso2.ballerinalang.compiler.semantics.model.types.BMapType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BRecordType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BUnionType;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRecordLiteral;

public class BLangRecordLiteralUtil {
    private static final String ELLIPSIS = "...";

    private BLangRecordLiteralUtil() {
    }

    public static List<LSCompletionItem> getFieldsForMatchingRecord(LSContext context, BLangRecordLiteral recordLiteral) {
        Optional<BType> evalType;
        BType expectedType = recordLiteral.expectedType;
        List visibleSymbols = (List)context.get(CommonKeys.VISIBLE_SYMBOLS_KEY);
        Optional<BType> optional = evalType = expectedType instanceof BUnionType ? BLangRecordLiteralUtil.getRecordTypeFromUnionType(expectedType) : Optional.ofNullable(expectedType);
        if (!evalType.isPresent()) {
            return new ArrayList<LSCompletionItem>();
        }
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>(BLangRecordLiteralUtil.getSpreadCompletionItems(context, evalType.get()));
        List commonTokens = (List)context.get(SourcePruneKeys.LHS_DEFAULT_TOKENS_KEY);
        String lastToken = commonTokens.isEmpty() ? "" : ((CommonToken)commonTokens.get(commonTokens.size() - 1)).getText();
        long dotCount = lastToken.codePoints().filter(charVal -> charVal == 46).count();
        if (dotCount < 1L && evalType.get() instanceof BRecordType) {
            List fields = ((BRecordType)evalType.get()).fields;
            completionItems.addAll(CommonUtil.getRecordFieldCompletionItems(context, fields));
            completionItems.add(CommonUtil.getFillAllStructFieldsItem(context, fields));
            completionItems.addAll(BLangRecordLiteralUtil.getVariableCompletionsForFields(context, visibleSymbols, fields));
        }
        return completionItems;
    }

    private static Optional<BType> getRecordTypeFromUnionType(BType bType) {
        if (!(bType instanceof BUnionType)) {
            return Optional.empty();
        }
        List filteredRecords = ((BUnionType)bType).getMemberTypes().stream().filter(type -> type instanceof BRecordType).collect(Collectors.toList());
        if (filteredRecords.size() == 1) {
            return Optional.ofNullable(filteredRecords.get(0));
        }
        return Optional.empty();
    }

    private static List<LSCompletionItem> getVariableCompletionsForFields(LSContext ctx, List<Scope.ScopeEntry> visibleSymbols, List<BField> recordFields) {
        HashMap filedTypeMap = new HashMap();
        recordFields.forEach(bField -> filedTypeMap.put(bField.name.value, bField.type));
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        visibleSymbols.forEach(scopeEntry -> {
            BSymbol symbol = scopeEntry.symbol;
            BType type = symbol instanceof BConstantSymbol ? ((BConstantSymbol)symbol).literalType : symbol.type;
            String symbolName = symbol.name.getValue();
            if (filedTypeMap.containsKey(symbolName) && filedTypeMap.get(symbolName) == type && symbol instanceof BVarSymbol) {
                String bTypeName = CommonUtil.getBTypeName(type, ctx, false);
                CompletionItem cItem = BVariableCompletionItemBuilder.build((BVarSymbol)symbol, symbolName, bTypeName);
                completionItems.add(new SymbolCompletionItem(ctx, symbol, cItem));
            }
        });
        return completionItems;
    }

    private static List<LSCompletionItem> getSpreadCompletionItems(LSContext context, BType evalType) {
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        List<BType> typeList = BLangRecordLiteralUtil.getTypeListForMapAndRecords(evalType);
        ArrayList<Scope.ScopeEntry> visibleSymbols = new ArrayList<Scope.ScopeEntry>((Collection)context.get(CommonKeys.VISIBLE_SYMBOLS_KEY));
        visibleSymbols.removeIf(CommonUtil.invalidSymbolsPredicate());
        for (Scope.ScopeEntry visibleSymbol : visibleSymbols) {
            BSymbol symbol = visibleSymbol.symbol;
            BLangRecordLiteralUtil.getSpreadableCompletionItem(context, symbol, typeList).ifPresent(completionItems::add);
        }
        return completionItems;
    }

    private static Optional<LSCompletionItem> getSpreadableCompletionItem(LSContext context, BSymbol bSymbol, List<BType> refTypeList) {
        CompletionItem cItem;
        boolean canSpread;
        BType bType;
        if (bSymbol instanceof BInvokableSymbol && !(bSymbol instanceof BConstructorSymbol)) {
            bType = ((BInvokableSymbol)bSymbol).retType;
        } else if (bSymbol instanceof BVarSymbol && !(bSymbol instanceof BConstructorSymbol)) {
            bType = bSymbol.type;
        } else {
            return Optional.empty();
        }
        List<BType> symbolTypeList = BLangRecordLiteralUtil.getTypeListForMapAndRecords(bType);
        boolean bl = canSpread = !symbolTypeList.isEmpty() && refTypeList.containsAll(symbolTypeList);
        if (canSpread && bSymbol instanceof BInvokableSymbol) {
            cItem = BFunctionCompletionItemBuilder.build((BInvokableSymbol)bSymbol, context);
        } else if (canSpread) {
            cItem = BVariableCompletionItemBuilder.build((BVarSymbol)bSymbol, bSymbol.name.getValue(), CommonUtil.getBTypeName(bType, context, false));
        } else {
            return Optional.empty();
        }
        BLangRecordLiteralUtil.modifySpreadCompletionItem(context, cItem);
        return Optional.of(new SymbolCompletionItem(context, bSymbol, cItem));
    }

    private static List<BType> getTypeListForMapAndRecords(BType bType) {
        if (bType instanceof BMapType) {
            BType constraint = ((BMapType)bType).constraint;
            if (constraint instanceof BUnionType) {
                return new ArrayList<BType>(((BUnionType)constraint).getMemberTypes());
            }
            return Collections.singletonList(constraint);
        }
        if (bType instanceof BRecordType) {
            return ((BRecordType)bType).fields.stream().map(bField -> bField.type).collect(Collectors.toList());
        }
        return new ArrayList<BType>();
    }

    private static void modifySpreadCompletionItem(LSContext context, CompletionItem cItem) {
        List commonTokens = (List)context.get(SourcePruneKeys.LHS_DEFAULT_TOKENS_KEY);
        String lastToken = commonTokens.isEmpty() ? "" : ((CommonToken)commonTokens.get(commonTokens.size() - 1)).getText();
        long dotCount = lastToken.codePoints().filter(charVal -> charVal == 46).count();
        String prefix = String.join((CharSequence)"", Collections.nCopies(ELLIPSIS.length() - Math.toIntExact(dotCount), "."));
        cItem.setInsertText(prefix + cItem.getInsertText());
        cItem.setLabel(ELLIPSIS + cItem.getLabel());
    }
}

