/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions;

import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import org.ballerinalang.langserver.commons.completion.spi.LSCompletionProvider;

public class LSCompletionProviderHolder {
    private static final Map<Class, LSCompletionProvider> providers = new HashMap<Class, LSCompletionProvider>();
    private static final LSCompletionProviderHolder INSTANCE = new LSCompletionProviderHolder();

    private LSCompletionProviderHolder() {
        ServiceLoader<LSCompletionProvider> providerServices = ServiceLoader.load(LSCompletionProvider.class);
        for (LSCompletionProvider provider : providerServices) {
            if (provider == null) continue;
            for (Class attachmentPoint : provider.getAttachmentPoints()) {
                if (providers.containsKey(attachmentPoint) && (providers.get(attachmentPoint).getPrecedence() != LSCompletionProvider.Precedence.LOW || provider.getPrecedence() != LSCompletionProvider.Precedence.HIGH)) continue;
                providers.put(attachmentPoint, provider);
            }
        }
    }

    public static LSCompletionProviderHolder getInstance() {
        return INSTANCE;
    }

    public void register(LSCompletionProvider provider) {
        for (Class attachmentPoint : provider.getAttachmentPoints()) {
            providers.put(attachmentPoint, provider);
        }
    }

    public void unregister(LSCompletionProvider provider) {
        for (Class attachmentPoint : provider.getAttachmentPoints()) {
            providers.remove(attachmentPoint, provider);
        }
    }

    public Map<Class, LSCompletionProvider> getProviders() {
        return providers;
    }

    public LSCompletionProvider getProvider(Class key) {
        return providers.get(key);
    }
}

