/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.ballerinalang.langserver.common.CommonKeys;
import org.ballerinalang.langserver.common.LSNodeVisitor;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.commons.LSContext;
import org.ballerinalang.langserver.commons.completion.AnnotationNodeKind;
import org.ballerinalang.langserver.commons.completion.CompletionKeys;
import org.ballerinalang.langserver.compiler.DocumentServiceKeys;
import org.ballerinalang.langserver.completions.exceptions.CompletionContextNotSupportedException;
import org.ballerinalang.langserver.completions.util.CompletionVisitorUtil;
import org.ballerinalang.langserver.completions.util.CursorPositionResolvers;
import org.ballerinalang.langserver.completions.util.positioning.resolvers.BlockStatementScopeResolver;
import org.ballerinalang.langserver.completions.util.positioning.resolvers.CursorPositionResolver;
import org.ballerinalang.langserver.completions.util.positioning.resolvers.ForkJoinStatementScopeResolver;
import org.ballerinalang.langserver.completions.util.positioning.resolvers.InvocationParameterScopeResolver;
import org.ballerinalang.langserver.completions.util.positioning.resolvers.MatchExpressionScopeResolver;
import org.ballerinalang.langserver.completions.util.positioning.resolvers.MatchStatementScopeResolver;
import org.ballerinalang.langserver.completions.util.positioning.resolvers.ObjectTypeScopeResolver;
import org.ballerinalang.langserver.completions.util.positioning.resolvers.RecordLiteralScopeResolver;
import org.ballerinalang.langserver.completions.util.positioning.resolvers.RecordScopeResolver;
import org.ballerinalang.langserver.completions.util.positioning.resolvers.ServiceScopeResolver;
import org.ballerinalang.langserver.completions.util.positioning.resolvers.TopLevelNodeScopeResolver;
import org.ballerinalang.model.Whitespace;
import org.ballerinalang.model.elements.Flag;
import org.ballerinalang.model.elements.PackageID;
import org.ballerinalang.model.symbols.AnnotationSymbol;
import org.ballerinalang.model.tree.BlockNode;
import org.ballerinalang.model.tree.Node;
import org.ballerinalang.model.tree.TopLevelNode;
import org.ballerinalang.model.tree.statements.StatementNode;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.TextDocumentPositionParams;
import org.wso2.ballerinalang.compiler.semantics.analyzer.SymbolResolver;
import org.wso2.ballerinalang.compiler.semantics.model.Scope;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolEnv;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BConstantSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BInvokableSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BObjectTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BRecordTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BServiceSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BVarSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.types.BFutureType;
import org.wso2.ballerinalang.compiler.tree.BLangAnnotation;
import org.wso2.ballerinalang.compiler.tree.BLangAnnotationAttachment;
import org.wso2.ballerinalang.compiler.tree.BLangBlockFunctionBody;
import org.wso2.ballerinalang.compiler.tree.BLangExprFunctionBody;
import org.wso2.ballerinalang.compiler.tree.BLangExternalFunctionBody;
import org.wso2.ballerinalang.compiler.tree.BLangFunction;
import org.wso2.ballerinalang.compiler.tree.BLangFunctionBody;
import org.wso2.ballerinalang.compiler.tree.BLangImportPackage;
import org.wso2.ballerinalang.compiler.tree.BLangNode;
import org.wso2.ballerinalang.compiler.tree.BLangNodeVisitor;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;
import org.wso2.ballerinalang.compiler.tree.BLangService;
import org.wso2.ballerinalang.compiler.tree.BLangSimpleVariable;
import org.wso2.ballerinalang.compiler.tree.BLangTypeDefinition;
import org.wso2.ballerinalang.compiler.tree.BLangWorker;
import org.wso2.ballerinalang.compiler.tree.BLangXMLNS;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangDoClause;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangBinaryExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangConstant;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangGroupExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangInvocation;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLambdaFunction;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangListConstructorExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangMatchExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangNamedArgsExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangQueryAction;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRecordLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangSimpleVarRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypeConversionExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypeInit;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWorkerReceive;
import org.wso2.ballerinalang.compiler.tree.statements.BLangAbort;
import org.wso2.ballerinalang.compiler.tree.statements.BLangAssignment;
import org.wso2.ballerinalang.compiler.tree.statements.BLangBlockStmt;
import org.wso2.ballerinalang.compiler.tree.statements.BLangBreak;
import org.wso2.ballerinalang.compiler.tree.statements.BLangCompoundAssignment;
import org.wso2.ballerinalang.compiler.tree.statements.BLangContinue;
import org.wso2.ballerinalang.compiler.tree.statements.BLangErrorVariableDef;
import org.wso2.ballerinalang.compiler.tree.statements.BLangExpressionStmt;
import org.wso2.ballerinalang.compiler.tree.statements.BLangForeach;
import org.wso2.ballerinalang.compiler.tree.statements.BLangForkJoin;
import org.wso2.ballerinalang.compiler.tree.statements.BLangIf;
import org.wso2.ballerinalang.compiler.tree.statements.BLangLock;
import org.wso2.ballerinalang.compiler.tree.statements.BLangMatch;
import org.wso2.ballerinalang.compiler.tree.statements.BLangPanic;
import org.wso2.ballerinalang.compiler.tree.statements.BLangReturn;
import org.wso2.ballerinalang.compiler.tree.statements.BLangSimpleVariableDef;
import org.wso2.ballerinalang.compiler.tree.statements.BLangTransaction;
import org.wso2.ballerinalang.compiler.tree.statements.BLangTupleVariableDef;
import org.wso2.ballerinalang.compiler.tree.statements.BLangWhile;
import org.wso2.ballerinalang.compiler.tree.statements.BLangWorkerSend;
import org.wso2.ballerinalang.compiler.tree.types.BLangObjectTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangRecordTypeNode;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.Name;
import org.wso2.ballerinalang.compiler.util.diagnotic.DiagnosticPos;

public class TreeVisitor
extends LSNodeVisitor {
    private boolean terminateVisitor = false;
    private int loopCount = 0;
    private int transactionCount = 0;
    private SymbolEnv symbolEnv;
    private SymbolResolver symbolResolver;
    private SymbolTable symTable;
    private Deque<Node> blockOwnerStack;
    private Deque<BlockNode> blockStmtStack;
    private Deque<Boolean> isCurrentNodeTransactionStack;
    private Deque<BLangForkJoin> forkJoinStack;
    private Class cursorPositionResolver;
    private LSContext lsContext;
    private BLangNode previousNode = null;

    public TreeVisitor(LSContext documentServiceContext) {
        this.lsContext = documentServiceContext;
        this.init((CompilerContext)this.lsContext.get(DocumentServiceKeys.COMPILER_CONTEXT_KEY));
    }

    private void init(CompilerContext compilerContext) {
        this.blockOwnerStack = new ArrayDeque<Node>();
        this.blockStmtStack = new ArrayDeque<BlockNode>();
        this.isCurrentNodeTransactionStack = new ArrayDeque<Boolean>();
        this.forkJoinStack = new ArrayDeque<BLangForkJoin>();
        this.symTable = SymbolTable.getInstance((CompilerContext)compilerContext);
        this.symbolResolver = SymbolResolver.getInstance((CompilerContext)compilerContext);
    }

    @Override
    public void visit(BLangPackage pkgNode) {
        BLangPackage evalPkg;
        boolean isTestSrc = CommonUtil.isTestSource((String)this.lsContext.get(DocumentServiceKeys.RELATIVE_FILE_PATH_KEY));
        Object object = evalPkg = isTestSrc ? pkgNode.getTestablePkg() : pkgNode;
        if (evalPkg.symbol != null) {
            SymbolEnv pkgEnv;
            this.symbolEnv = pkgEnv = (SymbolEnv)this.symTable.pkgEnvMap.get(evalPkg.symbol);
            List<TopLevelNode> topLevelNodes = CommonUtil.getCurrentFileTopLevelNodes(evalPkg, this.lsContext);
            List filteredTopLevelNodes = topLevelNodes.stream().filter(CommonUtil.checkInvalidTypesDefs()).collect(Collectors.toList());
            for (int i = 0; i < filteredTopLevelNodes.size(); ++i) {
                this.cursorPositionResolver = TopLevelNodeScopeResolver.class;
                this.blockOwnerStack.push((Node)evalPkg);
                this.acceptNode((BLangNode)filteredTopLevelNodes.get(i), pkgEnv);
                if (!this.terminateVisitor || this.previousNode != null) continue;
                int nodeIndex = filteredTopLevelNodes.size() > 1 && i > 0 ? i - 1 : 0;
                this.previousNode = (BLangNode)filteredTopLevelNodes.get(nodeIndex);
                this.lsContext.put(CompletionKeys.PREVIOUS_NODE_KEY, (Object)this.previousNode);
            }
        } else {
            throw new IllegalStateException("TreeVisitor failed, evalPkg.symbol is NULL");
        }
        if (this.lsContext.get(CompletionKeys.SCOPE_NODE_KEY) == null) {
            this.lsContext.put(CompletionKeys.SCOPE_NODE_KEY, (Object)evalPkg);
            this.populateSymbols(this.resolveAllVisibleSymbols(this.getSymbolEnv()), this.getSymbolEnv());
            this.forceTerminateVisitor();
        }
    }

    @Override
    public void visit(BLangImportPackage importPkgNode) {
        CursorPositionResolvers.getResolverByClass(this.cursorPositionResolver).isCursorBeforeNode(importPkgNode.getPosition(), this, this.lsContext, (BLangNode)importPkgNode, (BSymbol)importPkgNode.symbol);
    }

    @Override
    public void visit(BLangXMLNS xmlnsNode) {
        CursorPositionResolvers.getResolverByClass(this.cursorPositionResolver).isCursorBeforeNode(xmlnsNode.getPosition(), this, this.lsContext, (BLangNode)xmlnsNode, xmlnsNode.symbol);
    }

    @Override
    public void visit(BLangLambdaFunction lambdaFunction) {
        this.acceptNode((BLangNode)lambdaFunction.function, this.symbolEnv);
    }

    @Override
    public void visit(BLangFunction funcNode) {
        SymbolEnv funcEnv = SymbolEnv.createFunctionEnv((BLangFunction)funcNode, (Scope)funcNode.symbol.scope, (SymbolEnv)this.symbolEnv);
        CursorPositionResolver cpr = CursorPositionResolvers.getResolverByClass(this.cursorPositionResolver);
        DiagnosticPos functionPos = CommonUtil.clonePosition(funcNode.getPosition());
        if (!funcNode.flagSet.contains(Flag.WORKER)) {
            funcNode.annAttachments.forEach(annotationAttachment -> this.acceptNode((BLangNode)annotationAttachment, this.symbolEnv));
            if (!funcNode.annAttachments.isEmpty()) {
                BLangAnnotationAttachment lastItem = (BLangAnnotationAttachment)CommonUtil.getLastItem(funcNode.annAttachments);
                if (lastItem == null) {
                    return;
                }
                ArrayList wsList = new ArrayList(funcNode.getWS());
                String[] firstWSItem = ((Whitespace)wsList.get(0)).getWs().split("\\r?\\n", -1);
                int precedingNewLines = firstWSItem.length - 1;
                functionPos.sLine = lastItem.pos.eLine + precedingNewLines;
                functionPos.sCol = firstWSItem[firstWSItem.length - 1].length() + 1;
            }
        } else if (funcNode.flagSet.contains(Flag.WORKER) && CompletionVisitorUtil.isWithinWorkerReturnContext(this.symbolEnv, this.lsContext, this, funcNode)) {
            return;
        }
        if (this.terminateVisitor || cpr.isCursorBeforeNode(functionPos, this, this.lsContext, (BLangNode)funcNode, (BSymbol)funcNode.symbol)) {
            return;
        }
        List<BLangNode> functionParamsOrdered = CompletionVisitorUtil.getFunctionParamsOrdered(funcNode);
        functionParamsOrdered.forEach(param -> this.acceptNode((BLangNode)param, this.symbolEnv));
        funcNode.returnTypeAnnAttachments.forEach(annotation -> this.acceptNode((BLangNode)annotation, this.symbolEnv));
        if (funcNode.hasBody()) {
            this.blockOwnerStack.push((Node)funcNode);
            this.cursorPositionResolver = BlockStatementScopeResolver.class;
            this.acceptNode((BLangNode)funcNode.body, funcEnv);
            this.blockOwnerStack.pop();
        }
    }

    @Override
    public void visit(BLangTypeDefinition typeDefinition) {
        if ((typeDefinition.symbol.flags & 0x80000) == 524288) {
            return;
        }
        typeDefinition.annAttachments.forEach(annotation -> this.acceptNode((BLangNode)annotation, this.symbolEnv));
        CursorPositionResolver cpr = CursorPositionResolvers.getResolverByClass(this.cursorPositionResolver);
        if (cpr.isCursorBeforeNode(typeDefinition.getPosition(), this, this.lsContext, (BLangNode)typeDefinition, (BSymbol)typeDefinition.symbol)) {
            return;
        }
        this.acceptNode((BLangNode)typeDefinition.typeNode, this.symbolEnv);
    }

    @Override
    public void visit(BLangConstant constant) {
        CursorPositionResolver cpr = CursorPositionResolvers.getResolverByClass(this.cursorPositionResolver);
        if (cpr.isCursorBeforeNode(constant.getPosition(), this, this.lsContext, (BLangNode)constant, (BSymbol)constant.symbol)) {
            return;
        }
        this.acceptNode((BLangNode)constant.typeNode, this.symbolEnv);
    }

    @Override
    public void visit(BLangRecordTypeNode recordTypeNode) {
        boolean cursorWithinBlock;
        BSymbol recordSymbol = recordTypeNode.symbol;
        CursorPositionResolver cpr = CursorPositionResolvers.getResolverByClass(this.cursorPositionResolver);
        SymbolEnv recordEnv = SymbolEnv.createPkgLevelSymbolEnv((BLangNode)recordTypeNode, (Scope)recordSymbol.scope, (SymbolEnv)this.symbolEnv);
        boolean cursorBeforeNode = cpr.isCursorBeforeNode(recordTypeNode.parent.getPosition(), this, this.lsContext, (BLangNode)recordTypeNode, recordSymbol);
        boolean bl = cursorWithinBlock = recordTypeNode.fields.isEmpty() && CompletionVisitorUtil.isCursorWithinBlock(recordTypeNode.parent.getPosition(), recordEnv, this.lsContext, this);
        if (recordSymbol.getName().getValue().contains("$") || cursorBeforeNode || cursorWithinBlock) {
            return;
        }
        this.cursorPositionResolver = RecordScopeResolver.class;
        this.blockOwnerStack.push((Node)recordTypeNode);
        recordTypeNode.fields.forEach(field -> this.acceptNode((BLangNode)field, recordEnv));
        this.cursorPositionResolver = TopLevelNodeScopeResolver.class;
        this.blockOwnerStack.pop();
    }

    @Override
    public void visit(BLangObjectTypeNode objectTypeNode) {
        BSymbol objectSymbol = objectTypeNode.symbol;
        SymbolEnv objectEnv = SymbolEnv.createPkgLevelSymbolEnv((BLangNode)objectTypeNode, (Scope)objectSymbol.scope, (SymbolEnv)this.symbolEnv);
        List<BLangNode> objectItems = CompletionVisitorUtil.getObjectItemsOrdered(objectTypeNode);
        if (objectItems.isEmpty() && CompletionVisitorUtil.isCursorWithinBlock(objectTypeNode.parent.getPosition(), objectEnv, this.lsContext, this)) {
            return;
        }
        this.blockOwnerStack.push((Node)objectTypeNode);
        objectItems.forEach(item -> {
            this.cursorPositionResolver = ObjectTypeScopeResolver.class;
            this.acceptNode((BLangNode)item, objectEnv);
        });
        this.blockOwnerStack.pop();
        this.cursorPositionResolver = TopLevelNodeScopeResolver.class;
    }

    @Override
    public void visit(BLangSimpleVariable varNode) {
        CursorPositionResolver cpr = CursorPositionResolvers.getResolverByClass(this.cursorPositionResolver);
        varNode.annAttachments.forEach(annotationAttachment -> this.acceptNode((BLangNode)annotationAttachment, this.symbolEnv));
        if (cpr.isCursorBeforeNode(varNode.getPosition(), this, this.lsContext, (BLangNode)varNode, (BSymbol)varNode.symbol) || varNode.expr == null) {
            return;
        }
        this.acceptNode((BLangNode)varNode.expr, this.symbolEnv);
    }

    @Override
    public void visit(BLangBinaryExpr binaryExpr) {
        binaryExpr.getLeftExpression().accept((BLangNodeVisitor)this);
        binaryExpr.getRightExpression().accept((BLangNodeVisitor)this);
    }

    @Override
    public void visit(BLangListConstructorExpr listConstructorExpr) {
        listConstructorExpr.getExpressions().forEach(bLangExpression -> this.acceptNode((BLangNode)bLangExpression, this.symbolEnv));
    }

    @Override
    public void visit(BLangGroupExpr groupExpr) {
        groupExpr.expression.accept((BLangNodeVisitor)this);
    }

    @Override
    public void visit(BLangTypeConversionExpr conversionExpr) {
        conversionExpr.expr.accept((BLangNodeVisitor)this);
    }

    @Override
    public void visit(BLangBlockStmt blockNode) {
        SymbolEnv blockEnv = SymbolEnv.createBlockEnv((BLangBlockStmt)blockNode, (SymbolEnv)this.symbolEnv);
        List statements = blockNode.stmts.stream().filter(bLangStatement -> !CommonUtil.isWorkerDereivative((StatementNode)bLangStatement)).sorted(new CommonUtil.BLangNodeComparator()).collect(Collectors.toList());
        if (statements.isEmpty() && CompletionVisitorUtil.isCursorWithinBlock((DiagnosticPos)this.blockOwnerStack.peek().getPosition(), blockEnv, this.lsContext, this)) {
            return;
        }
        for (int i = 0; i < statements.size(); ++i) {
            this.blockStmtStack.push((BlockNode)blockNode);
            this.cursorPositionResolver = BlockStatementScopeResolver.class;
            this.acceptNode((BLangNode)statements.get(i), blockEnv);
            if (this.terminateVisitor && this.previousNode == null) {
                int nodeIndex = statements.size() > 1 && i > 0 ? i - 1 : 0;
                this.previousNode = (BLangNode)statements.get(nodeIndex);
                this.lsContext.put(CompletionKeys.PREVIOUS_NODE_KEY, (Object)this.previousNode);
            }
            this.blockStmtStack.pop();
        }
    }

    @Override
    public void visit(BLangBlockFunctionBody blockFuncBody) {
        SymbolEnv blockEnv = SymbolEnv.createFuncBodyEnv((BLangFunctionBody)blockFuncBody, (SymbolEnv)this.symbolEnv);
        List statements = blockFuncBody.stmts.stream().filter(bLangStatement -> !CommonUtil.isWorkerDereivative((StatementNode)bLangStatement)).sorted(new CommonUtil.BLangNodeComparator()).collect(Collectors.toList());
        if (statements.isEmpty() && CompletionVisitorUtil.isCursorWithinBlock((DiagnosticPos)this.blockOwnerStack.peek().getPosition(), blockEnv, this.lsContext, this)) {
            return;
        }
        for (int i = 0; i < statements.size(); ++i) {
            this.blockStmtStack.push((BlockNode)blockFuncBody);
            this.cursorPositionResolver = BlockStatementScopeResolver.class;
            this.acceptNode((BLangNode)statements.get(i), blockEnv);
            if (this.terminateVisitor && this.previousNode == null) {
                int nodeIndex = statements.size() > 1 && i > 0 ? i - 1 : 0;
                this.previousNode = (BLangNode)statements.get(nodeIndex);
                this.lsContext.put(CompletionKeys.PREVIOUS_NODE_KEY, (Object)this.previousNode);
            }
            this.blockStmtStack.pop();
        }
    }

    @Override
    public void visit(BLangExternalFunctionBody body) {
        for (BLangAnnotationAttachment annotation : body.annAttachments) {
            this.acceptNode((BLangNode)annotation, this.symbolEnv);
        }
    }

    @Override
    public void visit(BLangExprFunctionBody exprFuncBody) {
        SymbolEnv exprBodyEnv = SymbolEnv.createFuncBodyEnv((BLangFunctionBody)exprFuncBody, (SymbolEnv)this.symbolEnv);
        this.acceptNode((BLangNode)exprFuncBody.expr, exprBodyEnv);
    }

    @Override
    public void visit(BLangSimpleVariableDef varDefNode) {
        boolean isFuture = varDefNode.getVariable().expr != null && varDefNode.getVariable().expr.type instanceof BFutureType;
        CursorPositionResolver cpr = CursorPositionResolvers.getResolverByClass(this.cursorPositionResolver);
        if (isFuture || cpr.isCursorBeforeNode(varDefNode.getPosition(), this, this.lsContext, (BLangNode)varDefNode, (BSymbol)varDefNode.getVariable().symbol)) {
            return;
        }
        this.acceptNode((BLangNode)varDefNode.var, this.symbolEnv);
    }

    @Override
    public void visit(BLangAssignment assignNode) {
        CursorPositionResolver cpr = CursorPositionResolvers.getResolverByClass(this.cursorPositionResolver);
        if (cpr.isCursorBeforeNode(assignNode.getPosition(), this, this.lsContext, (BLangNode)assignNode, null)) {
            return;
        }
        this.acceptNode((BLangNode)assignNode.expr, this.symbolEnv);
    }

    @Override
    public void visit(BLangExpressionStmt exprStmtNode) {
        CursorPositionResolver cpr = CursorPositionResolvers.getResolverByClass(this.cursorPositionResolver);
        if (cpr.isCursorBeforeNode(exprStmtNode.getPosition(), this, this.lsContext, (BLangNode)exprStmtNode, null) || !(exprStmtNode.expr instanceof BLangInvocation)) {
            return;
        }
        this.acceptNode((BLangNode)exprStmtNode.expr, this.symbolEnv);
    }

    @Override
    public void visit(BLangInvocation invocationNode) {
        CursorPositionResolver cpr = CursorPositionResolvers.getResolverByClass(this.cursorPositionResolver);
        if (cpr.isCursorBeforeNode(invocationNode.getPosition(), this, this.lsContext, (BLangNode)invocationNode, invocationNode.symbol)) {
            return;
        }
        TreeVisitor visitor = this;
        Class fallbackCursorPositionResolver = this.cursorPositionResolver;
        this.cursorPositionResolver = InvocationParameterScopeResolver.class;
        this.blockOwnerStack.push((Node)invocationNode);
        invocationNode.getArgumentExpressions().forEach(expressionNode -> {
            BLangNode node = (BLangNode)expressionNode;
            CursorPositionResolver posResolver = CursorPositionResolvers.getResolverByClass(this.cursorPositionResolver);
            posResolver.isCursorBeforeNode(node.getPosition(), visitor, visitor.lsContext, node, null);
            visitor.acceptNode(node, this.symbolEnv);
        });
        if (!this.terminateVisitor && (CompletionVisitorUtil.withinInvocationArguments((BLangNode)invocationNode, this.lsContext) || CompletionVisitorUtil.cursorBeforeInvocationNode((BLangNode)invocationNode, this.lsContext))) {
            Map<Name, List<Scope.ScopeEntry>> visibleSymbolEntries = this.resolveAllVisibleSymbols(this.symbolEnv);
            this.populateSymbols(visibleSymbolEntries, this.symbolEnv);
            this.forceTerminateVisitor();
        }
        this.blockOwnerStack.pop();
        this.cursorPositionResolver = fallbackCursorPositionResolver;
    }

    @Override
    public void visit(BLangIf ifNode) {
        CursorPositionResolver cpr = CursorPositionResolvers.getResolverByClass(this.cursorPositionResolver);
        if (CompletionVisitorUtil.isWithinConditionContext(this.symbolEnv, this.lsContext, this, (BLangNode)ifNode) || cpr.isCursorBeforeNode(ifNode.getPosition(), this, this.lsContext, (BLangNode)ifNode, null)) {
            return;
        }
        this.blockOwnerStack.push((Node)ifNode);
        this.acceptNode((BLangNode)ifNode.body, this.symbolEnv);
        this.blockOwnerStack.pop();
        if (ifNode.elseStmt != null) {
            this.blockOwnerStack.push((Node)ifNode.elseStmt);
            this.acceptNode((BLangNode)ifNode.elseStmt, this.symbolEnv);
            this.blockOwnerStack.pop();
        }
    }

    @Override
    public void visit(BLangWhile whileNode) {
        CursorPositionResolver cpr = CursorPositionResolvers.getResolverByClass(this.cursorPositionResolver);
        if (CompletionVisitorUtil.isWithinConditionContext(this.symbolEnv, this.lsContext, this, (BLangNode)whileNode) || cpr.isCursorBeforeNode(whileNode.getPosition(), this, this.lsContext, (BLangNode)whileNode, null)) {
            return;
        }
        this.blockOwnerStack.push((Node)whileNode);
        ++this.loopCount;
        this.acceptNode((BLangNode)whileNode.body, this.symbolEnv);
        --this.loopCount;
        this.blockOwnerStack.pop();
    }

    @Override
    public void visit(BLangService serviceNode) {
        BLangObjectTypeNode serviceType = (BLangObjectTypeNode)serviceNode.serviceTypeDefinition.typeNode;
        ArrayList<Object> serviceContent = new ArrayList<Object>();
        SymbolEnv serviceEnv = SymbolEnv.createServiceEnv((BLangService)serviceNode, (Scope)serviceType.symbol.scope, (SymbolEnv)this.symbolEnv);
        CursorPositionResolver cpr = CursorPositionResolvers.getResolverByClass(this.cursorPositionResolver);
        List serviceFunctions = ((BLangObjectTypeNode)serviceNode.serviceTypeDefinition.typeNode).getFunctions();
        List serviceFields = serviceType.getFields().stream().map(simpleVar -> (BLangSimpleVariable)simpleVar).collect(Collectors.toList());
        serviceContent.addAll(serviceFunctions);
        serviceContent.addAll(serviceFields);
        serviceContent.sort(new CommonUtil.BLangNodeComparator());
        serviceNode.annAttachments.forEach(annotationAttachment -> this.acceptNode((BLangNode)annotationAttachment, serviceEnv));
        boolean cursorWithinBlock = serviceFunctions.isEmpty() && serviceFields.isEmpty() && CompletionVisitorUtil.isCursorWithinBlock(serviceNode.getPosition(), serviceEnv, this.lsContext, this);
        boolean cursorWithinAttachedExprs = CompletionVisitorUtil.cursorWithinServiceExpressionList(serviceNode, serviceEnv, this.lsContext, this);
        if (cpr.isCursorBeforeNode(serviceNode.getPosition(), this, this.lsContext, (BLangNode)serviceNode, serviceNode.symbol) || cursorWithinBlock || cursorWithinAttachedExprs) {
            return;
        }
        this.blockOwnerStack.push((Node)serviceNode.serviceTypeDefinition.typeNode);
        for (int i = 0; i < serviceContent.size(); ++i) {
            this.cursorPositionResolver = ServiceScopeResolver.class;
            this.acceptNode((BLangNode)serviceContent.get(i), serviceEnv);
            if (!this.terminateVisitor || this.previousNode != null) continue;
            int nodeIndex = serviceContent.size() > 1 && i > 0 ? i - 1 : 0;
            this.previousNode = (BLangNode)serviceContent.get(nodeIndex);
            this.lsContext.put(CompletionKeys.PREVIOUS_NODE_KEY, (Object)this.previousNode);
        }
        this.blockOwnerStack.pop();
    }

    @Override
    public void visit(BLangTransaction transactionNode) {
        SymbolEnv transactionEnv = SymbolEnv.createTransactionEnv((BLangTransaction)transactionNode, (SymbolEnv)this.symbolEnv);
        this.blockOwnerStack.push((Node)transactionNode.transactionBody);
        this.isCurrentNodeTransactionStack.push(true);
        ++this.transactionCount;
        this.acceptNode((BLangNode)transactionNode.transactionBody, transactionEnv);
        this.blockOwnerStack.pop();
        this.isCurrentNodeTransactionStack.pop();
        --this.transactionCount;
        if (transactionNode.onRetryBody != null) {
            this.blockOwnerStack.push((Node)transactionNode.onRetryBody);
            this.acceptNode((BLangNode)transactionNode.onRetryBody, transactionEnv);
            this.blockOwnerStack.pop();
        }
        if (transactionNode.committedBody != null) {
            this.blockOwnerStack.push((Node)transactionNode.committedBody);
            this.acceptNode((BLangNode)transactionNode.committedBody, transactionEnv);
            this.blockOwnerStack.pop();
        }
        if (transactionNode.abortedBody != null) {
            this.blockOwnerStack.push((Node)transactionNode.abortedBody);
            this.acceptNode((BLangNode)transactionNode.abortedBody, transactionEnv);
            this.blockOwnerStack.pop();
        }
    }

    @Override
    public void visit(BLangAbort abortNode) {
        CursorPositionResolvers.getResolverByClass(this.cursorPositionResolver).isCursorBeforeNode(abortNode.getPosition(), this, this.lsContext, (BLangNode)abortNode, null);
    }

    @Override
    public void visit(BLangForkJoin forkJoin) {
        if (CursorPositionResolvers.getResolverByClass(this.cursorPositionResolver).isCursorBeforeNode(forkJoin.pos, this, this.lsContext, (BLangNode)forkJoin, null)) {
            return;
        }
        SymbolEnv folkJoinEnv = SymbolEnv.createFolkJoinEnv((BLangForkJoin)forkJoin, (SymbolEnv)this.symbolEnv);
        if (forkJoin.workers.isEmpty() && CompletionVisitorUtil.isCursorWithinBlock(forkJoin.pos, folkJoinEnv, this.lsContext, this)) {
            return;
        }
        Class backupResolver = this.cursorPositionResolver;
        this.forkJoinStack.push(forkJoin);
        forkJoin.workers.forEach(e -> {
            this.cursorPositionResolver = ForkJoinStatementScopeResolver.class;
            this.acceptNode((BLangNode)e, folkJoinEnv);
        });
        this.forkJoinStack.pop();
        this.cursorPositionResolver = backupResolver;
    }

    @Override
    public void visit(BLangWorker workerNode) {
        CursorPositionResolver cpr = CursorPositionResolvers.getResolverByClass(this.cursorPositionResolver);
        if (cpr.isCursorBeforeNode(workerNode.getPosition(), this, this.lsContext, (BLangNode)workerNode, (BSymbol)workerNode.symbol)) {
            return;
        }
        SymbolEnv workerEnv = SymbolEnv.createWorkerEnv((BLangWorker)workerNode, (SymbolEnv)this.symbolEnv);
        this.blockOwnerStack.push((Node)workerNode);
        this.acceptNode((BLangNode)workerNode.body, workerEnv);
        this.blockOwnerStack.pop();
    }

    @Override
    public void visit(BLangWorkerSend workerSendNode) {
        CursorPositionResolvers.getResolverByClass(this.cursorPositionResolver).isCursorBeforeNode(workerSendNode.getPosition(), this, this.lsContext, (BLangNode)workerSendNode, null);
    }

    @Override
    public void visit(BLangWorkerReceive workerReceiveNode) {
    }

    @Override
    public void visit(BLangReturn returnNode) {
        CursorPositionResolver cpr = CursorPositionResolvers.getResolverByClass(this.cursorPositionResolver);
        if (cpr.isCursorBeforeNode(returnNode.getPosition(), this, this.lsContext, (BLangNode)returnNode, null)) {
            return;
        }
        this.acceptNode((BLangNode)returnNode.expr, this.symbolEnv);
    }

    @Override
    public void visit(BLangContinue continueNode) {
        CursorPositionResolvers.getResolverByClass(this.cursorPositionResolver).isCursorBeforeNode(continueNode.getPosition(), this, this.lsContext, (BLangNode)continueNode, null);
    }

    @Override
    public void visit(BLangBreak breakNode) {
        CursorPositionResolvers.getResolverByClass(this.cursorPositionResolver).isCursorBeforeNode(breakNode.getPosition(), this, this.lsContext, (BLangNode)breakNode, null);
    }

    @Override
    public void visit(BLangPanic panicNode) {
        CursorPositionResolvers.getResolverByClass(this.cursorPositionResolver).isCursorBeforeNode(panicNode.getPosition(), this, this.lsContext, (BLangNode)panicNode, null);
    }

    @Override
    public void visit(BLangLock lockNode) {
        CursorPositionResolver cpr = CursorPositionResolvers.getResolverByClass(this.cursorPositionResolver);
        if (cpr.isCursorBeforeNode(lockNode.getPosition(), this, this.lsContext, (BLangNode)lockNode, null)) {
            return;
        }
        this.blockOwnerStack.push((Node)lockNode);
        this.acceptNode((BLangNode)lockNode.body, this.symbolEnv);
        this.blockOwnerStack.pop();
    }

    @Override
    public void visit(BLangForeach foreach) {
        if (!CursorPositionResolvers.getResolverByClass(this.cursorPositionResolver).isCursorBeforeNode(foreach.getPosition(), this, this.lsContext, (BLangNode)foreach, null)) {
            this.blockOwnerStack.push((Node)foreach);
            ++this.loopCount;
            this.acceptNode((BLangNode)foreach.body, this.symbolEnv);
            --this.loopCount;
            this.blockOwnerStack.pop();
        }
    }

    @Override
    public void visit(BLangMatch matchNode) {
        if (!CursorPositionResolvers.getResolverByClass(this.cursorPositionResolver).isCursorBeforeNode(matchNode.getPosition(), this, this.lsContext, (BLangNode)matchNode, null)) {
            this.blockOwnerStack.push((Node)matchNode);
            matchNode.patternClauses.forEach(patternClause -> {
                this.cursorPositionResolver = MatchStatementScopeResolver.class;
                this.acceptNode((BLangNode)patternClause, this.symbolEnv);
            });
            this.blockOwnerStack.pop();
        }
    }

    @Override
    public void visit(BLangAnnotationAttachment annAttachmentNode) {
        SymbolEnv annotationAttachmentEnv = new SymbolEnv((BLangNode)annAttachmentNode, this.symbolEnv.scope);
        this.symbolEnv.copyTo(annotationAttachmentEnv);
        if (annAttachmentNode.annotationSymbol == null) {
            return;
        }
        PackageID packageID = annAttachmentNode.annotationSymbol.pkgID;
        if (packageID.getOrgName().getValue().equals("ballerina") && packageID.getName().getValue().equals("grpc") && annAttachmentNode.annotationName.getValue().equals("ServiceDescriptor")) {
            return;
        }
        if (CursorPositionResolvers.getResolverByClass(this.cursorPositionResolver).isCursorBeforeNode(annAttachmentNode.getPosition(), this, this.lsContext, (BLangNode)annAttachmentNode, (BSymbol)annAttachmentNode.annotationSymbol)) {
            return;
        }
        this.acceptNode((BLangNode)annAttachmentNode.expr, annotationAttachmentEnv);
    }

    @Override
    public void visit(BLangMatchExpression bLangMatchExpression) {
        if (!CursorPositionResolvers.getResolverByClass(this.cursorPositionResolver).isCursorBeforeNode(bLangMatchExpression.getPosition(), this, this.lsContext, (BLangNode)bLangMatchExpression, null)) {
            SymbolEnv matchExprEnv = new SymbolEnv((BLangNode)bLangMatchExpression, this.symbolEnv.scope);
            this.symbolEnv.copyTo(matchExprEnv);
            TreeVisitor visitor = this;
            Class fallbackCursorPositionResolver = this.cursorPositionResolver;
            this.cursorPositionResolver = MatchExpressionScopeResolver.class;
            this.blockOwnerStack.push((Node)bLangMatchExpression);
            if (bLangMatchExpression.patternClauses.isEmpty()) {
                CompletionVisitorUtil.isCursorWithinBlock(bLangMatchExpression.getPosition(), matchExprEnv, this.lsContext, this);
            }
            bLangMatchExpression.getPatternClauses().forEach(patternClause -> {
                BLangMatchExpression.BLangMatchExprPatternClause node = patternClause;
                CursorPositionResolver posResolver = CursorPositionResolvers.getResolverByClass(this.cursorPositionResolver);
                posResolver.isCursorBeforeNode(node.getPosition(), visitor, visitor.lsContext, (BLangNode)node, null);
                visitor.acceptNode((BLangNode)node, matchExprEnv);
            });
            this.blockOwnerStack.pop();
            this.cursorPositionResolver = fallbackCursorPositionResolver;
        } else {
            this.populateSymbolEnvNode((BLangNode)bLangMatchExpression);
        }
    }

    @Override
    public void visit(BLangMatchExpression.BLangMatchExprPatternClause matchExprPatternClause) {
        if (!CursorPositionResolvers.getResolverByClass(this.cursorPositionResolver).isCursorBeforeNode(matchExprPatternClause.getPosition(), this, this.lsContext, (BLangNode)matchExprPatternClause, null) && matchExprPatternClause.expr != null) {
            this.acceptNode((BLangNode)matchExprPatternClause.expr, this.symbolEnv);
        }
    }

    @Override
    public void visit(BLangSimpleVarRef simpleVarRef) {
        CursorPositionResolvers.getResolverByClass(this.cursorPositionResolver).isCursorBeforeNode(simpleVarRef.getPosition(), this, this.lsContext, (BLangNode)simpleVarRef);
    }

    @Override
    public void visit(BLangRecordLiteral recordLiteral) {
        if (CursorPositionResolvers.getResolverByClass(this.cursorPositionResolver).isCursorBeforeNode(recordLiteral.getPosition(), this, this.lsContext, (BLangNode)recordLiteral)) {
            return;
        }
        SymbolEnv recordLiteralEnv = new SymbolEnv((BLangNode)recordLiteral, this.symbolEnv.scope);
        this.symbolEnv.copyTo(recordLiteralEnv);
        this.blockOwnerStack.push((Node)recordLiteral);
        List fields = recordLiteral.fields;
        if (fields.isEmpty() && CompletionVisitorUtil.isCursorWithinBlock(recordLiteral.pos, recordLiteralEnv, this.lsContext, this)) {
            return;
        }
        Class backUpResolver = this.cursorPositionResolver;
        fields.forEach(keyValue -> {
            this.cursorPositionResolver = RecordLiteralScopeResolver.class;
            this.acceptNode((Node)keyValue, recordLiteralEnv);
        });
        this.cursorPositionResolver = backUpResolver;
        this.blockOwnerStack.pop();
    }

    @Override
    public void visit(BLangMatch.BLangMatchStaticBindingPatternClause patternClause) {
        if (!CursorPositionResolvers.getResolverByClass(this.cursorPositionResolver).isCursorBeforeNode(patternClause.getPosition(), this, this.lsContext, (BLangNode)patternClause, null)) {
            this.visitMatchPatternClause((BLangNode)patternClause, patternClause.body);
        }
    }

    @Override
    public void visit(BLangMatch.BLangMatchStructuredBindingPatternClause patternClause) {
        if (!CursorPositionResolvers.getResolverByClass(this.cursorPositionResolver).isCursorBeforeNode(patternClause.getPosition(), this, this.lsContext, (BLangNode)patternClause, null)) {
            this.visitMatchPatternClause((BLangNode)patternClause, patternClause.body);
        }
    }

    @Override
    public void visit(BLangRecordLiteral.BLangRecordKeyValueField recordKeyValue) {
        if (CursorPositionResolvers.getResolverByClass(this.cursorPositionResolver).isCursorBeforeNode(recordKeyValue.valueExpr.getPosition(), this, this.lsContext, (BLangNode)recordKeyValue)) {
            return;
        }
        this.acceptNode((BLangNode)recordKeyValue.valueExpr, this.symbolEnv);
    }

    @Override
    public void visit(BLangTypeInit connectorInitExpr) {
        connectorInitExpr.argsExpr.forEach(bLangExpression -> this.acceptNode((BLangNode)bLangExpression, this.symbolEnv));
    }

    @Override
    public void visit(BLangNamedArgsExpression bLangNamedArgsExpression) {
        this.acceptNode((BLangNode)bLangNamedArgsExpression.expr, this.symbolEnv);
    }

    @Override
    public void visit(BLangAnnotation annotationNode) {
        annotationNode.annAttachments.forEach(annotation -> this.acceptNode((BLangNode)annotation, this.symbolEnv));
        CursorPositionResolver cpr = CursorPositionResolvers.getResolverByClass(this.cursorPositionResolver);
        cpr.isCursorBeforeNode(annotationNode.pos, this, this.lsContext, (BLangNode)annotationNode, annotationNode.symbol);
    }

    @Override
    public void visit(BLangTupleVariableDef bLangTupleVariableDef) {
        CursorPositionResolver cpr = CursorPositionResolvers.getResolverByClass(this.cursorPositionResolver);
        cpr.isCursorBeforeNode(bLangTupleVariableDef.getPosition(), this, this.lsContext, (BLangNode)bLangTupleVariableDef, null);
    }

    @Override
    public void visit(BLangLiteral literalExpr) {
        if (literalExpr.getPosition() == null) {
            return;
        }
        DiagnosticPos pos = CommonUtil.toZeroBasedPosition(literalExpr.getPosition());
        Position position = ((TextDocumentPositionParams)this.lsContext.get(DocumentServiceKeys.POSITION_KEY)).getPosition();
        int cLine = position.getLine();
        int cCol = position.getCharacter();
        int sLine = pos.sLine;
        int eLine = pos.eLine;
        int sCol = pos.sCol;
        int eCol = pos.eCol;
        if (sLine < cLine && eLine > cLine || sLine == cLine && eLine == cLine && cCol >= sCol && cCol <= eCol) {
            throw new CompletionContextNotSupportedException("Completion within Literals are not Supported");
        }
    }

    @Override
    public void visit(BLangCompoundAssignment compoundAssignNode) {
        CursorPositionResolver cpr = CursorPositionResolvers.getResolverByClass(this.cursorPositionResolver);
        if (cpr.isCursorBeforeNode(compoundAssignNode.getPosition(), this, this.lsContext, (BLangNode)compoundAssignNode, null)) {
            return;
        }
        this.acceptNode((BLangNode)compoundAssignNode.expr, this.symbolEnv);
    }

    @Override
    public void visit(BLangErrorVariableDef bLangErrorVariableDef) {
        CursorPositionResolver cpr = CursorPositionResolvers.getResolverByClass(this.cursorPositionResolver);
        cpr.isCursorBeforeNode(bLangErrorVariableDef.getPosition(), this, this.lsContext, (BLangNode)bLangErrorVariableDef, null);
    }

    @Override
    public void visit(BLangQueryAction queryAction) {
        this.acceptNode((BLangNode)queryAction.doClause, this.symbolEnv);
    }

    @Override
    public void visit(BLangDoClause doClause) {
        this.acceptNode((BLangNode)doClause.body, this.symbolEnv);
    }

    public Map<Name, List<Scope.ScopeEntry>> resolveAllVisibleSymbols(SymbolEnv symbolEnv) {
        return this.symbolResolver.getAllVisibleInScopeSymbols(symbolEnv);
    }

    public void populateSymbols(Map<Name, List<Scope.ScopeEntry>> symbolEntries, @Nonnull SymbolEnv symbolEnv) {
        ArrayList visibleSymbols = new ArrayList();
        this.populateSymbolEnvNode(symbolEnv.node);
        symbolEntries.values().forEach(visibleSymbols::addAll);
        this.lsContext.put(CommonKeys.VISIBLE_SYMBOLS_KEY, visibleSymbols);
    }

    public Deque<Node> getBlockOwnerStack() {
        return this.blockOwnerStack;
    }

    public Deque<BlockNode> getBlockStmtStack() {
        return this.blockStmtStack;
    }

    public Deque<BLangForkJoin> getForkJoinStack() {
        return this.forkJoinStack;
    }

    public SymbolEnv getSymbolEnv() {
        return this.symbolEnv;
    }

    public void setNextNode(BSymbol symbol, BLangNode node) {
        if (symbol instanceof BServiceSymbol) {
            this.lsContext.put(CompletionKeys.NEXT_NODE_KEY, (Object)AnnotationNodeKind.SERVICE);
        } else if (symbol instanceof BInvokableSymbol && (symbol.flags & 0x40000) == 262144) {
            this.lsContext.put(CompletionKeys.NEXT_NODE_KEY, (Object)AnnotationNodeKind.RESOURCE);
        } else if (symbol instanceof BInvokableSymbol) {
            if (node instanceof BLangSimpleVariableDef && ((BLangSimpleVariableDef)node).var.expr instanceof BLangLambdaFunction && ((BLangLambdaFunction)((BLangSimpleVariableDef)node).var.expr).function.flagSet.contains(Flag.WORKER)) {
                this.lsContext.put(CompletionKeys.NEXT_NODE_KEY, (Object)AnnotationNodeKind.WORKER);
            } else {
                this.lsContext.put(CompletionKeys.NEXT_NODE_KEY, (Object)AnnotationNodeKind.FUNCTION);
            }
        } else if (symbol instanceof BVarSymbol && (symbol.flags & 0x100000) == 0x100000) {
            this.lsContext.put(CompletionKeys.NEXT_NODE_KEY, (Object)AnnotationNodeKind.LISTENER);
        } else if (symbol instanceof BRecordTypeSymbol) {
            this.lsContext.put(CompletionKeys.NEXT_NODE_KEY, (Object)AnnotationNodeKind.RECORD);
        } else if (symbol instanceof BObjectTypeSymbol) {
            this.lsContext.put(CompletionKeys.NEXT_NODE_KEY, (Object)AnnotationNodeKind.OBJECT);
        } else if (symbol instanceof BTypeSymbol) {
            this.lsContext.put(CompletionKeys.NEXT_NODE_KEY, (Object)AnnotationNodeKind.TYPE);
        } else if (symbol instanceof AnnotationSymbol) {
            this.lsContext.put(CompletionKeys.NEXT_NODE_KEY, (Object)AnnotationNodeKind.ANNOTATION);
        } else if (symbol instanceof BConstantSymbol) {
            this.lsContext.put(CompletionKeys.NEXT_NODE_KEY, (Object)AnnotationNodeKind.CONSTANT);
        }
    }

    public void forceTerminateVisitor() {
        this.lsContext.put(CompletionKeys.CURRENT_NODE_TRANSACTION_KEY, (Object)(!this.isCurrentNodeTransactionStack.isEmpty() ? 1 : 0));
        this.lsContext.put(CompletionKeys.LOOP_COUNT_KEY, (Object)this.loopCount);
        this.lsContext.put(CompletionKeys.TRANSACTION_COUNT_KEY, (Object)this.transactionCount);
        this.lsContext.put(CompletionKeys.PREVIOUS_NODE_KEY, (Object)this.previousNode);
        if (!this.blockOwnerStack.isEmpty()) {
            this.lsContext.put(CompletionKeys.BLOCK_OWNER_KEY, (Object)this.blockOwnerStack.peek());
        }
        this.terminateVisitor = true;
    }

    private void acceptNode(Node node, SymbolEnv env) {
        this.acceptNode((BLangNode)node, env);
    }

    private void acceptNode(BLangNode node, SymbolEnv env) {
        if (this.terminateVisitor || node == null) {
            return;
        }
        SymbolEnv prevEnv = this.symbolEnv;
        this.symbolEnv = env;
        node.accept((BLangNodeVisitor)this);
        this.symbolEnv = prevEnv;
    }

    private void populateSymbolEnvNode(BLangNode node) {
        this.lsContext.put(CompletionKeys.SCOPE_NODE_KEY, (Object)node);
    }

    private void visitMatchPatternClause(BLangNode patternNode, BLangBlockStmt body) {
        if (!CursorPositionResolvers.getResolverByClass(this.cursorPositionResolver).isCursorBeforeNode(patternNode.getPosition(), this, this.lsContext, patternNode, null)) {
            this.blockOwnerStack.push((Node)patternNode);
            SymbolEnv blockEnv = SymbolEnv.createBlockEnv((BLangBlockStmt)body, (SymbolEnv)this.symbolEnv);
            this.cursorPositionResolver = BlockStatementScopeResolver.class;
            this.acceptNode((BLangNode)body, blockEnv);
            this.blockOwnerStack.pop();
        }
    }
}

