/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.builder;

import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.commons.LSContext;
import org.ballerinalang.model.elements.MarkdownDocAttachment;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionItemKind;
import org.eclipse.lsp4j.MarkupContent;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BConstantSymbol;

public class BConstantCompletionItemBuilder {
    private BConstantCompletionItemBuilder() {
    }

    public static CompletionItem build(BConstantSymbol constantSymbol, LSContext context) {
        CompletionItem completionItem = new CompletionItem();
        completionItem.setLabel(constantSymbol.getName().getValue());
        completionItem.setInsertText(constantSymbol.getName().getValue());
        completionItem.setDetail(CommonUtil.getBTypeName(constantSymbol.literalType, context, false));
        completionItem.setDocumentation(BConstantCompletionItemBuilder.getDocumentation(constantSymbol));
        completionItem.setKind(CompletionItemKind.Variable);
        return completionItem;
    }

    private static MarkupContent getDocumentation(BConstantSymbol constantSymbol) {
        MarkupContent docMarkupContent = new MarkupContent();
        MarkdownDocAttachment markdownDocAttachment = constantSymbol.getMarkdownDocAttachment();
        String description = markdownDocAttachment.description == null ? "" : markdownDocAttachment.description;
        docMarkupContent.setValue(description);
        docMarkupContent.setKind("markdown");
        return docMarkupContent;
    }
}

