/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.providers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.antlr.v4.runtime.CommonToken;
import org.apache.commons.lang3.tuple.Pair;
import org.ballerinalang.compiler.CompilerPhase;
import org.ballerinalang.langserver.SnippetBlock;
import org.ballerinalang.langserver.common.CommonKeys;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.common.utils.FilterUtils;
import org.ballerinalang.langserver.commons.LSContext;
import org.ballerinalang.langserver.commons.completion.CompletionKeys;
import org.ballerinalang.langserver.commons.completion.LSCompletionException;
import org.ballerinalang.langserver.commons.completion.LSCompletionItem;
import org.ballerinalang.langserver.commons.completion.spi.LSCompletionProvider;
import org.ballerinalang.langserver.compiler.DocumentServiceKeys;
import org.ballerinalang.langserver.compiler.ExtendedLSCompiler;
import org.ballerinalang.langserver.compiler.LSPackageLoader;
import org.ballerinalang.langserver.compiler.exception.CompilationFailedException;
import org.ballerinalang.langserver.completions.LSCompletionProviderHolder;
import org.ballerinalang.langserver.completions.SnippetCompletionItem;
import org.ballerinalang.langserver.completions.StaticCompletionItem;
import org.ballerinalang.langserver.completions.SymbolCompletionItem;
import org.ballerinalang.langserver.completions.builder.BConstantCompletionItemBuilder;
import org.ballerinalang.langserver.completions.builder.BFunctionCompletionItemBuilder;
import org.ballerinalang.langserver.completions.builder.BTypeCompletionItemBuilder;
import org.ballerinalang.langserver.completions.builder.BVariableCompletionItemBuilder;
import org.ballerinalang.langserver.completions.util.Snippet;
import org.ballerinalang.langserver.completions.util.filters.DelimiterBasedContentFilter;
import org.ballerinalang.langserver.completions.util.filters.SymbolFilters;
import org.ballerinalang.langserver.sourceprune.SourcePruneKeys;
import org.ballerinalang.model.types.TypeKind;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionItemKind;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.wso2.ballerinalang.compiler.semantics.model.Scope;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BAttachedFunction;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BConstantSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BConstructorSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BInvokableSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BObjectTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BPackageSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BRecordTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BVarSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.types.BErrorType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BNilType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BServiceType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.tree.BLangBlockFunctionBody;
import org.wso2.ballerinalang.compiler.tree.BLangFunction;
import org.wso2.ballerinalang.compiler.tree.BLangIdentifier;
import org.wso2.ballerinalang.compiler.tree.BLangImportPackage;
import org.wso2.ballerinalang.compiler.tree.BLangNode;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;
import org.wso2.ballerinalang.compiler.tree.BLangService;
import org.wso2.ballerinalang.compiler.tree.BLangSimpleVariable;
import org.wso2.ballerinalang.compiler.tree.BLangVariable;
import org.wso2.ballerinalang.compiler.tree.statements.BLangSimpleVariableDef;
import org.wso2.ballerinalang.compiler.tree.types.BLangBuiltInRefTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangConstrainedType;
import org.wso2.ballerinalang.compiler.tree.types.BLangFunctionTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangType;
import org.wso2.ballerinalang.compiler.tree.types.BLangUserDefinedType;
import org.wso2.ballerinalang.compiler.util.Names;

public abstract class AbstractCompletionProvider
implements LSCompletionProvider {
    protected List<Class> attachmentPoints = new ArrayList<Class>();
    protected LSCompletionProvider.Precedence precedence = LSCompletionProvider.Precedence.LOW;

    public abstract List<LSCompletionItem> getCompletions(LSContext var1) throws LSCompletionException;

    public List<Class> getAttachmentPoints() {
        return this.attachmentPoints;
    }

    public LSCompletionProvider.Precedence getPrecedence() {
        return this.precedence;
    }

    public Optional<LSCompletionProvider> getContextProvider(LSContext ctx) {
        return Optional.empty();
    }

    protected List<LSCompletionItem> getCompletionItemList(List<Scope.ScopeEntry> scopeEntries, LSContext context) {
        ArrayList processedSymbols = new ArrayList();
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        scopeEntries.removeIf(CommonUtil.invalidSymbolsPredicate());
        scopeEntries.forEach(scopeEntry -> {
            BSymbol symbol = scopeEntry.symbol;
            if (processedSymbols.contains(symbol)) {
                return;
            }
            if (CommonUtil.isValidInvokableSymbol(symbol)) {
                completionItems.add(this.populateBallerinaFunctionCompletionItem((Scope.ScopeEntry)scopeEntry, context));
            } else if (symbol instanceof BConstantSymbol) {
                CompletionItem constantCItem = BConstantCompletionItemBuilder.build((BConstantSymbol)symbol, context);
                completionItems.add(new SymbolCompletionItem(context, symbol, constantCItem));
            } else if (!(symbol instanceof BInvokableSymbol) && symbol instanceof BVarSymbol) {
                String typeName = CommonUtil.getBTypeName(symbol.type, context, false);
                CompletionItem variableCItem = BVariableCompletionItemBuilder.build((BVarSymbol)symbol, scopeEntry.symbol.name.value, typeName);
                completionItems.add(new SymbolCompletionItem(context, symbol, variableCItem));
            } else {
                Optional<BSymbol> bTypeSymbol = FilterUtils.getBTypeEntry(scopeEntry);
                if (bTypeSymbol.isPresent()) {
                    CompletionItem typeCItem = BTypeCompletionItemBuilder.build(bTypeSymbol.get(), scopeEntry.symbol.name.value);
                    completionItems.add(new SymbolCompletionItem(context, bTypeSymbol.get(), typeCItem));
                }
            }
            processedSymbols.add(symbol);
        });
        return completionItems;
    }

    protected List<LSCompletionItem> getCompletionItemList(Either<List<LSCompletionItem>, List<Scope.ScopeEntry>> list, LSContext context) {
        return list.isLeft() ? (List<LSCompletionItem>)list.getLeft() : this.getCompletionItemList((List)list.getRight(), context);
    }

    protected List<LSCompletionItem> getBasicTypesItems(LSContext context, List<Scope.ScopeEntry> visibleSymbols) {
        visibleSymbols.removeIf(CommonUtil.invalidSymbolsPredicate());
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        visibleSymbols.forEach(scopeEntry -> {
            BSymbol bSymbol = scopeEntry.symbol;
            if (bSymbol instanceof BConstructorSymbol && Names.ERROR.equals((Object)bSymbol.name) || bSymbol instanceof BTypeSymbol && !(bSymbol instanceof BPackageSymbol)) {
                BSymbol symbol = bSymbol;
                if (bSymbol instanceof BConstructorSymbol) {
                    symbol = ((BConstructorSymbol)bSymbol).type.tsymbol;
                }
                CompletionItem cItem = BTypeCompletionItemBuilder.build(symbol, scopeEntry.symbol.name.getValue());
                completionItems.add(new SymbolCompletionItem(context, symbol, cItem));
            }
        });
        return completionItems;
    }

    protected List<LSCompletionItem> getTypeItemsInPackage(List<Scope.ScopeEntry> visibleSymbols, String pkgName, LSContext ctx) {
        ArrayList<Scope.ScopeEntry> filteredList = new ArrayList<Scope.ScopeEntry>();
        Optional<Scope.ScopeEntry> pkgSymbolInfo = visibleSymbols.stream().filter(scopeEntry -> {
            BSymbol symbol = scopeEntry.symbol;
            return symbol instanceof BPackageSymbol && CommonUtil.getSymbolName(scopeEntry.symbol).equals(pkgName);
        }).findAny();
        pkgSymbolInfo.ifPresent(pkgEntry -> {
            BSymbol pkgSymbol = pkgEntry.symbol;
            pkgSymbol.scope.entries.forEach((name, scopeEntry) -> {
                if (scopeEntry.symbol instanceof BTypeSymbol || scopeEntry.symbol instanceof BConstructorSymbol && Names.ERROR.equals((Object)scopeEntry.symbol.name)) {
                    filteredList.add((Scope.ScopeEntry)scopeEntry);
                }
            });
        });
        return this.getCompletionItemList(filteredList, ctx);
    }

    protected List<LSCompletionItem> addTopLevelItems(LSContext context) {
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        completionItems.add(new SnippetCompletionItem(context, Snippet.KW_IMPORT.get()));
        completionItems.add(new SnippetCompletionItem(context, Snippet.KW_FUNCTION.get()));
        completionItems.add(new SnippetCompletionItem(context, Snippet.DEF_FUNCTION.get()));
        completionItems.add(new SnippetCompletionItem(context, Snippet.DEF_MAIN_FUNCTION.get()));
        completionItems.add(new SnippetCompletionItem(context, Snippet.DEF_SERVICE.get()));
        completionItems.add(new SnippetCompletionItem(context, Snippet.DEF_SERVICE_WEBSOCKET.get()));
        completionItems.add(new SnippetCompletionItem(context, Snippet.DEF_SERVICE_WS_CLIENT.get()));
        completionItems.add(new SnippetCompletionItem(context, Snippet.DEF_SERVICE_GRPC.get()));
        completionItems.add(new SnippetCompletionItem(context, Snippet.DEF_ANNOTATION.get()));
        completionItems.add(new SnippetCompletionItem(context, Snippet.STMT_NAMESPACE_DECLARATION.get()));
        completionItems.add(new SnippetCompletionItem(context, Snippet.DEF_OBJECT_SNIPPET.get()));
        completionItems.add(new SnippetCompletionItem(context, Snippet.DEF_RECORD.get()));
        completionItems.add(new SnippetCompletionItem(context, Snippet.DEF_CLOSED_RECORD.get()));
        completionItems.add(new SnippetCompletionItem(context, Snippet.KW_TYPE.get()));
        completionItems.add(new SnippetCompletionItem(context, Snippet.KW_PUBLIC.get()));
        completionItems.add(new SnippetCompletionItem(context, Snippet.KW_FINAL.get()));
        completionItems.add(new SnippetCompletionItem(context, Snippet.KW_CONST.get()));
        completionItems.add(new SnippetCompletionItem(context, Snippet.DEF_ERROR.get()));
        completionItems.add(new SnippetCompletionItem(context, Snippet.KW_LISTENER.get()));
        completionItems.add(new SnippetCompletionItem(context, Snippet.KW_VAR.get()));
        return completionItems;
    }

    protected List<LSCompletionItem> getPackagesCompletionItems(LSContext ctx) {
        ArrayList populatedList = new ArrayList();
        BLangPackage currentPkg = (BLangPackage)ctx.get(DocumentServiceKeys.CURRENT_BLANG_PACKAGE_CONTEXT_KEY);
        List currentModuleImports = (List)ctx.get(DocumentServiceKeys.CURRENT_DOC_IMPORTS_KEY);
        List<LSCompletionItem> completionItems = currentModuleImports.stream().map(pkg -> {
            String orgName = pkg.orgName.value;
            String pkgName = pkg.pkgNameComps.stream().map(id -> id.value).collect(Collectors.joining("."));
            String label = pkg.alias.value;
            String insertText = pkg.alias.value;
            if ("ballerina".equals(orgName) && ((BLangIdentifier)pkg.pkgNameComps.get(0)).getValue().equals("lang") && pkgName.endsWith("." + pkg.alias.value) && this.appendSingleQuoteForPackageInsertText(ctx)) {
                insertText = "'" + insertText;
            }
            CompletionItem item = new CompletionItem();
            item.setLabel(label);
            item.setInsertText(insertText);
            item.setDetail("Module");
            item.setKind(CompletionItemKind.Module);
            populatedList.add(orgName + "/" + pkgName);
            return new SymbolCompletionItem(ctx, (BSymbol)pkg.symbol, item);
        }).collect(Collectors.toList());
        List packages = LSPackageLoader.getSdkPackages();
        packages.addAll(LSPackageLoader.getHomeRepoPackages());
        packages.addAll(LSPackageLoader.getCurrentProjectModules((BLangPackage)currentPkg, (LSContext)ctx));
        packages.forEach(pkg -> {
            String name = pkg.getPackageName();
            String orgName = pkg.getOrgName();
            boolean pkgAlreadyImported = currentModuleImports.stream().anyMatch(importPkg -> importPkg.orgName.value.equals(orgName) && importPkg.alias.value.equals(name));
            if (!(pkgAlreadyImported || populatedList.contains(orgName + "/" + name) || "ballerina".equals(orgName) && name.startsWith("lang.annotations"))) {
                CompletionItem item = new CompletionItem();
                item.setLabel(pkg.getFullPackageNameAlias());
                String[] pkgNameComps = name.split("\\.");
                String insertText = pkgNameComps[pkgNameComps.length - 1];
                if ("ballerina".equals(orgName) && name.startsWith("lang.")) {
                    String[] pkgNameComponents = name.split("\\.");
                    insertText = "'" + pkgNameComponents[pkgNameComponents.length - 1];
                }
                item.setInsertText(insertText);
                item.setDetail("Module");
                item.setKind(CompletionItemKind.Module);
                item.setAdditionalTextEdits(CommonUtil.getAutoImportTextEdits(orgName, name, ctx));
                completionItems.add(new StaticCompletionItem(ctx, item));
            }
        });
        return completionItems;
    }

    protected List<LSCompletionItem> getDelimiterBasedCompletionItems(LSContext context) {
        Either<List<LSCompletionItem>, List<Scope.ScopeEntry>> itemList = SymbolFilters.get(DelimiterBasedContentFilter.class).filterItems(context);
        return this.getCompletionItemList(itemList, context);
    }

    protected Predicate<Scope.ScopeEntry> attachedSymbolFilter() {
        return scopeEntry -> {
            BSymbol bSymbol = scopeEntry.symbol;
            return bSymbol instanceof BInvokableSymbol && (bSymbol.flags & 8) == 8;
        };
    }

    protected Optional<String> getSubRule(List<CommonToken> tokenList) {
        if (tokenList == null || tokenList.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(tokenList.stream().map(CommonToken::getText).collect(Collectors.joining("")));
    }

    protected LSCompletionProvider getProvider(Class providerKey) {
        return LSCompletionProviderHolder.getInstance().getProvider(providerKey);
    }

    protected List<LSCompletionItem> getCompletionItemsAfterOnKeyword(LSContext ctx) {
        ArrayList<Scope.ScopeEntry> visibleSymbols = new ArrayList<Scope.ScopeEntry>((Collection)ctx.get(CommonKeys.VISIBLE_SYMBOLS_KEY));
        List<Scope.ScopeEntry> filtered = this.filterListenerVariables(visibleSymbols);
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>(this.getCompletionItemList(new ArrayList<Scope.ScopeEntry>(filtered), ctx));
        completionItems.add(new SnippetCompletionItem(ctx, Snippet.KW_NEW.get()));
        return completionItems;
    }

    protected List<LSCompletionItem> getVarDefExpressionCompletions(LSContext context, boolean onGlobal) {
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        Integer invocationType = (Integer)context.get(CompletionKeys.INVOCATION_TOKEN_TYPE_KEY);
        try {
            boolean isTypeDesc;
            Optional<BLangType> assignmentType = AbstractCompletionProvider.getAssignmentType(context, onGlobal);
            if (assignmentType.isPresent() && !(assignmentType.get() instanceof BLangUserDefinedType) && invocationType > -1) {
                Either<List<LSCompletionItem>, List<Scope.ScopeEntry>> filteredList = SymbolFilters.get(DelimiterBasedContentFilter.class).filterItems(context);
                completionItems.addAll(this.getCompletionItemList(filteredList, context));
                return completionItems;
            }
            boolean bl = isTypeDesc = assignmentType.isPresent() && assignmentType.get() instanceof BLangConstrainedType && ((BLangConstrainedType)assignmentType.get()).type instanceof BLangBuiltInRefTypeNode && ((BLangBuiltInRefTypeNode)((BLangConstrainedType)assignmentType.get()).type).typeKind == TypeKind.TYPEDESC;
            if (assignmentType.isPresent() && assignmentType.get() instanceof BLangFunctionTypeNode) {
                completionItems.addAll(this.getVarDefCompletions(context));
                this.fillFunctionWithBodySnippet((BLangFunctionTypeNode)assignmentType.get(), context, completionItems);
                this.fillArrowFunctionSnippet((BLangFunctionTypeNode)assignmentType.get(), context, completionItems);
            } else if (assignmentType.isPresent() && assignmentType.get().type instanceof BServiceType) {
                completionItems.addAll(this.getVarDefCompletions(context));
                completionItems.add(new SnippetCompletionItem(context, Snippet.DEF_SERVICE_VAR.get()));
            } else if (assignmentType.isPresent() && assignmentType.get() instanceof BLangUserDefinedType) {
                completionItems.addAll(this.getUserDefinedTypeCompletions(context, (BLangUserDefinedType)assignmentType.get()));
            } else if (isTypeDesc) {
                completionItems.add(new SnippetCompletionItem(context, Snippet.KW_TYPEOF.get()));
                completionItems.addAll(this.getVarDefCompletions(context));
            } else {
                if (invocationType > -1) {
                    Either<List<LSCompletionItem>, List<Scope.ScopeEntry>> filteredList = SymbolFilters.get(DelimiterBasedContentFilter.class).filterItems(context);
                    return this.getCompletionItemList(filteredList, context);
                }
                completionItems.addAll(this.getVarDefCompletions(context, !assignmentType.isPresent()));
            }
        }
        catch (LSCompletionException lSCompletionException) {
            // empty catch block
        }
        return completionItems;
    }

    protected List<LSCompletionItem> getUserDefinedTypeCompletions(LSContext context, BLangUserDefinedType type) {
        BInvokableSymbol initFuncSymbol;
        Either<List<LSCompletionItem>, List<Scope.ScopeEntry>> filteredList;
        BSymbol bSymbol;
        List defaultTokenTypes = (List)context.get(SourcePruneKeys.LHS_DEFAULT_TOKEN_TYPES_KEY);
        Integer invocationType = (Integer)context.get(CompletionKeys.INVOCATION_TOKEN_TYPE_KEY);
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        int newTokenIndex = defaultTokenTypes.indexOf(48);
        int lastColonIndex = defaultTokenTypes.lastIndexOf(96);
        int firstColonIndex = defaultTokenTypes.indexOf(96);
        String typeName = type.typeName.value;
        String pkgAlias = type.pkgAlias.value;
        Optional<Scope.ScopeEntry> pkgSymbol = this.getPackageSymbolFromAlias(context, pkgAlias);
        if (pkgSymbol.isPresent()) {
            Optional<Scope.ScopeEntry> entry = pkgSymbol.get().symbol.scope.entries.values().stream().filter(scopeEntry -> scopeEntry.symbol.getName().getValue().equals(typeName)).findAny();
            if (!entry.isPresent()) {
                return completionItems;
            }
            bSymbol = entry.get().symbol;
        } else {
            List<Scope.ScopeEntry> typeSymbol = this.getSymbolByName(typeName, context);
            if (typeSymbol.isEmpty()) {
                return completionItems;
            }
            bSymbol = typeSymbol.get((int)0).symbol;
        }
        if (bSymbol == null) {
            return completionItems;
        }
        if (bSymbol instanceof BRecordTypeSymbol) {
            if (invocationType > -1) {
                filteredList = SymbolFilters.get(DelimiterBasedContentFilter.class).filterItems(context);
                return this.getCompletionItemList(filteredList, context);
            }
            return this.getVarDefCompletions(context);
        }
        if (!(bSymbol instanceof BObjectTypeSymbol)) {
            if (invocationType > -1) {
                filteredList = SymbolFilters.get(DelimiterBasedContentFilter.class).filterItems(context);
                return this.getCompletionItemList(filteredList, context);
            }
            return this.getVarDefCompletions(context);
        }
        BObjectTypeSymbol objectTypeSymbol = (BObjectTypeSymbol)bSymbol;
        BAttachedFunction initFunction = objectTypeSymbol.initializerFunc;
        BInvokableSymbol bInvokableSymbol = initFuncSymbol = initFunction == null ? null : initFunction.symbol;
        if (newTokenIndex > -1 && firstColonIndex > -1 && lastColonIndex == firstColonIndex) {
            return this.getPackagesCompletionItems(context);
        }
        if (newTokenIndex > -1) {
            Pair<String, String> newWithTypeSign = CommonUtil.getFunctionInvocationSignature(initFuncSymbol, typeName, context);
            CompletionItem cItem = BFunctionCompletionItemBuilder.build(initFuncSymbol, (String)newWithTypeSign.getRight(), (String)newWithTypeSign.getLeft(), context);
            completionItems.add(new SymbolCompletionItem(context, (BSymbol)initFuncSymbol, cItem));
            return completionItems;
        }
        if (invocationType > -1) {
            Either<List<LSCompletionItem>, List<Scope.ScopeEntry>> filteredList2 = SymbolFilters.get(DelimiterBasedContentFilter.class).filterItems(context);
            return this.getCompletionItemList(filteredList2, context);
        }
        if (initFunction == null) {
            CompletionItem newCItem = BFunctionCompletionItemBuilder.build(null, "new()", "new();", context);
            CompletionItem typeCItem = BFunctionCompletionItemBuilder.build(null, typeName + "()", typeName + "();", context);
            completionItems.add(new SymbolCompletionItem(context, null, newCItem));
            completionItems.add(new SymbolCompletionItem(context, null, typeCItem));
        } else {
            Pair<String, String> newSign = CommonUtil.getFunctionInvocationSignature(initFunction.symbol, "new", context);
            Pair<String, String> newWithTypeSign = CommonUtil.getFunctionInvocationSignature(initFunction.symbol, typeName, context);
            CompletionItem newCItem = BFunctionCompletionItemBuilder.build(initFunction.symbol, (String)newSign.getRight(), (String)newSign.getLeft(), context);
            CompletionItem typeCItem = BFunctionCompletionItemBuilder.build(initFunction.symbol, (String)newWithTypeSign.getRight(), (String)newWithTypeSign.getLeft(), context);
            completionItems.add(new SymbolCompletionItem(context, (BSymbol)initFunction.symbol, newCItem));
            completionItems.add(new SymbolCompletionItem(context, (BSymbol)initFunction.symbol, typeCItem));
        }
        completionItems.addAll(this.getVarDefCompletions(context));
        completionItems.add(new SnippetCompletionItem(context, Snippet.KW_NEW.get()));
        return completionItems;
    }

    protected List<LSCompletionItem> getResourceSnippets(LSContext ctx) {
        BLangNode symbolEnvNode = (BLangNode)ctx.get(CompletionKeys.SCOPE_NODE_KEY);
        ArrayList<LSCompletionItem> items = new ArrayList<LSCompletionItem>();
        if (!(symbolEnvNode instanceof BLangService)) {
            return items;
        }
        BLangService service = (BLangService)symbolEnvNode;
        if (service.listenerType == null) {
            Optional<Boolean> webSocketClientService = this.isWebSocketClientService(service);
            if (webSocketClientService.isPresent()) {
                if (webSocketClientService.get().booleanValue()) {
                    this.addAllWSClientResources(ctx, items, service);
                } else {
                    this.addAllWSResources(ctx, items, service);
                }
            } else {
                items.add(new SnippetCompletionItem(ctx, Snippet.DEF_RESOURCE_HTTP.get()));
                items.add(new SnippetCompletionItem(ctx, Snippet.DEF_RESOURCE_COMMON.get()));
                this.addAllWSClientResources(ctx, items, service);
                this.addAllWSResources(ctx, items, service);
            }
            return items;
        }
        String owner = service.listenerType.tsymbol.owner.name.value;
        String serviceTypeName = service.listenerType.tsymbol.name.value;
        switch (owner) {
            case "http": {
                if ("Listener".equals(serviceTypeName)) {
                    Optional<Boolean> webSocketService = this.isWebSocketService(service);
                    if (webSocketService.isPresent()) {
                        if (webSocketService.get().booleanValue()) {
                            this.addAllWSResources(ctx, items, service);
                            break;
                        }
                        items.add(new SnippetCompletionItem(ctx, Snippet.DEF_RESOURCE_HTTP.get()));
                        break;
                    }
                    this.addAllWSResources(ctx, items, service);
                    items.add(new SnippetCompletionItem(ctx, Snippet.DEF_RESOURCE_HTTP.get()));
                    break;
                }
                return items;
            }
            case "grpc": {
                items.add(new SnippetCompletionItem(ctx, Snippet.DEF_RESOURCE_GRPC.get()));
                break;
            }
            default: {
                items.add(new SnippetCompletionItem(ctx, Snippet.DEF_RESOURCE_COMMON.get()));
                return items;
            }
        }
        return items;
    }

    private void addAllWSClientResources(LSContext ctx, List<LSCompletionItem> items, BLangService service) {
        this.addIfNotExists(Snippet.DEF_RESOURCE_WS_CS_TEXT.get(), service, items, ctx);
        this.addIfNotExists(Snippet.DEF_RESOURCE_WS_CS_BINARY.get(), service, items, ctx);
        this.addIfNotExists(Snippet.DEF_RESOURCE_WS_CS_PING.get(), service, items, ctx);
        this.addIfNotExists(Snippet.DEF_RESOURCE_WS_CS_PONG.get(), service, items, ctx);
        this.addIfNotExists(Snippet.DEF_RESOURCE_WS_CS_IDLE.get(), service, items, ctx);
        this.addIfNotExists(Snippet.DEF_RESOURCE_WS_CS_ERROR.get(), service, items, ctx);
        this.addIfNotExists(Snippet.DEF_RESOURCE_WS_CS_CLOSE.get(), service, items, ctx);
    }

    private void addAllWSResources(LSContext ctx, List<LSCompletionItem> items, BLangService service) {
        this.addIfNotExists(Snippet.DEF_RESOURCE_WS_OPEN.get(), service, items, ctx);
        this.addIfNotExists(Snippet.DEF_RESOURCE_WS_TEXT.get(), service, items, ctx);
        this.addIfNotExists(Snippet.DEF_RESOURCE_WS_BINARY.get(), service, items, ctx);
        this.addIfNotExists(Snippet.DEF_RESOURCE_WS_PING.get(), service, items, ctx);
        this.addIfNotExists(Snippet.DEF_RESOURCE_WS_PONG.get(), service, items, ctx);
        this.addIfNotExists(Snippet.DEF_RESOURCE_WS_IDLE.get(), service, items, ctx);
        this.addIfNotExists(Snippet.DEF_RESOURCE_WS_ERROR.get(), service, items, ctx);
        this.addIfNotExists(Snippet.DEF_RESOURCE_WS_CLOSE.get(), service, items, ctx);
    }

    protected Optional<Scope.ScopeEntry> getPackageSymbolFromAlias(LSContext context, String alias) {
        ArrayList visibleSymbols = new ArrayList((Collection)context.get(CommonKeys.VISIBLE_SYMBOLS_KEY));
        Optional<BLangImportPackage> pkgForAlias = ((List)context.get(DocumentServiceKeys.CURRENT_DOC_IMPORTS_KEY)).stream().filter(pkg -> pkg.alias.value.equals(alias)).findAny();
        if (alias.isEmpty() || !pkgForAlias.isPresent()) {
            return Optional.empty();
        }
        return visibleSymbols.stream().filter(scopeEntry -> {
            BSymbol symbol = scopeEntry.symbol;
            return symbol == ((BLangImportPackage)pkgForAlias.get()).symbol;
        }).findAny();
    }

    protected List<Scope.ScopeEntry> getSymbolByName(String name, LSContext context) {
        ArrayList visibleSymbols = new ArrayList((Collection)context.get(CommonKeys.VISIBLE_SYMBOLS_KEY));
        return visibleSymbols.parallelStream().filter(scopeEntry -> scopeEntry.symbol.getName().getValue().equals(name)).collect(Collectors.toList());
    }

    protected boolean inFunctionReturnParameterContext(LSContext context) {
        if (context.get(SourcePruneKeys.LHS_DEFAULT_TOKEN_TYPES_KEY) == null) {
            return false;
        }
        ArrayList defaultTokens = new ArrayList((Collection)context.get(SourcePruneKeys.LHS_DEFAULT_TOKEN_TYPES_KEY));
        if (defaultTokens.isEmpty()) {
            return false;
        }
        int tokenSize = defaultTokens.size();
        int assignTokenIndex = defaultTokens.indexOf(109);
        int eqlOrGTTokenIndex = defaultTokens.indexOf(136);
        if (assignTokenIndex > 0 && assignTokenIndex >= tokenSize - 3 && assignTokenIndex < tokenSize || eqlOrGTTokenIndex > 0) {
            return false;
        }
        if (defaultTokens.contains(19) && defaultTokens.size() - 1 - defaultTokens.indexOf(19) <= 3) {
            return true;
        }
        return tokenSize > 2 && defaultTokens.contains(9) && ((Integer)defaultTokens.get(tokenSize - 1) == 102 || (Integer)defaultTokens.get(tokenSize - 2) == 102);
    }

    protected boolean isAnnotationAccessExpression(LSContext context) {
        List defaultTokenTypes = (List)context.get(SourcePruneKeys.LHS_DEFAULT_TOKEN_TYPES_KEY);
        int annotationAccessIndex = defaultTokenTypes.indexOf(150);
        return annotationAccessIndex > -1;
    }

    private LSCompletionItem populateBallerinaFunctionCompletionItem(Scope.ScopeEntry scopeEntry, LSContext context) {
        BSymbol bSymbol = scopeEntry.symbol;
        if (!(bSymbol instanceof BInvokableSymbol)) {
            return null;
        }
        CompletionItem completionItem = BFunctionCompletionItemBuilder.build((BInvokableSymbol)bSymbol, context);
        return new SymbolCompletionItem(context, bSymbol, completionItem);
    }

    private List<Scope.ScopeEntry> filterListenerVariables(List<Scope.ScopeEntry> scopeEntries) {
        return scopeEntries.stream().filter(scopeEntry -> {
            BSymbol symbol = scopeEntry.symbol;
            return symbol instanceof BVarSymbol && CommonUtil.isListenerObject((BSymbol)symbol.type.tsymbol);
        }).collect(Collectors.toList());
    }

    public static Optional<BLangType> getAssignmentType(LSContext context, boolean onGlobal) throws LSCompletionException {
        Optional bLangPackage;
        List lhsTokens = (List)context.get(SourcePruneKeys.LHS_TOKENS_KEY);
        int counter = 0;
        StringBuilder subRule = new StringBuilder();
        if (!onGlobal) {
            subRule.append("function testFunction () {").append(CommonUtil.LINE_SEPARATOR).append("\t");
        }
        while (counter < lhsTokens.size()) {
            if (((CommonToken)lhsTokens.get(counter)).getType() == 3 || ((CommonToken)lhsTokens.get(counter)).getType() == 4) {
                ++counter;
                continue;
            }
            subRule.append(((CommonToken)lhsTokens.get(counter)).getText());
            if (((CommonToken)lhsTokens.get(counter)).getType() == 109) {
                subRule.append("xxx;");
                break;
            }
            ++counter;
        }
        if (!onGlobal) {
            subRule.append(CommonUtil.LINE_SEPARATOR).append("}");
        }
        try {
            bLangPackage = ExtendedLSCompiler.compileContent((String)subRule.toString(), (CompilerPhase)CompilerPhase.CODE_ANALYZE).getBLangPackage();
        }
        catch (CompilationFailedException e) {
            throw new LSCompletionException("Error while parsing the sub-rule", (Throwable)e);
        }
        if (!bLangPackage.isPresent()) {
            return Optional.empty();
        }
        BLangType typeNode = onGlobal ? ((BLangSimpleVariable)((BLangPackage)bLangPackage.get()).globalVars.get(0)).getTypeNode() : ((BLangSimpleVariableDef)((BLangBlockFunctionBody)((BLangFunction)((BLangPackage)bLangPackage.get()).getFunctions().get((int)0)).body).stmts.get((int)0)).getVariable().typeNode;
        return Optional.ofNullable(typeNode);
    }

    private void fillFunctionWithBodySnippet(BLangFunctionTypeNode functionTypeNode, LSContext context, List<LSCompletionItem> completionItems) throws LSCompletionException {
        List params = functionTypeNode.getParams();
        BLangType returnBLangType = functionTypeNode.getReturnTypeNode();
        String functionSignature = this.getFunctionSignature(params, returnBLangType, context);
        String body = this.getAnonFunctionSnippetBody(returnBLangType, params.size());
        String snippet = functionSignature + body;
        String label = this.convertToLabel(functionSignature);
        SnippetBlock snippetBlock = new SnippetBlock(label, snippet, "Snippet", SnippetBlock.SnippetType.SNIPPET);
        completionItems.add(new SnippetCompletionItem(context, snippetBlock));
    }

    private String getFunctionSignature(List<BLangVariable> paramTypes, BLangType returnType, LSContext context) throws LSCompletionException {
        StringBuilder signature = new StringBuilder("function ");
        signature.append(this.getDynamicParamsSnippet(paramTypes, true, context));
        if (!(returnType.type instanceof BNilType)) {
            signature.append("returns (").append(CommonUtil.getBTypeName(returnType.type, context, false)).append(") ");
        }
        return signature.toString();
    }

    private void fillArrowFunctionSnippet(BLangFunctionTypeNode functionTypeNode, LSContext context, List<LSCompletionItem> completionItems) throws LSCompletionException {
        List params = functionTypeNode.getParams();
        BLangType returnBLangType = functionTypeNode.getReturnTypeNode();
        String paramSignature = this.getDynamicParamsSnippet(params, false, context);
        StringBuilder signature = new StringBuilder(paramSignature);
        signature.append(" => ").append("${");
        if (!(returnBLangType.type instanceof BNilType)) {
            signature.append(params.size() + 1).append(":").append(CommonUtil.getDefaultValueForType(returnBLangType.type));
        } else {
            signature.append(params.size() + 1);
        }
        signature.append("};");
        String label = "arrow function  " + this.convertToLabel(paramSignature);
        SnippetBlock snippetBlock = new SnippetBlock(label, signature.toString(), "Snippet", SnippetBlock.SnippetType.SNIPPET);
        completionItems.add(new SnippetCompletionItem(context, snippetBlock));
    }

    private String getAnonFunctionSnippetBody(BLangType returnType, int numberOfParams) {
        StringBuilder body = new StringBuilder();
        if (!(returnType.type instanceof BNilType)) {
            body.append("{").append(CommonUtil.LINE_SEPARATOR).append("\t").append("return ").append(CommonUtil.getDefaultValueForType(returnType.type)).append(";").append(CommonUtil.LINE_SEPARATOR);
        } else {
            body.append("{").append(CommonUtil.LINE_SEPARATOR).append("\t${").append(numberOfParams + 1).append("}").append(CommonUtil.LINE_SEPARATOR);
        }
        body.append("};");
        return body.toString();
    }

    private String convertToLabel(String signature) {
        return signature.replaceAll("(\\$\\{\\d:)([a-zA-Z\\d]*:*[a-zA-Z\\d]*)(\\})", "$2").replaceAll("(\\$\\{\\d\\})", "");
    }

    private String getDynamicParamsSnippet(List<BLangVariable> paramTypes, boolean withType, LSContext context) throws LSCompletionException {
        String paramName = "param";
        StringBuilder signature = new StringBuilder("(");
        List params = IntStream.range(0, paramTypes.size()).mapToObj(index -> {
            int paramIndex = index + 1;
            String paramPlaceHolder = "${" + paramIndex + ":" + paramName + paramIndex + "}";
            if (withType) {
                BType paramType = ((BLangVariable)paramTypes.get((int)index)).getTypeNode().type;
                paramPlaceHolder = CommonUtil.getBTypeName(paramType, context, true) + " " + paramPlaceHolder;
            }
            return paramPlaceHolder;
        }).collect(Collectors.toList());
        if (params.contains("")) {
            throw new LSCompletionException("Contains invalid parameter type");
        }
        signature.append(String.join((CharSequence)", ", params)).append(") ");
        return signature.toString();
    }

    public List<LSCompletionItem> getVarDefCompletions(LSContext context, boolean includeErrorSnippets) {
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        ArrayList<Scope.ScopeEntry> visibleSymbols = new ArrayList<Scope.ScopeEntry>((Collection)context.get(CommonKeys.VISIBLE_SYMBOLS_KEY));
        visibleSymbols.removeIf(scopeEntry -> {
            BSymbol bSymbol = scopeEntry.symbol;
            return bSymbol instanceof BInvokableSymbol && ((BInvokableSymbol)bSymbol).receiverSymbol != null && CommonUtil.isValidInvokableSymbol(bSymbol) || (!includeErrorSnippets || !(bSymbol.type instanceof BErrorType)) && FilterUtils.isBTypeEntry(scopeEntry) || bSymbol instanceof BInvokableSymbol && (bSymbol.flags & 8) == 8;
        });
        completionItems.addAll(this.getCompletionItemList(visibleSymbols, context));
        completionItems.addAll(this.getPackagesCompletionItems(context));
        completionItems.add(new SnippetCompletionItem(context, Snippet.KW_CHECK.get()));
        completionItems.add(new SnippetCompletionItem(context, Snippet.KW_CHECK_PANIC.get()));
        completionItems.add(new SnippetCompletionItem(context, Snippet.KW_WAIT.get()));
        completionItems.add(new SnippetCompletionItem(context, Snippet.KW_START.get()));
        completionItems.add(new SnippetCompletionItem(context, Snippet.KW_FLUSH.get()));
        completionItems.add(new SnippetCompletionItem(context, Snippet.KW_UNTAINT.get()));
        completionItems.add(new SnippetCompletionItem(context, Snippet.EXPR_MATCH.get()));
        if (includeErrorSnippets) {
            completionItems.add(new SnippetCompletionItem(context, Snippet.EXPR_ERROR.get()));
        }
        completionItems.add(new SnippetCompletionItem(context, Snippet.STMT_TRAP.get()));
        return completionItems;
    }

    public List<LSCompletionItem> getVarDefCompletions(LSContext context) {
        return this.getVarDefCompletions(context, false);
    }

    protected boolean isAnnotationAttachmentContext(LSContext context) {
        List lhsDefaultTokenTypes = (List)context.get(SourcePruneKeys.LHS_DEFAULT_TOKEN_TYPES_KEY);
        int maxTokenVisitCount = 4;
        int visitCount = 0;
        for (int counter = lhsDefaultTokenTypes.size() - 1; counter >= 0 && visitCount < maxTokenVisitCount; --counter, ++visitCount) {
            Integer token = (Integer)lhsDefaultTokenTypes.get(counter);
            if (token != 131) continue;
            return true;
        }
        return false;
    }

    private Optional<Boolean> isWebSocketService(BLangService service) {
        BLangType typeNode;
        List resources = service.getResources();
        if (resources.isEmpty()) {
            return Optional.empty();
        }
        BLangFunction resource = (BLangFunction)resources.get(0);
        if (!resource.requiredParams.isEmpty() && (typeNode = ((BLangSimpleVariable)resource.requiredParams.get((int)0)).typeNode) instanceof BLangUserDefinedType) {
            BLangUserDefinedType node = (BLangUserDefinedType)typeNode;
            if ("WebSocketCaller".equals(node.typeName.value)) {
                return Optional.of(true);
            }
            if ("Caller".equals(node.typeName.value)) {
                return Optional.of(false);
            }
        }
        return Optional.empty();
    }

    private Optional<Boolean> isWebSocketClientService(BLangService service) {
        BLangType typeNode;
        List resources = service.getResources();
        if (resources.isEmpty()) {
            return Optional.empty();
        }
        BLangFunction resource = (BLangFunction)resources.get(0);
        if (!resource.requiredParams.isEmpty() && (typeNode = ((BLangSimpleVariable)resource.requiredParams.get((int)0)).typeNode) instanceof BLangUserDefinedType) {
            BLangUserDefinedType node = (BLangUserDefinedType)typeNode;
            if ("WebSocketClient".equals(node.typeName.value)) {
                return Optional.of(true);
            }
            if ("WebSocketCaller".equals(node.typeName.value)) {
                return Optional.of(false);
            }
        }
        return Optional.empty();
    }

    private boolean appendSingleQuoteForPackageInsertText(LSContext context) {
        List defaultTokens = (List)context.get(SourcePruneKeys.LHS_DEFAULT_TOKENS_KEY);
        if (defaultTokens == null || defaultTokens.isEmpty()) {
            return false;
        }
        CommonToken lastToken = (CommonToken)defaultTokens.get(defaultTokens.size() - 1);
        return !lastToken.getText().startsWith("'");
    }

    private void addIfNotExists(SnippetBlock snippet, BLangService service, List<LSCompletionItem> items, LSContext ctx) {
        boolean found = false;
        for (BLangFunction resource : service.getResources()) {
            if (!snippet.getLabel().endsWith(resource.name.value + " " + "resource")) continue;
            found = true;
        }
        if (!found) {
            items.add(new SnippetCompletionItem(ctx, snippet));
        }
    }
}

