/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.providers.contextproviders;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.ballerinalang.langserver.common.CommonKeys;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.commons.LSContext;
import org.ballerinalang.langserver.commons.completion.CompletionKeys;
import org.ballerinalang.langserver.commons.completion.LSCompletionException;
import org.ballerinalang.langserver.commons.completion.LSCompletionItem;
import org.ballerinalang.langserver.completions.SnippetCompletionItem;
import org.ballerinalang.langserver.completions.providers.AbstractCompletionProvider;
import org.ballerinalang.langserver.completions.providers.contextproviders.AnnotationAccessExpressionContextProvider;
import org.ballerinalang.langserver.completions.util.Snippet;
import org.ballerinalang.langserver.completions.util.filters.DelimiterBasedContentFilter;
import org.ballerinalang.langserver.completions.util.filters.SymbolFilters;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.wso2.ballerinalang.compiler.semantics.model.Scope;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BInvokableSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;

public class InvocationArgsContextProvider
extends AbstractCompletionProvider {
    public InvocationArgsContextProvider() {
        this.attachmentPoints.add(InvocationArgsContextProvider.class);
    }

    @Override
    public List<LSCompletionItem> getCompletions(LSContext context) throws LSCompletionException {
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        int invocationOrDelimiterTokenType = (Integer)context.get(CompletionKeys.INVOCATION_TOKEN_TYPE_KEY);
        if (this.isAnnotationAccessExpression(context)) {
            return this.getProvider(AnnotationAccessExpressionContextProvider.class).getCompletions(context);
        }
        if (invocationOrDelimiterTokenType > -1) {
            Either<List<LSCompletionItem>, List<Scope.ScopeEntry>> filtered = SymbolFilters.get(DelimiterBasedContentFilter.class).filterItems(context);
            return this.getCompletionItemList(filtered, context);
        }
        ArrayList<Scope.ScopeEntry> visibleSymbols = new ArrayList<Scope.ScopeEntry>((Collection)context.get(CommonKeys.VISIBLE_SYMBOLS_KEY));
        visibleSymbols.removeIf(scopeEntry -> {
            BSymbol bSymbol = scopeEntry.symbol;
            return bSymbol instanceof BInvokableSymbol && ((BInvokableSymbol)bSymbol).receiverSymbol != null && CommonUtil.isValidInvokableSymbol(bSymbol) || bSymbol instanceof BInvokableSymbol && (bSymbol.flags & 8) == 8;
        });
        completionItems.addAll(this.getCompletionItemList(visibleSymbols, context));
        completionItems.addAll(this.getPackagesCompletionItems(context));
        SnippetCompletionItem untaintKeyword = new SnippetCompletionItem(context, Snippet.KW_UNTAINT.get());
        completionItems.add(untaintKeyword);
        return completionItems;
    }
}

