/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.providers.scopeproviders;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.CommonToken;
import org.antlr.v4.runtime.ParserRuleContext;
import org.ballerinalang.langserver.common.CommonKeys;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.common.utils.FilterUtils;
import org.ballerinalang.langserver.commons.LSContext;
import org.ballerinalang.langserver.commons.completion.CompletionKeys;
import org.ballerinalang.langserver.commons.completion.LSCompletionException;
import org.ballerinalang.langserver.commons.completion.LSCompletionItem;
import org.ballerinalang.langserver.completions.CompletionSubRuleParser;
import org.ballerinalang.langserver.completions.SnippetCompletionItem;
import org.ballerinalang.langserver.completions.providers.AbstractCompletionProvider;
import org.ballerinalang.langserver.completions.providers.contextproviders.AnnotationAttachmentContextProvider;
import org.ballerinalang.langserver.completions.util.Snippet;
import org.ballerinalang.langserver.sourceprune.SourcePruneKeys;
import org.ballerinalang.model.tree.NodeKind;
import org.wso2.ballerinalang.compiler.parser.antlr4.BallerinaParser;
import org.wso2.ballerinalang.compiler.semantics.model.Scope;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BObjectTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BPackageSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.tree.BLangNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangObjectTypeNode;

public class ObjectTypeNodeScopeProvider
extends AbstractCompletionProvider {
    public ObjectTypeNodeScopeProvider() {
        this.attachmentPoints.add(BLangObjectTypeNode.class);
    }

    @Override
    public List<LSCompletionItem> getCompletions(LSContext context) throws LSCompletionException {
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        BLangNode objectNode = (BLangNode)context.get(CompletionKeys.SCOPE_NODE_KEY);
        if (!objectNode.getKind().equals((Object)NodeKind.OBJECT_TYPE)) {
            return completionItems;
        }
        if (this.inFunctionReturnParameterContext(context)) {
            return this.getProvider(BallerinaParser.ReturnParameterContext.class).getCompletions(context);
        }
        List lhsTokens = (List)context.get(SourcePruneKeys.LHS_TOKENS_KEY);
        Optional<String> subRule = this.getSubRule(lhsTokens);
        subRule.ifPresent(rule -> CompletionSubRuleParser.parseWithinObjectTypeDefinition(rule, context));
        ParserRuleContext parserRuleContext = (ParserRuleContext)context.get(CompletionKeys.PARSER_RULE_CONTEXT_KEY);
        List lhsDefaultTokens = (List)context.get(SourcePruneKeys.LHS_DEFAULT_TOKENS_KEY);
        if (this.isAnnotationAttachmentContext(context)) {
            return this.getProvider(AnnotationAttachmentContextProvider.class).getCompletions(context);
        }
        if (parserRuleContext != null && this.getProvider(parserRuleContext.getClass()) != null) {
            return this.getProvider(parserRuleContext.getClass()).getCompletions(context);
        }
        if (!lhsDefaultTokens.isEmpty() && ((CommonToken)lhsDefaultTokens.get(0)).getType() == 112) {
            this.fillObjectReferences(completionItems, lhsDefaultTokens, context);
        } else {
            this.fillTypes(context, completionItems);
            completionItems.add(new SnippetCompletionItem(context, Snippet.DEF_FUNCTION_SIGNATURE.get()));
            completionItems.add(new SnippetCompletionItem(context, Snippet.DEF_FUNCTION.get()));
            completionItems.add(new SnippetCompletionItem(context, Snippet.DEF_REMOTE_FUNCTION.get()));
            completionItems.add(new SnippetCompletionItem(context, Snippet.DEF_INIT_FUNCTION.get()));
            completionItems.add(new SnippetCompletionItem(context, Snippet.DEF_ATTACH_FUNCTION.get()));
            completionItems.add(new SnippetCompletionItem(context, Snippet.DEF_DETACH_FUNCTION.get()));
            completionItems.add(new SnippetCompletionItem(context, Snippet.DEF_START_FUNCTION.get()));
            completionItems.add(new SnippetCompletionItem(context, Snippet.DEF_GRACEFUL_STOP_FUNCTION.get()));
            completionItems.add(new SnippetCompletionItem(context, Snippet.DEF_IMMEDIATE_STOP_FUNCTION.get()));
            completionItems.add(new SnippetCompletionItem(context, Snippet.KW_PUBLIC.get()));
            completionItems.add(new SnippetCompletionItem(context, Snippet.KW_PRIVATE.get()));
        }
        return completionItems;
    }

    private void fillTypes(LSContext context, List<LSCompletionItem> completionItems) {
        ArrayList visibleSymbols = new ArrayList((Collection)context.get(CommonKeys.VISIBLE_SYMBOLS_KEY));
        List filteredTypes = visibleSymbols.stream().filter(FilterUtils::isBTypeEntry).collect(Collectors.toList());
        completionItems.addAll(this.getCompletionItemList(new ArrayList<Scope.ScopeEntry>(filteredTypes), context));
        completionItems.addAll(this.getPackagesCompletionItems(context));
    }

    private void fillObjectReferences(List<LSCompletionItem> completionItems, List<CommonToken> lhsDefaultTokens, LSContext ctx) {
        CommonToken lastItem = CommonUtil.getLastItem(lhsDefaultTokens);
        if (lastItem != null && lastItem.getType() == 96) {
            String pkgName = lhsDefaultTokens.get(1).getText();
            ArrayList visibleSymbols = new ArrayList((Collection)ctx.get(CommonKeys.VISIBLE_SYMBOLS_KEY));
            Optional<Scope.ScopeEntry> pkgSymbolInfo = visibleSymbols.stream().filter(scopeEntry -> scopeEntry.symbol instanceof BPackageSymbol && scopeEntry.symbol.pkgID.getName().getValue().equals(pkgName)).findAny();
            if (pkgSymbolInfo.isPresent()) {
                List<Scope.ScopeEntry> filteredSymbolInfo = pkgSymbolInfo.get().symbol.scope.entries.values().stream().filter(scopeEntry -> scopeEntry.symbol instanceof BObjectTypeSymbol && (scopeEntry.symbol.flags & 0x1000) == 4096).map(scopeEntry -> {
                    BObjectTypeSymbol oSymbol = (BObjectTypeSymbol)scopeEntry.symbol;
                    return new Scope.ScopeEntry((BSymbol)oSymbol, null);
                }).collect(Collectors.toList());
                completionItems.addAll(this.getCompletionItemList(filteredSymbolInfo, ctx));
            }
        } else {
            this.fillVisibleObjectsAndPackages(completionItems, ctx);
        }
    }

    private void fillVisibleObjectsAndPackages(List<LSCompletionItem> completionItems, LSContext ctx) {
        ArrayList visibleSymbols = new ArrayList((Collection)ctx.get(CommonKeys.VISIBLE_SYMBOLS_KEY));
        List filteredList = visibleSymbols.stream().filter(scopeEntry -> scopeEntry.symbol instanceof BObjectTypeSymbol && (scopeEntry.symbol.flags & 0x1000) == 4096).collect(Collectors.toList());
        completionItems.addAll(this.getCompletionItemList(new ArrayList<Scope.ScopeEntry>(filteredList), ctx));
        completionItems.addAll(this.getPackagesCompletionItems(ctx));
    }
}

