/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.providers.scopeproviders;

import java.util.ArrayList;
import java.util.List;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.commons.LSContext;
import org.ballerinalang.langserver.commons.completion.CompletionKeys;
import org.ballerinalang.langserver.commons.completion.LSCompletionException;
import org.ballerinalang.langserver.commons.completion.LSCompletionItem;
import org.ballerinalang.langserver.compiler.DocumentServiceKeys;
import org.ballerinalang.langserver.completions.SnippetCompletionItem;
import org.ballerinalang.langserver.completions.providers.AbstractCompletionProvider;
import org.ballerinalang.langserver.completions.providers.contextproviders.AnnotationAttachmentContextProvider;
import org.ballerinalang.langserver.completions.util.Snippet;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.TextDocumentPositionParams;
import org.wso2.ballerinalang.compiler.tree.BLangNode;
import org.wso2.ballerinalang.compiler.tree.BLangService;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExpression;
import org.wso2.ballerinalang.compiler.util.diagnotic.DiagnosticPos;

public class ServiceScopeProvider
extends AbstractCompletionProvider {
    public ServiceScopeProvider() {
        this.attachmentPoints.add(BLangService.class);
    }

    @Override
    public List<LSCompletionItem> getCompletions(LSContext ctx) throws LSCompletionException {
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        if (this.isWithinAttachedExpressions(ctx)) {
            return this.getCompletionItemsAfterOnKeyword(ctx);
        }
        if (this.isAnnotationAttachmentContext(ctx)) {
            return this.getProvider(AnnotationAttachmentContextProvider.class).getCompletions(ctx);
        }
        completionItems.add(new SnippetCompletionItem(ctx, Snippet.KW_PUBLIC.get()));
        completionItems.add(new SnippetCompletionItem(ctx, Snippet.KW_FUNCTION.get()));
        completionItems.add(new SnippetCompletionItem(ctx, Snippet.KW_RESOURCE.get()));
        completionItems.addAll(this.getResourceSnippets(ctx));
        completionItems.add(new SnippetCompletionItem(ctx, Snippet.DEF_FUNCTION.get()));
        return completionItems;
    }

    private boolean isWithinAttachedExpressions(LSContext lsContext) {
        BLangNode bLangNode = (BLangNode)lsContext.get(CompletionKeys.SCOPE_NODE_KEY);
        if (!(bLangNode instanceof BLangService)) {
            return false;
        }
        BLangService service = (BLangService)bLangNode;
        Position cursorPos = ((TextDocumentPositionParams)lsContext.get(DocumentServiceKeys.POSITION_KEY)).getPosition();
        int line = cursorPos.getLine();
        int col = cursorPos.getCharacter();
        List attachedExprs = service.attachedExprs;
        if (attachedExprs.isEmpty()) {
            return false;
        }
        BLangExpression firstExpr = (BLangExpression)attachedExprs.get(0);
        BLangExpression lastExpr = (BLangExpression)CommonUtil.getLastItem(attachedExprs);
        DiagnosticPos firstExprPos = CommonUtil.toZeroBasedPosition(firstExpr.pos);
        int fSLine = firstExprPos.sLine;
        int fSCol = firstExprPos.sCol;
        DiagnosticPos lastExprPos = CommonUtil.toZeroBasedPosition(lastExpr.pos);
        int lSLine = lastExprPos.sLine;
        int lECol = lastExprPos.eCol;
        return fSLine <= line && lSLine >= line && fSCol <= col && lECol >= col;
    }
}

