/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.sourceprune;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.CommonToken;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenStream;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.sourceprune.AbstractTokenTraverser;
import org.ballerinalang.langserver.sourceprune.SourcePruneContext;
import org.ballerinalang.langserver.sourceprune.SourcePruneKeys;

class LHSCompletionsTokenTraverser
extends AbstractTokenTraverser {
    private List<Integer> lhsTraverseTerminals;
    private List<Integer> blockRemoveKWTerminals;
    private boolean removeBlock;
    private int rightParenthesisCount;
    private int leftParenthesisCount;
    private int rightBraceCount;
    private int rightBracketCount;
    private int ltSymbolCount;
    private int gtSymbolCount;
    private boolean capturedAssignToken;
    private boolean capturedEqualOrGTToken;
    private SourcePruneContext sourcePruneContext;
    private boolean forcedProcessedToken;

    LHSCompletionsTokenTraverser(SourcePruneContext sourcePruneContext, boolean pruneTokens) {
        super(pruneTokens);
        this.sourcePruneContext = sourcePruneContext;
        this.lhsTraverseTerminals = sourcePruneContext.get(SourcePruneKeys.LHS_TRAVERSE_TERMINALS_KEY);
        this.blockRemoveKWTerminals = sourcePruneContext.get(SourcePruneKeys.BLOCK_REMOVE_KW_TERMINALS_KEY);
        this.removeBlock = false;
        this.capturedAssignToken = false;
        this.forcedProcessedToken = false;
        this.rightParenthesisCount = 0;
        this.leftParenthesisCount = 0;
        this.rightBraceCount = 0;
        this.rightBracketCount = 0;
        this.ltSymbolCount = 0;
        this.gtSymbolCount = 0;
        this.processedTokens = new ArrayList();
    }

    @Override
    public List<CommonToken> traverse(TokenStream tokenStream, int tokenIndex) {
        boolean terminate;
        int type;
        Optional<Object> token = Optional.of(tokenStream.get(tokenIndex));
        while (!(!token.isPresent() || this.lhsTraverseTerminals.contains(type = token.get().getType()) && (terminate = this.terminateLHSTraverse(token.get(), tokenStream)))) {
            if (this.blockRemoveKWTerminals.contains(type)) {
                this.removeBlock = true;
            } else if (109 == type) {
                this.capturedAssignToken = true;
            } else if (104 == type) {
                ++this.rightBracketCount;
            } else if (118 == type) {
                ++this.gtSymbolCount;
            } else if (136 == type) {
                this.capturedEqualOrGTToken = true;
            }
            if (!this.forcedProcessedToken) {
                this.processToken(token.get());
            }
            this.forcedProcessedToken = false;
            tokenIndex = token.get().getTokenIndex() - 1;
            token = tokenIndex < 0 ? Optional.empty() : Optional.of(tokenStream.get(tokenIndex));
        }
        this.sourcePruneContext.put(SourcePruneKeys.REMOVE_DEFINITION_KEY, this.removeBlock);
        this.sourcePruneContext.put(SourcePruneKeys.RIGHT_PARAN_COUNT_KEY, this.rightParenthesisCount);
        this.sourcePruneContext.put(SourcePruneKeys.LEFT_PARAN_COUNT_KEY, this.leftParenthesisCount);
        this.sourcePruneContext.put(SourcePruneKeys.RIGHT_BRACE_COUNT_KEY, this.rightBraceCount);
        this.sourcePruneContext.put(SourcePruneKeys.LT_COUNT_KEY, this.ltSymbolCount);
        this.sourcePruneContext.put(SourcePruneKeys.GT_COUNT_KEY, this.gtSymbolCount);
        Collections.reverse(this.processedTokens);
        return this.processedTokens;
    }

    private boolean terminateLHSTraverse(Token token, TokenStream tokenStream) {
        int type = token.getType();
        if (type == 102) {
            ++this.rightParenthesisCount;
            this.processToken(token);
            this.forcedProcessedToken = true;
            return false;
        }
        if (type == 101) {
            Optional<Token> tokenToLeft = CommonUtil.getPreviousDefaultToken(tokenStream, token.getTokenIndex());
            if (this.rightParenthesisCount > 0) {
                --this.rightParenthesisCount;
                this.processToken(token);
                this.forcedProcessedToken = true;
                return false;
            }
            if (this.incompleteStatementWithParenthesis(tokenStream, token)) {
                ++this.leftParenthesisCount;
                this.processToken(token);
                this.forcedProcessedToken = true;
                this.sourcePruneContext.put(SourcePruneKeys.FORCE_CAPTURED_STATEMENT_WITH_PARENTHESIS_KEY, true);
                return false;
            }
            if (tokenToLeft.isPresent() && (50 == tokenToLeft.get().getType() || 54 == tokenToLeft.get().getType())) {
                this.replaceCondition(tokenStream, token.getTokenIndex());
            }
            return true;
        }
        if (type == 100 && this.lastProcessedToken != null && (this.lastProcessedToken.getType() == 109 || this.lastProcessedToken.getType() == 136 || this.rightBraceCount > 0 || this.gtSymbolCount > 0)) {
            this.processToken(token);
            this.forcedProcessedToken = true;
            ++this.rightBraceCount;
            return false;
        }
        if (type == 99 && this.rightBraceCount > 0) {
            this.processToken(token);
            this.forcedProcessedToken = true;
            --this.rightBraceCount;
            return false;
        }
        if (type == 103 && this.rightBracketCount > 0) {
            this.processToken(token);
            this.forcedProcessedToken = true;
            --this.rightBracketCount;
            return false;
        }
        if (type == 119) {
            this.processToken(token);
            this.forcedProcessedToken = true;
            if (this.gtSymbolCount > 0) {
                --this.gtSymbolCount;
                return false;
            }
            ++this.ltSymbolCount;
            return false;
        }
        if (type == 19) {
            this.processToken(token);
            this.forcedProcessedToken = true;
            return !this.removeFunctionSignatureOnReturnKWMatch(tokenStream) && this.rightParenthesisCount == 0 && this.rightBraceCount == 0;
        }
        boolean onServiceRule = CommonUtil.getNDefaultTokensToLeft(tokenStream, 2, token.getTokenIndex()).stream().map(Token::getType).collect(Collectors.toList()).contains(7);
        if (token.getType() == 98 || !onServiceRule && token.getType() == 27) {
            boolean isComma = token.getType() == 98;
            this.processToken(token);
            this.forcedProcessedToken = true;
            if (isComma && this.incompleteStatementWithParenthesis(tokenStream, token)) {
                this.sourcePruneContext.put(SourcePruneKeys.FORCE_CAPTURED_STATEMENT_WITH_PARENTHESIS_KEY, true);
                return false;
            }
        }
        return this.rightParenthesisCount == 0 && this.rightBraceCount == 0 && this.rightBracketCount == 0;
    }

    private boolean removeFunctionSignatureOnReturnKWMatch(TokenStream tokenStream) {
        List processedDefaultTokens = this.processedTokens.stream().filter(commonToken -> commonToken.getChannel() == 0).collect(Collectors.toList());
        int processedTokenSize = processedDefaultTokens.size();
        if (this.capturedAssignToken || this.capturedEqualOrGTToken) {
            return true;
        }
        if (processedTokenSize <= 2) {
            Optional<Token> nextDefaultToken = CommonUtil.getNextDefaultToken(tokenStream, ((CommonToken)processedDefaultTokens.get(0)).getTokenIndex());
            return nextDefaultToken.isPresent() && nextDefaultToken.get().getType() != 109 && nextDefaultToken.get().getType() != 99;
        }
        if (processedTokenSize <= 4) {
            Optional<Token> nextDefaultToken = CommonUtil.getNextDefaultToken(tokenStream, ((CommonToken)processedDefaultTokens.get(0)).getTokenIndex());
            return nextDefaultToken.isPresent() && nextDefaultToken.get().getType() != 109 && nextDefaultToken.get().getType() != 99;
        }
        return false;
    }

    private boolean incompleteStatementWithParenthesis(TokenStream tokenStream, Token token) {
        Token referenceToken = this.processedTokens.isEmpty() ? token : (Token)this.processedTokens.get(0);
        Optional<Token> tokenOneToRight = CommonUtil.getNextDefaultToken(tokenStream, referenceToken.getTokenIndex());
        if (!tokenOneToRight.isPresent()) {
            return true;
        }
        int nextTokenType = tokenOneToRight.get().getType();
        if (nextTokenType == 102) {
            Optional<Token> tokenTwoToRight = CommonUtil.getNextDefaultToken(tokenStream, tokenOneToRight.get().getTokenIndex());
            if (tokenTwoToRight.isPresent()) {
                if (tokenTwoToRight.get().getType() == 19) {
                    return false;
                }
                Optional<Token> tokenThreeToRight = CommonUtil.getNextDefaultToken(tokenStream, tokenTwoToRight.get().getTokenIndex());
                if (tokenThreeToRight.isPresent() && tokenThreeToRight.get().getType() == 109) {
                    return false;
                }
            }
            if (!this.pruneTokens) {
                return tokenTwoToRight.isPresent() && (tokenTwoToRight.get().getType() == 95 || tokenTwoToRight.get().getType() == 99);
            }
            return !tokenTwoToRight.isPresent() || tokenTwoToRight.get().getType() != 95 && tokenTwoToRight.get().getType() != 99;
        }
        return false;
    }
}

