/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.util;

import java.util.List;
import java.util.stream.Collectors;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.wso2.ballerinalang.compiler.semantics.model.types.BRecordType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTupleType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;

public class MatchStatementResolverUtil {
    public static String getVariableValueDestructurePattern() {
        String valueHolder = "${1:value}";
        String bodyPlaceHolder = "${2}";
        return valueHolder + " => " + "{" + bodyPlaceHolder + "}";
    }

    public static String getStructuredFixedValueMatch(BType bType) {
        StringBuilder fixedValPattern = new StringBuilder();
        if (bType instanceof BTupleType) {
            List tupleTypes = ((BTupleType)bType).getTupleTypes();
            List defaultValues = tupleTypes.stream().map(MatchStatementResolverUtil::getStructuredFixedValueMatch).collect(Collectors.toList());
            fixedValPattern.append("[").append(String.join((CharSequence)", ", defaultValues)).append("]");
        } else if (bType instanceof BRecordType) {
            List fields = ((BRecordType)bType).fields;
            List defaultValues = fields.stream().map(field -> field.getName().getValue() + ":" + MatchStatementResolverUtil.getStructuredFixedValueMatch(field.getType())).collect(Collectors.toList());
            fixedValPattern.append("{").append(String.join((CharSequence)", ", defaultValues)).append("}");
        } else {
            fixedValPattern.append(CommonUtil.getDefaultValueForType(bType));
        }
        return fixedValPattern.toString();
    }

    public static String generateMatchPattern(String matchValue) {
        String valueHolder = "${1:" + matchValue + "}";
        String bodyPlaceHolder = "${2}";
        return valueHolder + " => " + "{" + bodyPlaceHolder + "}";
    }
}

