/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.util.positioning.resolvers;

import java.util.List;
import java.util.Map;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.commons.LSContext;
import org.ballerinalang.langserver.compiler.DocumentServiceKeys;
import org.ballerinalang.langserver.completions.TreeVisitor;
import org.ballerinalang.langserver.completions.util.positioning.resolvers.CursorPositionResolver;
import org.ballerinalang.model.tree.Node;
import org.eclipse.lsp4j.TextDocumentPositionParams;
import org.wso2.ballerinalang.compiler.semantics.model.Scope;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.tree.BLangNode;
import org.wso2.ballerinalang.compiler.tree.statements.BLangForkJoin;
import org.wso2.ballerinalang.compiler.util.Name;
import org.wso2.ballerinalang.compiler.util.diagnotic.DiagnosticPos;

public class ForkJoinStatementScopeResolver
extends CursorPositionResolver {
    @Override
    public boolean isCursorBeforeNode(DiagnosticPos nodePosition, TreeVisitor treeVisitor, LSContext completionContext, BLangNode node, BSymbol bSymbol) {
        if (treeVisitor.getForkJoinStack().isEmpty()) {
            return false;
        }
        int line = ((TextDocumentPositionParams)completionContext.get(DocumentServiceKeys.POSITION_KEY)).getPosition().getLine();
        int col = ((TextDocumentPositionParams)completionContext.get(DocumentServiceKeys.POSITION_KEY)).getPosition().getCharacter();
        DiagnosticPos zeroBasedPos = CommonUtil.toZeroBasedPosition(nodePosition);
        int nodeSLine = zeroBasedPos.sLine;
        int nodeSCol = zeroBasedPos.sCol;
        int nodeELine = zeroBasedPos.eLine;
        int nodeECol = zeroBasedPos.eCol;
        BLangForkJoin parent = treeVisitor.getForkJoinStack().peek();
        boolean isLastStatement = this.isNodeLastStatement(parent, (Node)node);
        boolean isWithinScopeAfterLastChild = this.isWithinScopeAfterLastChildNode(parent, isLastStatement, nodeELine, nodeECol, line, col);
        if (line < nodeSLine || line == nodeSLine && col <= nodeSCol || isWithinScopeAfterLastChild) {
            Map<Name, List<Scope.ScopeEntry>> visibleSymbolEntries = treeVisitor.resolveAllVisibleSymbols(treeVisitor.getSymbolEnv());
            treeVisitor.populateSymbols(visibleSymbolEntries, treeVisitor.getSymbolEnv());
            treeVisitor.forceTerminateVisitor();
            treeVisitor.setNextNode(bSymbol, node);
            return true;
        }
        return false;
    }

    private boolean isWithinScopeAfterLastChildNode(BLangForkJoin parent, boolean lastChild, int nodeELine, int nodeECol, int line, int col) {
        if (!lastChild) {
            return false;
        }
        DiagnosticPos diagnosticPos = CommonUtil.toZeroBasedPosition(parent.pos);
        int blockOwnerELine = diagnosticPos.eLine;
        int blockOwnerECol = diagnosticPos.eCol;
        return (line < blockOwnerELine || line == blockOwnerELine && col <= blockOwnerECol) && (line > nodeELine || line == nodeELine && col > nodeECol);
    }

    private boolean isNodeLastStatement(BLangForkJoin forkJoin, Node node) {
        return !forkJoin.workers.isEmpty() && forkJoin.workers.indexOf(node) == forkJoin.workers.size() - 1;
    }
}

