/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.util.positioning.resolvers;

import java.util.List;
import java.util.Map;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.commons.LSContext;
import org.ballerinalang.langserver.compiler.DocumentServiceKeys;
import org.ballerinalang.langserver.completions.TreeVisitor;
import org.ballerinalang.langserver.completions.util.positioning.resolvers.CursorPositionResolver;
import org.eclipse.lsp4j.TextDocumentPositionParams;
import org.wso2.ballerinalang.compiler.semantics.model.Scope;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolEnv;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.tree.BLangNode;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangMatchExpression;
import org.wso2.ballerinalang.compiler.util.Name;
import org.wso2.ballerinalang.compiler.util.diagnotic.DiagnosticPos;

public class MatchExpressionScopeResolver
extends CursorPositionResolver {
    @Override
    public boolean isCursorBeforeNode(DiagnosticPos nodePosition, TreeVisitor treeVisitor, LSContext completionContext, BLangNode node, BSymbol bSymbol) {
        if (!(treeVisitor.getBlockOwnerStack().peek() instanceof BLangMatchExpression)) {
            return false;
        }
        BLangMatchExpression matchNode = (BLangMatchExpression)treeVisitor.getBlockOwnerStack().peek();
        DiagnosticPos matchNodePos = CommonUtil.toZeroBasedPosition(matchNode.getPosition());
        DiagnosticPos nodePos = CommonUtil.toZeroBasedPosition(node.getPosition());
        List patternClauseList = matchNode.getPatternClauses();
        int line = ((TextDocumentPositionParams)completionContext.get(DocumentServiceKeys.POSITION_KEY)).getPosition().getLine();
        int col = ((TextDocumentPositionParams)completionContext.get(DocumentServiceKeys.POSITION_KEY)).getPosition().getCharacter();
        int nodeLine = nodePos.getStartLine();
        int nodeCol = nodePos.getStartColumn();
        boolean isBeforeNode = false;
        if (line < nodeLine || line == nodeLine && col < nodeCol) {
            isBeforeNode = true;
        } else if (patternClauseList.indexOf(node) == patternClauseList.size() - 1) {
            boolean bl = isBeforeNode = line < matchNodePos.getEndLine() || line == matchNodePos.getEndLine() && col < matchNodePos.getEndColumn();
        }
        if (isBeforeNode) {
            Map<Name, List<Scope.ScopeEntry>> visibleSymbolEntries = treeVisitor.resolveAllVisibleSymbols(treeVisitor.getSymbolEnv());
            SymbolEnv matchEnv = MatchExpressionScopeResolver.createMatchExpressionEnv(matchNode, treeVisitor.getSymbolEnv());
            treeVisitor.populateSymbols(visibleSymbolEntries, matchEnv);
            treeVisitor.forceTerminateVisitor();
            treeVisitor.setNextNode(bSymbol, node);
        }
        return isBeforeNode;
    }

    private static SymbolEnv createMatchExpressionEnv(BLangMatchExpression matchExpression, SymbolEnv env) {
        SymbolEnv symbolEnv = new SymbolEnv((BLangNode)matchExpression, null);
        env.copyTo(symbolEnv);
        return symbolEnv;
    }
}

