/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.util.positioning.resolvers;

import java.util.List;
import java.util.Map;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.commons.LSContext;
import org.ballerinalang.langserver.compiler.DocumentServiceKeys;
import org.ballerinalang.langserver.completions.TreeVisitor;
import org.ballerinalang.langserver.completions.util.CompletionVisitorUtil;
import org.ballerinalang.langserver.completions.util.positioning.resolvers.CursorPositionResolver;
import org.ballerinalang.model.tree.Node;
import org.eclipse.lsp4j.TextDocumentPositionParams;
import org.wso2.ballerinalang.compiler.semantics.model.Scope;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.tree.BLangNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangObjectTypeNode;
import org.wso2.ballerinalang.compiler.util.Name;
import org.wso2.ballerinalang.compiler.util.diagnotic.DiagnosticPos;

public class ObjectTypeScopeResolver
extends CursorPositionResolver {
    @Override
    public boolean isCursorBeforeNode(DiagnosticPos nodePosition, TreeVisitor treeVisitor, LSContext completionContext, BLangNode node, BSymbol bSymbol) {
        boolean isLastItem;
        if (!(treeVisitor.getBlockOwnerStack().peek() instanceof BLangObjectTypeNode)) {
            return false;
        }
        Node blockOwner = treeVisitor.getBlockOwnerStack().peek();
        if (blockOwner == null) {
            return false;
        }
        BLangObjectTypeNode ownerObject = (BLangObjectTypeNode)treeVisitor.getBlockOwnerStack().peek();
        DiagnosticPos zeroBasedPos = CommonUtil.toZeroBasedPosition(nodePosition);
        DiagnosticPos blockOwnerPos = CommonUtil.toZeroBasedPosition(((BLangObjectTypeNode)blockOwner).parent.getPosition());
        int line = ((TextDocumentPositionParams)completionContext.get(DocumentServiceKeys.POSITION_KEY)).getPosition().getLine();
        int col = ((TextDocumentPositionParams)completionContext.get(DocumentServiceKeys.POSITION_KEY)).getPosition().getCharacter();
        BLangNode lastItem = CommonUtil.getLastItem(CompletionVisitorUtil.getObjectItemsOrdered(ownerObject));
        boolean bl = isLastItem = lastItem == node;
        if (line < zeroBasedPos.getStartLine() || line == zeroBasedPos.getStartLine() && col < zeroBasedPos.getStartColumn() || isLastItem && (blockOwnerPos.getEndLine() > line && zeroBasedPos.getEndLine() < line || blockOwnerPos.getEndLine() == line && blockOwnerPos.getEndColumn() > col)) {
            Map<Name, List<Scope.ScopeEntry>> visibleSymbolEntries = treeVisitor.resolveAllVisibleSymbols(treeVisitor.getSymbolEnv());
            treeVisitor.populateSymbols(visibleSymbolEntries, treeVisitor.getSymbolEnv());
            treeVisitor.forceTerminateVisitor();
            treeVisitor.setNextNode(bSymbol, node);
            return true;
        }
        return false;
    }
}

