/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.util.positioning.resolvers;

import java.util.List;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.commons.LSContext;
import org.ballerinalang.langserver.compiler.DocumentServiceKeys;
import org.ballerinalang.langserver.completions.TreeVisitor;
import org.ballerinalang.langserver.completions.util.positioning.resolvers.CursorPositionResolver;
import org.ballerinalang.model.tree.Node;
import org.eclipse.lsp4j.TextDocumentPositionParams;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolEnv;
import org.wso2.ballerinalang.compiler.tree.BLangNode;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRecordLiteral;
import org.wso2.ballerinalang.compiler.util.diagnotic.DiagnosticPos;

public class RecordLiteralScopeResolver
extends CursorPositionResolver {
    @Override
    public boolean isCursorBeforeNode(DiagnosticPos nodePosition, TreeVisitor treeVisitor, LSContext completionContext, BLangNode node) {
        boolean isCursorBefore;
        Node recordNode = treeVisitor.getBlockOwnerStack().peek();
        if (!(recordNode instanceof BLangRecordLiteral)) {
            return false;
        }
        BLangRecordLiteral recordLiteral = (BLangRecordLiteral)recordNode;
        int line = ((TextDocumentPositionParams)completionContext.get(DocumentServiceKeys.POSITION_KEY)).getPosition().getLine();
        int col = ((TextDocumentPositionParams)completionContext.get(DocumentServiceKeys.POSITION_KEY)).getPosition().getCharacter();
        DiagnosticPos nodePos = CommonUtil.toZeroBasedPosition(nodePosition);
        DiagnosticPos ownerPos = CommonUtil.toZeroBasedPosition(recordLiteral.getPosition());
        int ownerEndLine = ownerPos.getEndLine();
        int ownerEndCol = ownerPos.getEndColumn();
        int nodeStartLine = nodePos.getStartLine();
        int nodeStartCol = nodePos.getStartColumn();
        int nodeEndCol = nodePos.getEndColumn();
        int nodeEndLine = nodePos.getEndLine();
        List fields = recordLiteral.fields;
        boolean isLastField = fields.indexOf(node) == fields.size() - 1;
        boolean bl = isCursorBefore = nodeStartLine > line || nodeStartLine == line && col < nodeStartCol || isLastField && (line < ownerEndLine && (line > nodeEndLine || line == nodeEndLine && col >= nodeEndCol) || line == ownerEndLine && col < ownerEndCol);
        if (isCursorBefore) {
            treeVisitor.forceTerminateVisitor();
            SymbolEnv recordEnv = RecordLiteralScopeResolver.createRecordLiteralEnv(recordLiteral, treeVisitor.getSymbolEnv());
            treeVisitor.populateSymbols(treeVisitor.resolveAllVisibleSymbols(recordEnv), recordEnv);
        }
        return isCursorBefore;
    }

    private static SymbolEnv createRecordLiteralEnv(BLangRecordLiteral record, SymbolEnv env) {
        SymbolEnv symbolEnv = new SymbolEnv((BLangNode)record, env.scope);
        env.copyTo(symbolEnv);
        return symbolEnv;
    }
}

