/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.util.sorters;

import java.util.List;
import javax.annotation.Nonnull;
import org.ballerinalang.langserver.commons.LSContext;
import org.ballerinalang.langserver.commons.completion.LSCompletionItem;
import org.ballerinalang.langserver.completions.util.Priority;
import org.eclipse.lsp4j.CompletionItem;

public abstract class CompletionItemSorter {
    public abstract List<CompletionItem> sortItems(LSContext var1, List<LSCompletionItem> var2);

    protected void setPriorities(List<CompletionItem> completionItems) {
        completionItems.forEach(this::setPriority);
    }

    void removeCompletionsByType(List<String> types, List<CompletionItem> completionItems) {
        completionItems.removeIf(completionItem -> types.contains(completionItem.getDetail()));
    }

    protected final void setPriority(CompletionItem completionItem) {
        if (completionItem.getKind() == null) {
            completionItem.setSortText(Priority.PRIORITY110.toString());
            return;
        }
        switch (completionItem.getKind()) {
            case Snippet: {
                completionItem.setSortText(Priority.PRIORITY240.toString());
                break;
            }
            case Unit: {
                completionItem.setSortText(Priority.PRIORITY230.toString());
                break;
            }
            case Keyword: {
                completionItem.setSortText(Priority.PRIORITY220.toString());
                break;
            }
            case Field: {
                completionItem.setSortText(Priority.PRIORITY210.toString());
                break;
            }
            case Event: {
                completionItem.setSortText(Priority.PRIORITY200.toString());
                break;
            }
            case Interface: {
                completionItem.setSortText(Priority.PRIORITY190.toString());
                break;
            }
            case Struct: {
                completionItem.setSortText(Priority.PRIORITY180.toString());
                break;
            }
            case TypeParameter: {
                completionItem.setSortText(Priority.PRIORITY170.toString());
                break;
            }
            case Enum: {
                completionItem.setSortText(Priority.PRIORITY160.toString());
                break;
            }
            case Class: {
                completionItem.setSortText(Priority.PRIORITY150.toString());
                break;
            }
            case Module: {
                completionItem.setSortText(Priority.PRIORITY140.toString());
                break;
            }
            case Variable: {
                completionItem.setSortText(Priority.PRIORITY130.toString());
                break;
            }
            case Function: {
                completionItem.setSortText(Priority.PRIORITY120.toString());
                break;
            }
            default: {
                completionItem.setSortText(Priority.PRIORITY110.toString());
            }
        }
    }

    @Nonnull
    protected abstract List<Class> getAttachedContexts();
}

