/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.util.sorters.scope;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import org.ballerinalang.langserver.SnippetBlock;
import org.ballerinalang.langserver.commons.LSContext;
import org.ballerinalang.langserver.commons.completion.LSCompletionItem;
import org.ballerinalang.langserver.completions.SnippetCompletionItem;
import org.ballerinalang.langserver.completions.util.Priority;
import org.ballerinalang.langserver.completions.util.sorters.CompletionItemSorter;
import org.eclipse.lsp4j.CompletionItem;
import org.wso2.ballerinalang.compiler.tree.BLangService;

public class ServiceScope
extends CompletionItemSorter {
    @Override
    public List<CompletionItem> sortItems(LSContext ctx, List<LSCompletionItem> lsCItems) {
        ArrayList<CompletionItem> cItems = new ArrayList<CompletionItem>();
        for (LSCompletionItem lsCItem : lsCItems) {
            CompletionItem cItem = lsCItem.getCompletionItem();
            if (lsCItem instanceof SnippetCompletionItem && ((SnippetCompletionItem)lsCItem).getSnippetType().equals((Object)SnippetBlock.SnippetType.SNIPPET)) {
                cItem.setSortText(Priority.PRIORITY110.toString());
            } else if (lsCItem instanceof SnippetCompletionItem && ((SnippetCompletionItem)lsCItem).getSnippetType().equals((Object)SnippetBlock.SnippetType.KEYWORD)) {
                cItem.setSortText(Priority.PRIORITY120.toString());
            } else {
                cItem.setSortText(Priority.PRIORITY130.toString());
            }
            cItems.add(cItem);
        }
        return cItems;
    }

    @Override
    @Nonnull
    protected List<Class> getAttachedContexts() {
        return Collections.singletonList(BLangService.class);
    }
}

