/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.diagnostic;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ballerinalang.langserver.client.ExtendedLanguageClient;
import org.ballerinalang.langserver.commons.LSContext;
import org.ballerinalang.langserver.commons.workspace.LSDocumentIdentifier;
import org.ballerinalang.langserver.commons.workspace.WorkspaceDocumentManager;
import org.ballerinalang.langserver.compiler.CollectDiagnosticListener;
import org.ballerinalang.langserver.compiler.DocumentServiceKeys;
import org.ballerinalang.langserver.compiler.LSModuleCompiler;
import org.ballerinalang.langserver.compiler.exception.CompilationFailedException;
import org.ballerinalang.util.diagnostic.Diagnostic;
import org.ballerinalang.util.diagnostic.DiagnosticListener;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.PublishDiagnosticsParams;
import org.eclipse.lsp4j.Range;
import org.wso2.ballerinalang.compiler.util.CompilerContext;

public class DiagnosticsHelper {
    private static final List<Diagnostic> EMPTY_DIAGNOSTIC_LIST = new ArrayList<Diagnostic>(0);
    private static final DiagnosticsHelper INSTANCE = new DiagnosticsHelper();
    private Map<String, List<Diagnostic>> lastDiagnosticMap = new HashMap<String, List<Diagnostic>>();

    public static DiagnosticsHelper getInstance() {
        return INSTANCE;
    }

    private DiagnosticsHelper() {
    }

    public synchronized void compileAndSendDiagnostics(ExtendedLanguageClient client, LSContext context, LSDocumentIdentifier lsDoc, WorkspaceDocumentManager docManager) throws CompilationFailedException {
        List<Object> diagnostics = new ArrayList<org.ballerinalang.util.diagnostic.Diagnostic>();
        LSModuleCompiler.getBLangPackages((LSContext)context, (WorkspaceDocumentManager)docManager, null, (boolean)true, (boolean)true, (boolean)true);
        CompilerContext compilerContext = (CompilerContext)context.get(DocumentServiceKeys.COMPILER_CONTEXT_KEY);
        if (compilerContext.get(DiagnosticListener.class) instanceof CollectDiagnosticListener) {
            diagnostics = ((CollectDiagnosticListener)compilerContext.get(DiagnosticListener.class)).getDiagnostics();
        }
        Map<String, List<Diagnostic>> diagnosticMap = this.getDiagnostics(diagnostics, lsDoc);
        if (client == null) {
            return;
        }
        this.lastDiagnosticMap.keySet().forEach(key -> diagnosticMap.computeIfAbsent((String)key, value -> EMPTY_DIAGNOSTIC_LIST));
        diagnosticMap.forEach((key, value) -> client.publishDiagnostics(new PublishDiagnosticsParams(key, value)));
        this.lastDiagnosticMap = diagnosticMap;
    }

    private Map<String, List<Diagnostic>> getDiagnostics(List<org.ballerinalang.util.diagnostic.Diagnostic> diagnostics, LSDocumentIdentifier lsDocument) {
        HashMap<String, List<Diagnostic>> diagnosticsMap = new HashMap<String, List<Diagnostic>>();
        for (org.ballerinalang.util.diagnostic.Diagnostic diag : diagnostics) {
            Path diagnosticRoot = lsDocument.getProjectRootPath();
            Diagnostic.DiagnosticPosition position = diag.getPosition();
            String moduleName = position.getSource().getPackageName();
            String fileName = position.getSource().getCompilationUnitName();
            if (lsDocument.isWithinProject()) {
                diagnosticRoot = diagnosticRoot.resolve("src");
            }
            if (!".".equals(moduleName)) {
                diagnosticRoot = diagnosticRoot.resolve(moduleName);
            }
            String fileURI = diagnosticRoot.resolve(fileName).toUri().toString() + "";
            diagnosticsMap.putIfAbsent(fileURI, new ArrayList());
            List clientDiagnostics = (List)diagnosticsMap.get(fileURI);
            int startLine = position.getStartLine() - 1;
            int startChar = position.getStartColumn() - 1;
            int endLine = position.getEndLine() - 1;
            int endChar = position.getEndColumn() - 1;
            endLine = endLine <= 0 ? startLine : endLine;
            endChar = endChar <= 0 ? startChar + 1 : endChar;
            Range range = new Range(new Position(startLine, startChar), new Position(endLine, endChar));
            Diagnostic diagnostic = new Diagnostic(range, diag.getMessage());
            Diagnostic.Kind diagnosticKind = diag.getKind();
            if (diagnosticKind.equals((Object)Diagnostic.Kind.ERROR)) {
                diagnostic.setSeverity(DiagnosticSeverity.Error);
            } else if (diagnosticKind.equals((Object)Diagnostic.Kind.WARNING)) {
                diagnostic.setSeverity(DiagnosticSeverity.Warning);
            }
            clientDiagnostics.add(diagnostic);
        }
        return diagnosticsMap;
    }
}

