/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.extensions.ballerina.document;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.locks.Lock;
import java.util.stream.Collectors;
import org.ballerinalang.ballerina.openapi.convertor.service.OpenApiConverterUtils;
import org.ballerinalang.compiler.CompilerPhase;
import org.ballerinalang.langserver.BallerinaLanguageServer;
import org.ballerinalang.langserver.LSContextOperation;
import org.ballerinalang.langserver.LSGlobalContext;
import org.ballerinalang.langserver.LSGlobalContextKeys;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.commons.LSContext;
import org.ballerinalang.langserver.commons.workspace.WorkspaceDocumentManager;
import org.ballerinalang.langserver.compiler.DocumentServiceKeys;
import org.ballerinalang.langserver.compiler.ExtendedLSCompiler;
import org.ballerinalang.langserver.compiler.LSClientLogger;
import org.ballerinalang.langserver.compiler.LSCompilerUtil;
import org.ballerinalang.langserver.compiler.LSModuleCompiler;
import org.ballerinalang.langserver.compiler.common.LSCustomErrorStrategy;
import org.ballerinalang.langserver.compiler.common.modal.BallerinaFile;
import org.ballerinalang.langserver.compiler.common.modal.SymbolMetaInfo;
import org.ballerinalang.langserver.compiler.format.JSONGenerationException;
import org.ballerinalang.langserver.compiler.format.TextDocumentFormatUtil;
import org.ballerinalang.langserver.compiler.sourcegen.FormattingSourceGen;
import org.ballerinalang.langserver.extensions.OASGenerationException;
import org.ballerinalang.langserver.extensions.VisibleEndpointVisitor;
import org.ballerinalang.langserver.extensions.ballerina.document.ApiDesignDidChangeParams;
import org.ballerinalang.langserver.extensions.ballerina.document.BallerinaASTDidChange;
import org.ballerinalang.langserver.extensions.ballerina.document.BallerinaASTDidChangeResponse;
import org.ballerinalang.langserver.extensions.ballerina.document.BallerinaASTRequest;
import org.ballerinalang.langserver.extensions.ballerina.document.BallerinaASTResponse;
import org.ballerinalang.langserver.extensions.ballerina.document.BallerinaDocumentService;
import org.ballerinalang.langserver.extensions.ballerina.document.BallerinaOASRequest;
import org.ballerinalang.langserver.extensions.ballerina.document.BallerinaOASResponse;
import org.ballerinalang.langserver.extensions.ballerina.document.BallerinaProject;
import org.ballerinalang.langserver.extensions.ballerina.document.BallerinaProjectParams;
import org.ballerinalang.langserver.extensions.ballerina.document.BallerinaServiceListRequest;
import org.ballerinalang.langserver.extensions.ballerina.document.BallerinaServiceListResponse;
import org.ballerinalang.langserver.extensions.ballerina.document.DocumentOperationContext;
import org.ballerinalang.model.tree.Node;
import org.ballerinalang.model.tree.ServiceNode;
import org.ballerinalang.openapi.CodeGenerator;
import org.ballerinalang.openapi.model.GenSrcFile;
import org.ballerinalang.openapi.utils.GeneratorConstants;
import org.eclipse.lsp4j.ApplyWorkspaceEditParams;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextDocumentEdit;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.wso2.ballerinalang.compiler.tree.BLangCompilationUnit;
import org.wso2.ballerinalang.compiler.tree.BLangNode;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;
import org.wso2.ballerinalang.compiler.util.CompilerContext;

public class BallerinaDocumentServiceImpl
implements BallerinaDocumentService {
    private final BallerinaLanguageServer ballerinaLanguageServer;
    private final WorkspaceDocumentManager documentManager;

    public BallerinaDocumentServiceImpl(LSGlobalContext globalContext) {
        this.ballerinaLanguageServer = globalContext.get(LSGlobalContextKeys.LANGUAGE_SERVER_KEY);
        this.documentManager = globalContext.get(LSGlobalContextKeys.DOCUMENT_MANAGER_KEY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<BallerinaOASResponse> openApiDefinition(BallerinaOASRequest request) {
        BallerinaOASResponse reply = new BallerinaOASResponse();
        String fileUri = request.getBallerinaDocument().getUri();
        Optional<Path> filePath = CommonUtil.getPathFromURI(fileUri);
        if (!filePath.isPresent()) {
            return CompletableFuture.supplyAsync(() -> reply);
        }
        Path compilationPath = LSCompilerUtil.getUntitledFilePath((String)filePath.get().toString()).orElse(filePath.get());
        Optional lock = this.documentManager.lockFile(compilationPath);
        try {
            String fileContent = this.documentManager.getFileContent(compilationPath);
            String openApiDefinition = OpenApiConverterUtils.generateOAS3Definitions((String)fileContent, (String)request.getBallerinaService());
            reply.setBallerinaOASJson(BallerinaDocumentServiceImpl.convertToJson(openApiDefinition));
        }
        catch (Throwable e) {
            reply.isIsError(true);
            String msg = "Operation 'ballerinaDocument/openApiDefinition' failed!";
            LSClientLogger.logError((String)msg, (Throwable)e, (TextDocumentIdentifier)request.getBallerinaDocument(), (Position[])new Position[]{null});
        }
        finally {
            lock.ifPresent(Lock::unlock);
        }
        return CompletableFuture.supplyAsync(() -> reply);
    }

    private static String convertToJson(String yamlString) throws IOException {
        ObjectMapper yamlReader = new ObjectMapper((JsonFactory)new YAMLFactory());
        Object obj = yamlReader.readValue(yamlString, Object.class);
        ObjectMapper jsonWriter = new ObjectMapper();
        return jsonWriter.writeValueAsString(obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void apiDesignDidChange(ApiDesignDidChangeParams params) {
        String fileUri = params.getDocumentIdentifier().getUri();
        Optional<Path> filePath = CommonUtil.getPathFromURI(fileUri);
        if (!filePath.isPresent()) {
            return;
        }
        Optional lock = this.documentManager.lockFile(filePath.get());
        try {
            File tempOasJsonFile = this.getOpenApiFile(params.getOASDefinition());
            CodeGenerator generator = new CodeGenerator();
            List oasSources = generator.generateBalSource(GeneratorConstants.GenType.GEN_SERVICE, tempOasJsonFile.getPath(), "", null);
            Optional<GenSrcFile> oasServiceFile = oasSources.stream().filter(genSrcFile -> genSrcFile.getType().equals((Object)GenSrcFile.GenFileType.GEN_SRC)).findAny();
            if (!oasServiceFile.isPresent()) {
                throw new OASGenerationException("OAS Service file is empty.");
            }
            BallerinaFile oasServiceBal = ExtendedLSCompiler.compileContent((String)oasServiceFile.get().getContent(), (CompilerPhase)CompilerPhase.CODE_ANALYZE);
            Optional oasFilePackage = oasServiceBal.getBLangPackage();
            String fileContent = this.documentManager.getFileContent(filePath.get());
            String[] contentComponents = fileContent.split("\\n|\\r\\n|\\r");
            int lastNewLineCharIndex = Math.max(fileContent.lastIndexOf("\n"), fileContent.lastIndexOf("\r"));
            int lastCharCol = fileContent.substring(lastNewLineCharIndex + 1).length();
            int totalLines = contentComponents.length;
            Range range = new Range(new Position(0, 0), new Position(totalLines, lastCharCol));
            BallerinaFile ballerinaFile = ExtendedLSCompiler.compileContent((String)fileContent, (CompilerPhase)CompilerPhase.CODE_ANALYZE);
            Optional bLangPackage = ballerinaFile.getBLangPackage();
            if (bLangPackage.isPresent() && ((BLangPackage)bLangPackage.get()).symbol != null && oasFilePackage.isPresent()) {
                Optional compilationUnit = ((BLangPackage)bLangPackage.get()).getCompilationUnits().stream().findFirst();
                Optional oasCompilationUnit = ((BLangPackage)oasFilePackage.get()).getCompilationUnits().stream().findFirst();
                if (!oasCompilationUnit.isPresent() || !compilationUnit.isPresent()) {
                    return;
                }
                JsonObject targetAST = TextDocumentFormatUtil.generateJSON((Node)((Node)compilationUnit.get()), new HashMap(), new HashMap()).getAsJsonObject();
                FormattingSourceGen.build((JsonObject)targetAST, (String)"CompilationUnit");
                JsonObject generatedAST = TextDocumentFormatUtil.generateJSON((Node)((Node)oasCompilationUnit.get()), new HashMap(), new HashMap()).getAsJsonObject();
                FormattingSourceGen.build((JsonObject)generatedAST, (String)"CompilationUnit");
                this.mergeAst(targetAST, generatedAST);
                String textEditContent = FormattingSourceGen.getSourceOf((JsonObject)targetAST);
                TextEdit textEdit = new TextEdit(range, textEditContent);
                ApplyWorkspaceEditParams applyWorkspaceEditParams = new ApplyWorkspaceEditParams();
                TextDocumentEdit textDocumentEdit = new TextDocumentEdit(params.getDocumentIdentifier(), Collections.singletonList(textEdit));
                WorkspaceEdit workspaceEdit = new WorkspaceEdit(Collections.singletonList(Either.forLeft((Object)textDocumentEdit)));
                applyWorkspaceEditParams.setEdit(workspaceEdit);
                this.ballerinaLanguageServer.getClient().applyEdit(applyWorkspaceEditParams);
            }
        }
        catch (Throwable e) {
            String msg = "Operation 'ballerinaDocument/apiDesignDidChange' failed!";
            LSClientLogger.logError((String)msg, (Throwable)e, (TextDocumentIdentifier)params.getDocumentIdentifier(), (Position[])new Position[]{null});
        }
        finally {
            lock.ifPresent(Lock::unlock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<BallerinaServiceListResponse> serviceList(BallerinaServiceListRequest request) {
        BallerinaServiceListResponse reply = new BallerinaServiceListResponse();
        String fileUri = request.getDocumentIdentifier().getUri();
        Optional<Path> filePath = CommonUtil.getPathFromURI(fileUri);
        if (!filePath.isPresent()) {
            return CompletableFuture.supplyAsync(() -> reply);
        }
        Path compilationPath = LSCompilerUtil.getUntitledFilePath((String)filePath.get().toString()).orElse(filePath.get());
        Optional lock = this.documentManager.lockFile(compilationPath);
        try {
            String fileContent = this.documentManager.getFileContent(compilationPath);
            BallerinaFile ballerinaFile = ExtendedLSCompiler.compileContent((String)fileContent, (CompilerPhase)CompilerPhase.CODE_ANALYZE);
            Optional bLangPackage = ballerinaFile.getBLangPackage();
            ArrayList services = new ArrayList();
            if (bLangPackage.isPresent() && ((BLangPackage)bLangPackage.get()).symbol != null) {
                BLangCompilationUnit compilationUnit = ((BLangPackage)bLangPackage.get()).getCompilationUnits().stream().findFirst().orElse(null);
                ArrayList servicePkgs = new ArrayList();
                servicePkgs.addAll(compilationUnit.getTopLevelNodes().stream().filter(topLevelNode -> topLevelNode instanceof ServiceNode).collect(Collectors.toList()));
                servicePkgs.forEach(servicepkg -> {
                    if (servicepkg instanceof ServiceNode) {
                        ServiceNode pkg = (ServiceNode)servicepkg;
                        services.add(pkg.getName().getValue());
                    }
                });
            }
            reply.setServices(services.toArray(new String[0]));
        }
        catch (Throwable e) {
            String msg = "Operation 'ballerinaDocument/serviceList' failed!";
            LSClientLogger.logError((String)msg, (Throwable)e, (TextDocumentIdentifier)request.getDocumentIdentifier(), (Position[])new Position[]{null});
        }
        finally {
            lock.ifPresent(Lock::unlock);
        }
        return CompletableFuture.supplyAsync(() -> reply);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<BallerinaASTResponse> ast(BallerinaASTRequest request) {
        BallerinaASTResponse reply = new BallerinaASTResponse();
        String fileUri = request.getDocumentIdentifier().getUri();
        Optional<Path> filePath = CommonUtil.getPathFromURI(fileUri);
        if (!filePath.isPresent()) {
            return CompletableFuture.supplyAsync(() -> reply);
        }
        Path compilationPath = LSCompilerUtil.getUntitledFilePath((String)filePath.get().toString()).orElse(filePath.get());
        Optional lock = this.documentManager.lockFile(compilationPath);
        try {
            LSContext astContext = ((DocumentOperationContext.DocumentOperationContextBuilder)new DocumentOperationContext.DocumentOperationContextBuilder(LSContextOperation.DOC_SERVICE_AST).withCommonParams(null, fileUri, this.documentManager)).build();
            LSModuleCompiler.getBLangPackage((LSContext)astContext, (WorkspaceDocumentManager)this.documentManager, LSCustomErrorStrategy.class, (boolean)false, (boolean)false);
            reply.setAst(this.getTreeForContent(astContext));
            reply.setParseSuccess(true);
        }
        catch (Throwable e) {
            reply.setParseSuccess(false);
            String msg = "Operation 'ballerinaDocument/ast' failed!";
            LSClientLogger.logError((String)msg, (Throwable)e, (TextDocumentIdentifier)request.getDocumentIdentifier(), (Position[])new Position[]{null});
        }
        finally {
            lock.ifPresent(Lock::unlock);
        }
        return CompletableFuture.supplyAsync(() -> reply);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<BallerinaASTDidChangeResponse> astDidChange(BallerinaASTDidChange notification) {
        BallerinaASTDidChangeResponse reply = new BallerinaASTDidChangeResponse();
        String fileUri = notification.getTextDocumentIdentifier().getUri();
        Optional<Path> filePath = CommonUtil.getPathFromURI(fileUri);
        if (!filePath.isPresent()) {
            return CompletableFuture.supplyAsync(() -> reply);
        }
        Path compilationPath = LSCompilerUtil.getUntitledFilePath((String)filePath.get().toString()).orElse(filePath.get());
        Optional lock = this.documentManager.lockFile(compilationPath);
        try {
            String fileContent = this.documentManager.getFileContent(compilationPath);
            String[] contentComponents = fileContent.split("\\n|\\r\\n|\\r");
            int lastNewLineCharIndex = Math.max(fileContent.lastIndexOf("\n"), fileContent.lastIndexOf("\r"));
            int lastCharCol = fileContent.substring(lastNewLineCharIndex + 1).length();
            int totalLines = contentComponents.length;
            Range range = new Range(new Position(0, 0), new Position(totalLines, lastCharCol));
            JsonObject ast = notification.getAst();
            FormattingSourceGen.build((JsonObject)ast, (String)"CompilationUnit");
            String textEditContent = FormattingSourceGen.getSourceOf((JsonObject)ast);
            TextEdit textEdit = new TextEdit(range, textEditContent);
            ApplyWorkspaceEditParams applyWorkspaceEditParams = new ApplyWorkspaceEditParams();
            TextDocumentEdit txtDocumentEdit = new TextDocumentEdit(notification.getTextDocumentIdentifier(), Collections.singletonList(textEdit));
            WorkspaceEdit workspaceEdit = new WorkspaceEdit(Collections.singletonList(Either.forLeft((Object)txtDocumentEdit)));
            applyWorkspaceEditParams.setEdit(workspaceEdit);
            this.ballerinaLanguageServer.getClient().applyEdit(applyWorkspaceEditParams);
            reply.setContent(textEditContent);
        }
        catch (Throwable e) {
            String msg = "Operation 'ballerinaDocument/astDidChange' failed!";
            LSClientLogger.logError((String)msg, (Throwable)e, (TextDocumentIdentifier)notification.getTextDocumentIdentifier(), (Position[])new Position[]{null});
        }
        finally {
            lock.ifPresent(Lock::unlock);
        }
        return CompletableFuture.supplyAsync(() -> reply);
    }

    @Override
    public CompletableFuture<BallerinaProject> project(BallerinaProjectParams params) {
        return CompletableFuture.supplyAsync(() -> {
            BallerinaProject project = new BallerinaProject();
            try {
                Optional<Path> filePath = CommonUtil.getPathFromURI(params.getDocumentIdentifier().getUri());
                if (!filePath.isPresent()) {
                    return project;
                }
                project.setPath(LSCompilerUtil.getProjectDir((Path)filePath.get()));
            }
            catch (Throwable e) {
                String msg = "Operation 'ballerinaDocument/project' failed!";
                LSClientLogger.logError((String)msg, (Throwable)e, (TextDocumentIdentifier)params.getDocumentIdentifier(), (Position[])new Position[]{null});
            }
            return project;
        });
    }

    private JsonElement getTreeForContent(LSContext context) throws JSONGenerationException {
        BLangPackage bLangPackage = (BLangPackage)context.get(DocumentServiceKeys.CURRENT_BLANG_PACKAGE_CONTEXT_KEY);
        CompilerContext compilerContext = (CompilerContext)context.get(DocumentServiceKeys.COMPILER_CONTEXT_KEY);
        VisibleEndpointVisitor visibleEndpointVisitor = new VisibleEndpointVisitor(compilerContext);
        if (bLangPackage.symbol != null) {
            visibleEndpointVisitor.visit(bLangPackage);
            Map<BLangNode, List<SymbolMetaInfo>> visibleEPsByNode = visibleEndpointVisitor.getVisibleEPsByNode();
            String relativeFilePath = (String)context.get(DocumentServiceKeys.RELATIVE_FILE_PATH_KEY);
            BLangCompilationUnit compilationUnit = bLangPackage.getCompilationUnits().stream().filter(cUnit -> cUnit.getPosition().getSource().cUnitName.replace("/", CommonUtil.FILE_SEPARATOR).equals(relativeFilePath)).findFirst().orElse(null);
            JsonElement jsonAST = TextDocumentFormatUtil.generateJSON((Node)compilationUnit, new HashMap(), visibleEPsByNode);
            FormattingSourceGen.build((JsonObject)jsonAST.getAsJsonObject(), (String)"CompilationUnit");
            return jsonAST;
        }
        return null;
    }

    private File getOpenApiFile(String oasDefinition) throws IOException {
        File oasTempFile = File.createTempFile("oasTempFile", ".json");
        try (BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(oasTempFile), StandardCharsets.UTF_8));){
            bw.write(oasDefinition);
        }
        return oasTempFile;
    }

    private void mergeAst(JsonObject targetCompUnit, JsonObject generatedCompUnit) {
        generatedCompUnit.getAsJsonArray("topLevelNodes").forEach(item -> {
            JsonObject topLevelNode = item.getAsJsonObject();
            if (topLevelNode.get("kind").getAsString().equals("Import") && !this.hasImport(targetCompUnit, topLevelNode)) {
                int startPosition = FormattingSourceGen.getStartPosition((JsonObject)targetCompUnit, (String)"imports", (int)-1);
                FormattingSourceGen.reconcileWS((JsonObject)topLevelNode, (JsonArray)targetCompUnit.getAsJsonArray("topLevelNodes"), (JsonObject)targetCompUnit, (int)startPosition);
                targetCompUnit.getAsJsonArray("topLevelNodes").add((JsonElement)topLevelNode);
            }
            if (topLevelNode.get("kind").getAsString().equals("Service")) {
                for (JsonElement astNode : targetCompUnit.getAsJsonArray("topLevelNodes")) {
                    JsonObject targetNode = astNode.getAsJsonObject();
                    if (!targetNode.get("kind").getAsString().equals("Service") || !targetNode.get("name").getAsJsonObject().get("value").equals(topLevelNode.get("name").getAsJsonObject().get("value"))) continue;
                    this.mergeServices(targetNode, topLevelNode, targetCompUnit);
                }
            }
        });
    }

    private void mergeServices(JsonObject originService, JsonObject targetService, JsonObject tree) {
        this.mergeAnnotations(originService, targetService, tree);
        ArrayList<JsonObject> targetServices = new ArrayList<JsonObject>();
        for (JsonElement targetItem : targetService.getAsJsonArray("resources")) {
            JsonObject targetResource = targetItem.getAsJsonObject();
            boolean matched = false;
            for (JsonElement originItem : originService.getAsJsonArray("resources")) {
                JsonObject originResource = originItem.getAsJsonObject();
                if (!this.matchResource(originResource, targetResource)) continue;
                matched = true;
                this.mergeAnnotations(originResource, targetResource, tree);
            }
            if (matched) continue;
            targetResource.getAsJsonObject("body").add("statements", (JsonElement)new JsonArray());
            targetServices.add(targetResource);
        }
        targetServices.forEach(resource -> {
            int startIndex = FormattingSourceGen.getStartPosition((JsonObject)originService, (String)"resources", (int)-1);
            FormattingSourceGen.reconcileWS((JsonObject)resource, (JsonArray)originService.getAsJsonArray("resources"), (JsonObject)tree, (int)startIndex);
            originService.getAsJsonArray("resources").add((JsonElement)resource);
        });
    }

    private void mergeAnnotations(JsonObject targetNode, JsonObject sourceNode, JsonObject tree) {
        JsonArray annotationAttachments = sourceNode.has("annotationAttachments") ? sourceNode.getAsJsonArray("annotationAttachments") : sourceNode.getAsJsonArray("annAttachments");
        for (JsonElement item : annotationAttachments) {
            JsonObject sourceNodeAttachment = item.getAsJsonObject();
            JsonObject matchedTargetNode = this.findAttachmentNode(targetNode, sourceNodeAttachment);
            if (matchedTargetNode != null) {
                if (!sourceNodeAttachment.getAsJsonObject("expression").get("kind").getAsString().equals("RecordLiteralExpr") || !matchedTargetNode.getAsJsonObject("expression").get("kind").getAsString().equals("RecordLiteralExpr")) continue;
                JsonObject sourceRecord = sourceNodeAttachment.getAsJsonObject("expression");
                JsonObject matchedTargetRecord = matchedTargetNode.getAsJsonObject("expression");
                if (sourceNodeAttachment.getAsJsonObject("annotationName").get("value").getAsString().equals("MultiResourceInfo")) {
                    JsonArray sourceResourceInformations = sourceRecord.getAsJsonArray("keyValuePairs").get(0).getAsJsonObject().getAsJsonObject("value").getAsJsonArray("keyValuePairs");
                    JsonArray targetResourceInformations = matchedTargetRecord.getAsJsonArray("keyValuePairs").get(0).getAsJsonObject().getAsJsonObject("value").getAsJsonArray("keyValuePairs");
                    for (JsonElement sourceResourceInfoItem : sourceResourceInformations) {
                        JsonObject sourceResourceInfo = sourceResourceInfoItem.getAsJsonObject();
                        JsonObject matchedTargetResourceInfo = null;
                        for (JsonElement targetResourceInfoItem : targetResourceInformations) {
                            JsonObject targetResourceInfo = targetResourceInfoItem.getAsJsonObject();
                            if (!targetResourceInfo.has("key") || !targetResourceInfo.getAsJsonObject("key").get("kind").getAsString().equals("Literal")) continue;
                            JsonObject targetResourceInfoKey = targetResourceInfo.getAsJsonObject("key");
                            JsonObject sourceResourceInfoKey = sourceResourceInfo.getAsJsonObject("key");
                            if (!sourceResourceInfoKey.get("value").getAsString().equals(targetResourceInfoKey.get("value").getAsString())) continue;
                            matchedTargetResourceInfo = targetResourceInfo;
                        }
                        if (matchedTargetResourceInfo != null) {
                            JsonArray sourceResourceInfoOperation = sourceResourceInfo.getAsJsonObject("value").getAsJsonArray("keyValuePairs");
                            JsonArray targetResourceInfoOperation = matchedTargetResourceInfo.getAsJsonObject("value").getAsJsonArray("keyValuePairs");
                            for (JsonElement keyValueItem : sourceResourceInfoOperation) {
                                JsonObject sourceKeyValue = keyValueItem.getAsJsonObject();
                                int matchedKeyValuePairIndex = 0;
                                JsonObject matchedObj = null;
                                for (JsonElement matchedKeyValueItem : targetResourceInfoOperation) {
                                    JsonObject matchedKeyValue = matchedKeyValueItem.getAsJsonObject();
                                    if (matchedKeyValue.has("key") && matchedKeyValue.getAsJsonObject("key").get("kind").getAsString().equals("SimpleVariableRef")) {
                                        JsonObject matchedKey = matchedKeyValue.getAsJsonObject("key");
                                        JsonObject sourceKey = sourceKeyValue.getAsJsonObject("key");
                                        if (matchedKey.getAsJsonObject("variableName").get("value").getAsString().equals(sourceKey.getAsJsonObject("variableName").get("value").getAsString())) {
                                            matchedObj = matchedKeyValue;
                                            break;
                                        }
                                    }
                                    ++matchedKeyValuePairIndex;
                                }
                                if (matchedObj != null) {
                                    List matchedObjWS = FormattingSourceGen.extractWS(matchedObj);
                                    int firstTokenIndex = ((JsonObject)matchedObjWS.get(0)).get("i").getAsInt();
                                    targetResourceInfoOperation.remove(matchedKeyValuePairIndex);
                                    FormattingSourceGen.reconcileWS((JsonObject)sourceKeyValue, (JsonArray)targetResourceInfoOperation, (JsonObject)tree, (int)firstTokenIndex);
                                    targetResourceInfoOperation.add((JsonElement)sourceKeyValue);
                                    continue;
                                }
                                FormattingSourceGen.reconcileWS((JsonObject)sourceKeyValue, (JsonArray)targetResourceInfoOperation, (JsonObject)tree, (int)-1);
                                targetResourceInfoOperation.add((JsonElement)sourceKeyValue);
                                if (targetResourceInfoOperation.size() <= 1) continue;
                                int startIndex = ((JsonObject)FormattingSourceGen.extractWS((JsonObject)sourceKeyValue).get(0)).getAsJsonObject().get("i").getAsInt();
                                FormattingSourceGen.addNewWS((JsonObject)matchedTargetResourceInfo.getAsJsonObject("value"), (JsonObject)tree, (String)"", (String)",", (boolean)true, (int)startIndex);
                            }
                            continue;
                        }
                        FormattingSourceGen.reconcileWS((JsonObject)sourceResourceInfo, (JsonArray)targetResourceInformations, (JsonObject)tree, (int)-1);
                        targetResourceInformations.add((JsonElement)sourceResourceInfo);
                    }
                    continue;
                }
                for (JsonElement keyValueItem : sourceRecord.getAsJsonArray("keyValuePairs")) {
                    JsonObject sourceKeyValue = keyValueItem.getAsJsonObject();
                    int matchedKeyValuePairIndex = 0;
                    JsonObject matchedObj = null;
                    for (JsonElement matchedKeyValueItem : matchedTargetRecord.getAsJsonArray("keyValuePairs")) {
                        JsonObject matchedKeyValue = matchedKeyValueItem.getAsJsonObject();
                        if (matchedKeyValue.has("key") && matchedKeyValue.getAsJsonObject("key").get("kind").getAsString().equals("SimpleVariableRef")) {
                            JsonObject matchedKey = matchedKeyValue.getAsJsonObject("key");
                            JsonObject sourceKey = sourceKeyValue.getAsJsonObject("key");
                            if (matchedKey.getAsJsonObject("variableName").get("value").getAsString().equals(sourceKey.getAsJsonObject("variableName").get("value").getAsString())) {
                                matchedObj = matchedKeyValue;
                                break;
                            }
                        }
                        ++matchedKeyValuePairIndex;
                    }
                    if (matchedObj != null) {
                        List matchedObjWS = FormattingSourceGen.extractWS(matchedObj);
                        int firstTokenIndex = ((JsonObject)matchedObjWS.get(0)).get("i").getAsInt();
                        matchedTargetRecord.getAsJsonArray("keyValuePairs").remove(matchedKeyValuePairIndex);
                        FormattingSourceGen.reconcileWS((JsonObject)sourceKeyValue, (JsonArray)matchedTargetRecord.getAsJsonArray("keyValuePairs"), (JsonObject)tree, (int)firstTokenIndex);
                        matchedTargetRecord.getAsJsonArray("keyValuePairs").add((JsonElement)sourceKeyValue);
                        continue;
                    }
                    FormattingSourceGen.reconcileWS((JsonObject)sourceKeyValue, (JsonArray)matchedTargetRecord.getAsJsonArray("keyValuePairs"), (JsonObject)tree, (int)-1);
                    matchedTargetRecord.getAsJsonArray("keyValuePairs").add((JsonElement)sourceKeyValue);
                    if (matchedTargetRecord.getAsJsonArray("keyValuePairs").size() <= 1) continue;
                    int startIndex = ((JsonObject)FormattingSourceGen.extractWS((JsonObject)sourceKeyValue).get(0)).getAsJsonObject().get("i").getAsInt();
                    FormattingSourceGen.addNewWS((JsonObject)matchedTargetRecord, (JsonObject)tree, (String)"", (String)",", (boolean)true, (int)startIndex);
                }
                continue;
            }
            int startIndex = FormattingSourceGen.getStartPosition((JsonObject)targetNode, (String)"annAttachments", (int)-1);
            JsonArray targetAnnAttachments = targetNode.has("annotationAttachments") ? targetNode.getAsJsonArray("annotationAttachments") : targetNode.getAsJsonArray("annAttachments");
            FormattingSourceGen.reconcileWS((JsonObject)sourceNodeAttachment, (JsonArray)targetAnnAttachments, (JsonObject)tree, (int)startIndex);
            targetAnnAttachments.add((JsonElement)sourceNodeAttachment);
        }
    }

    private JsonObject findAttachmentNode(JsonObject targetNode, JsonObject sourceNodeAttachment) {
        JsonObject matchedNode = null;
        JsonArray annotationAttachments = targetNode.has("annotationAttachments") ? targetNode.getAsJsonArray("annotationAttachments") : targetNode.getAsJsonArray("annAttachments");
        for (JsonElement item : annotationAttachments) {
            JsonObject attachmentNode = item.getAsJsonObject();
            if (!sourceNodeAttachment.getAsJsonObject("annotationName").get("value").getAsString().equals(attachmentNode.getAsJsonObject("annotationName").get("value").getAsString()) || !sourceNodeAttachment.getAsJsonObject("packageAlias").get("value").getAsString().equals(attachmentNode.getAsJsonObject("packageAlias").get("value").getAsString())) continue;
            matchedNode = attachmentNode;
            break;
        }
        return matchedNode;
    }

    private boolean matchResource(JsonObject astResource, JsonObject openApiResource) {
        return astResource.getAsJsonObject("name").get("value").getAsString().equals(openApiResource.getAsJsonObject("name").get("value").getAsString());
    }

    private boolean hasImport(JsonObject originAst, JsonObject mergePackage) {
        boolean importFound = false;
        block0: for (JsonElement node : originAst.getAsJsonArray("topLevelNodes")) {
            JsonObject originNode = node.getAsJsonObject();
            if (importFound) break;
            if (!originNode.get("kind").getAsString().equals("Import") || !originNode.get("orgName").getAsJsonObject().get("value").getAsString().equals(mergePackage.get("orgName").getAsJsonObject().get("value").getAsString()) || originNode.getAsJsonArray("packageName").size() != mergePackage.getAsJsonArray("packageName").size()) continue;
            JsonArray packageName = originNode.getAsJsonArray("packageName");
            for (int i = 0; i < packageName.size(); ++i) {
                JsonArray mergePackageName = mergePackage.getAsJsonArray("packageName");
                if (!mergePackageName.get(i).getAsJsonObject().get("value").getAsString().equals(packageName.get(i).getAsJsonObject().get("value").getAsString())) {
                    importFound = false;
                    continue block0;
                }
                importFound = true;
            }
        }
        return importFound;
    }
}

