/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.extensions.ballerina.project;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.ballerinalang.langserver.LSContextOperation;
import org.ballerinalang.langserver.LSGlobalContext;
import org.ballerinalang.langserver.LSGlobalContextKeys;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.commons.LSContext;
import org.ballerinalang.langserver.commons.workspace.WorkspaceDocumentManager;
import org.ballerinalang.langserver.compiler.DocumentServiceKeys;
import org.ballerinalang.langserver.compiler.LSModuleCompiler;
import org.ballerinalang.langserver.compiler.common.LSCustomErrorStrategy;
import org.ballerinalang.langserver.compiler.common.modal.SymbolMetaInfo;
import org.ballerinalang.langserver.compiler.exception.CompilationFailedException;
import org.ballerinalang.langserver.compiler.format.JSONGenerationException;
import org.ballerinalang.langserver.compiler.format.TextDocumentFormatUtil;
import org.ballerinalang.langserver.extensions.VisibleEndpointVisitor;
import org.ballerinalang.langserver.extensions.ballerina.project.BallerinaProjectService;
import org.ballerinalang.langserver.extensions.ballerina.project.ModulesRequest;
import org.ballerinalang.langserver.extensions.ballerina.project.ModulesResponse;
import org.ballerinalang.langserver.extensions.ballerina.project.ProjectServiceOperationContext;
import org.ballerinalang.model.tree.Node;
import org.wso2.ballerinalang.compiler.tree.BLangCompilationUnit;
import org.wso2.ballerinalang.compiler.tree.BLangNode;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;
import org.wso2.ballerinalang.compiler.util.CompilerContext;

public class BallerinaProjectServiceImpl
implements BallerinaProjectService {
    private final WorkspaceDocumentManager documentManager;

    public BallerinaProjectServiceImpl(LSGlobalContext globalContext) {
        this.documentManager = globalContext.get(LSGlobalContextKeys.DOCUMENT_MANAGER_KEY);
    }

    @Override
    public CompletableFuture<ModulesResponse> modules(ModulesRequest request) {
        return CompletableFuture.supplyAsync(() -> {
            ModulesResponse reply = new ModulesResponse();
            String sourceRoot = request.getSourceRoot();
            if (CommonUtil.isCachedExternalSource(sourceRoot)) {
                reply.setParseSuccess(false);
                return reply;
            }
            try {
                LSContext astContext = new ProjectServiceOperationContext.ProjectServiceContextBuilder(LSContextOperation.PROJ_MODULES).withModulesParams(sourceRoot, this.documentManager).build();
                List modules = LSModuleCompiler.getBLangModules((LSContext)astContext, (WorkspaceDocumentManager)this.documentManager, LSCustomErrorStrategy.class, (boolean)false);
                JsonObject jsonModulesInfo = this.getJsonReply(astContext, modules);
                reply.setModules((JsonElement)jsonModulesInfo);
                reply.setParseSuccess(true);
            }
            catch (URISyntaxException | CompilationFailedException | JSONGenerationException e) {
                reply.setParseSuccess(false);
            }
            return reply;
        });
    }

    private JsonObject getJsonReply(LSContext astContext, List<BLangPackage> modules) throws JSONGenerationException, URISyntaxException {
        JsonObject jsonModules = new JsonObject();
        for (BLangPackage module : modules) {
            JsonObject jsonModule = new JsonObject();
            if (module.symbol == null) continue;
            jsonModule.addProperty("name", module.symbol.name.value);
            CompilerContext compilerContext = (CompilerContext)astContext.get(DocumentServiceKeys.COMPILER_CONTEXT_KEY);
            VisibleEndpointVisitor visibleEndpointVisitor = new VisibleEndpointVisitor(compilerContext);
            visibleEndpointVisitor.visit(module);
            Map<BLangNode, List<SymbolMetaInfo>> visibleEPsByNode = visibleEndpointVisitor.getVisibleEPsByNode();
            JsonObject jsonCUnits = new JsonObject();
            List compilationUnits = module.getCompilationUnits();
            module.testablePkgs.forEach(bLangTestablePackage -> compilationUnits.addAll(bLangTestablePackage.getCompilationUnits()));
            for (BLangCompilationUnit cUnit : compilationUnits) {
                JsonObject jsonCUnit = new JsonObject();
                jsonCUnit.addProperty("name", cUnit.name);
                Path sourceRoot = Paths.get(new URI((String)astContext.get(DocumentServiceKeys.SOURCE_ROOT_KEY)));
                String uri = sourceRoot.resolve(Paths.get("src", module.getPosition().getSource().cUnitName, cUnit.getPosition().getSource().cUnitName)).toUri().toString();
                jsonCUnit.addProperty("uri", uri);
                JsonElement jsonAST = TextDocumentFormatUtil.generateJSON((Node)cUnit, new HashMap(), visibleEPsByNode);
                jsonCUnit.add("ast", jsonAST);
                jsonCUnits.add(cUnit.name, (JsonElement)jsonCUnit);
            }
            jsonModule.add("compilationUnits", (JsonElement)jsonCUnits);
            jsonModules.add(module.symbol.name.value, (JsonElement)jsonModule);
        }
        return jsonModules;
    }
}

