/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.extensions.ballerina.semantichighlighter;

import java.util.List;
import org.ballerinalang.langserver.common.LSNodeVisitor;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.commons.LSContext;
import org.ballerinalang.langserver.extensions.ballerina.semantichighlighter.ScopeEnum;
import org.ballerinalang.langserver.extensions.ballerina.semantichighlighter.SemanticHighlightProvider;
import org.ballerinalang.langserver.extensions.ballerina.semantichighlighter.SemanticHighlightingKeys;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.tree.BLangBlockFunctionBody;
import org.wso2.ballerinalang.compiler.tree.BLangFunction;
import org.wso2.ballerinalang.compiler.tree.BLangNode;
import org.wso2.ballerinalang.compiler.tree.BLangNodeVisitor;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;
import org.wso2.ballerinalang.compiler.tree.BLangSimpleVariable;
import org.wso2.ballerinalang.compiler.tree.BLangTypeDefinition;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangInvocation;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLambdaFunction;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangSimpleVarRef;
import org.wso2.ballerinalang.compiler.tree.statements.BLangAssignment;
import org.wso2.ballerinalang.compiler.tree.statements.BLangBlockStmt;
import org.wso2.ballerinalang.compiler.tree.statements.BLangForeach;
import org.wso2.ballerinalang.compiler.tree.statements.BLangIf;
import org.wso2.ballerinalang.compiler.tree.statements.BLangMatch;
import org.wso2.ballerinalang.compiler.tree.statements.BLangReturn;
import org.wso2.ballerinalang.compiler.tree.statements.BLangSimpleVariableDef;
import org.wso2.ballerinalang.compiler.tree.statements.BLangWhile;
import org.wso2.ballerinalang.compiler.tree.types.BLangObjectTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangRecordTypeNode;

class SemanticHighlightingVisitor
extends LSNodeVisitor {
    private final List<SemanticHighlightProvider.HighlightInfo> highlights;

    SemanticHighlightingVisitor(LSContext context) {
        this.highlights = (List)context.get(SemanticHighlightingKeys.SEMANTIC_HIGHLIGHTING_KEY);
    }

    @Override
    public void visit(BLangPackage pkgNode) {
        List topLevelNodes = pkgNode.topLevelNodes;
        topLevelNodes.forEach(topLevelNode -> this.acceptNode((BLangNode)topLevelNode));
    }

    @Override
    public void visit(BLangFunction funcNode) {
        funcNode.requiredParams.forEach(this::acceptNode);
        this.acceptNode((BLangNode)funcNode.body);
    }

    @Override
    public void visit(BLangRecordTypeNode recordTypeNode) {
        if (recordTypeNode.fields != null) {
            recordTypeNode.fields.forEach(this::acceptNode);
        }
    }

    @Override
    public void visit(BLangIf ifNode) {
        this.acceptNode((BLangNode)ifNode.body);
        this.acceptNode((BLangNode)ifNode.elseStmt);
    }

    @Override
    public void visit(BLangMatch matchNode) {
        matchNode.patternClauses.forEach(patternClause -> this.acceptNode((BLangNode)patternClause.body));
    }

    @Override
    public void visit(BLangForeach foreach) {
        this.acceptNode((BLangNode)foreach.body);
    }

    @Override
    public void visit(BLangWhile whileNode) {
        this.acceptNode((BLangNode)whileNode.body);
    }

    @Override
    public void visit(BLangBlockStmt blockNode) {
        blockNode.stmts.forEach(this::acceptNode);
    }

    @Override
    public void visit(BLangBlockFunctionBody blockFuncBody) {
        blockFuncBody.stmts.forEach(this::acceptNode);
    }

    @Override
    public void visit(BLangAssignment assignNode) {
        this.acceptNode((BLangNode)assignNode.varRef);
        this.acceptNode((BLangNode)assignNode.expr);
    }

    @Override
    public void visit(BLangTypeDefinition typeDefinition) {
        this.acceptNode((BLangNode)typeDefinition.typeNode);
    }

    @Override
    public void visit(BLangObjectTypeNode objectTypeNode) {
        if (objectTypeNode.fields != null) {
            objectTypeNode.fields.forEach(this::acceptNode);
        }
        if (objectTypeNode.functions != null) {
            objectTypeNode.functions.forEach(this::acceptNode);
        }
        if (objectTypeNode.initFunction != null) {
            this.acceptNode((BLangNode)objectTypeNode.initFunction);
        }
    }

    @Override
    public void visit(BLangSimpleVariableDef varDefNode) {
        this.acceptNode((BLangNode)varDefNode.var);
    }

    @Override
    public void visit(BLangLambdaFunction bLangLambdaFunction) {
        this.acceptNode((BLangNode)bLangLambdaFunction.function);
    }

    @Override
    public void visit(BLangSimpleVariable varNode) {
        if (CommonUtil.isClientObject((BSymbol)varNode.symbol)) {
            SemanticHighlightProvider.HighlightInfo highlightInfo = new SemanticHighlightProvider.HighlightInfo(ScopeEnum.ENDPOINT, varNode.name);
            this.highlights.add(highlightInfo);
            return;
        }
        if (varNode.expr != null) {
            this.acceptNode((BLangNode)varNode.expr);
        }
    }

    @Override
    public void visit(BLangSimpleVarRef varRefExpr) {
        if (!CommonUtil.isClientObject(varRefExpr.symbol)) {
            return;
        }
        SemanticHighlightProvider.HighlightInfo highlightInfo = new SemanticHighlightProvider.HighlightInfo(ScopeEnum.ENDPOINT, varRefExpr.variableName);
        this.highlights.add(highlightInfo);
    }

    @Override
    public void visit(BLangInvocation invocationExpr) {
        this.acceptNode((BLangNode)invocationExpr.expr);
    }

    @Override
    public void visit(BLangReturn returnNode) {
        this.acceptNode((BLangNode)returnNode.expr);
    }

    private void acceptNode(BLangNode node) {
        if (node != null) {
            node.accept((BLangNodeVisitor)this);
        }
    }
}

