/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.extensions.ballerina.traces;

import com.google.gson.JsonObject;
import java.util.UUID;
import org.ballerinalang.langserver.extensions.ballerina.traces.Message;

public class TraceRecord {
    private Message message;
    private String rawMessage;
    private String id;
    private String millis;
    private String sequence;
    private String logger;
    private String sourceClass;
    private String sourceMethod;
    private String thread;

    TraceRecord(Message message, JsonObject record, String rawMessage) {
        this.message = message;
        this.rawMessage = rawMessage;
        this.id = UUID.randomUUID().toString();
        this.millis = record.get("millis").getAsString();
        this.sequence = record.get("sequenceNumber").getAsString();
        this.logger = record.get("loggerName").getAsString();
        this.sourceClass = record.get("sourceClassName").getAsString();
        this.sourceMethod = record.get("sourceMethodName").getAsString();
        this.thread = record.get("threadID").getAsString();
    }

    public String getRawMessage() {
        return this.rawMessage;
    }

    public String getLogger() {
        return this.logger;
    }

    public String getSequence() {
        return this.sequence;
    }

    public String getThread() {
        return this.thread;
    }

    public String getMillis() {
        return this.millis;
    }

    public String getSourceMethod() {
        return this.sourceMethod;
    }

    public String getSourceClass() {
        return this.sourceClass;
    }

    public Message getMessage() {
        return this.message;
    }

    public String getId() {
        return this.id;
    }
}

