/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.signature;

import java.lang.reflect.Field;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Stack;
import java.util.StringJoiner;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.CommonToken;
import org.antlr.v4.runtime.Token;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.ballerinalang.compiler.CompilerPhase;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.common.utils.FilterUtils;
import org.ballerinalang.langserver.commons.LSContext;
import org.ballerinalang.langserver.commons.workspace.WorkspaceDocumentException;
import org.ballerinalang.langserver.commons.workspace.WorkspaceDocumentManager;
import org.ballerinalang.langserver.compiler.DocumentServiceKeys;
import org.ballerinalang.langserver.compiler.ExtendedLSCompiler;
import org.ballerinalang.langserver.compiler.exception.CompilationFailedException;
import org.ballerinalang.langserver.completions.util.SourcePruneException;
import org.ballerinalang.langserver.signature.SignatureKeys;
import org.ballerinalang.langserver.signature.sourceprune.SignatureTokenTraverserFactory;
import org.ballerinalang.langserver.sourceprune.SourcePruneKeys;
import org.ballerinalang.langserver.sourceprune.SourcePruner;
import org.ballerinalang.model.elements.MarkdownDocAttachment;
import org.ballerinalang.model.symbols.SymbolKind;
import org.ballerinalang.model.tree.IdentifierNode;
import org.eclipse.lsp4j.MarkupContent;
import org.eclipse.lsp4j.ParameterInformation;
import org.eclipse.lsp4j.SignatureHelpCapabilities;
import org.eclipse.lsp4j.SignatureInformation;
import org.eclipse.lsp4j.SignatureInformationCapabilities;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.wso2.ballerinalang.compiler.semantics.analyzer.Types;
import org.wso2.ballerinalang.compiler.semantics.model.Scope;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BInvokableSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BObjectTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BRecordTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BVarSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;
import org.wso2.ballerinalang.compiler.semantics.model.types.BErrorType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BNilType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BRecordType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BUnionType;
import org.wso2.ballerinalang.compiler.tree.BLangBlockFunctionBody;
import org.wso2.ballerinalang.compiler.tree.BLangCompilationUnit;
import org.wso2.ballerinalang.compiler.tree.BLangFunction;
import org.wso2.ballerinalang.compiler.tree.BLangImportPackage;
import org.wso2.ballerinalang.compiler.tree.BLangNode;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangFieldBasedAccess;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangInvocation;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangSimpleVarRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypeInit;
import org.wso2.ballerinalang.compiler.tree.statements.BLangExpressionStmt;
import org.wso2.ballerinalang.compiler.tree.statements.BLangSimpleVariableDef;
import org.wso2.ballerinalang.compiler.tree.statements.BLangStatement;
import org.wso2.ballerinalang.compiler.tree.types.BLangUserDefinedType;
import org.wso2.ballerinalang.compiler.util.CompilerContext;

public class SignatureHelpUtil {
    private static final String COMMA = ",";
    private static final String SEMI_COLON = ";";
    private static final String EQUAL = "=";
    private static final String INIT_SYMBOL = ".__init";

    private SignatureHelpUtil() {
    }

    public static Pair<Optional<String>, Integer> getFunctionInvocationDetails(LSContext serviceContext) throws CompilationFailedException {
        Pair<String, Integer> functionInvocationAndParamOffset = SignatureHelpUtil.extractSourcePrunedInvocationDetails(serviceContext);
        String funcInvocation = (String)functionInvocationAndParamOffset.getLeft();
        int paramIndex = (Integer)functionInvocationAndParamOffset.getRight();
        int equalSymbolIndex = funcInvocation.lastIndexOf(EQUAL);
        String funcInvocationStatement = funcInvocation;
        if (equalSymbolIndex > -1) {
            funcInvocation = funcInvocation.substring(equalSymbolIndex + 1);
        }
        String subRuleFormat = "function rightHandExpr() {\n\t%s;\n}".replaceAll("\\n", CommonUtil.LINE_SEPARATOR);
        subRuleFormat = subRuleFormat + "function wholeStatement() {\n\t%s;\n}".replaceAll("\\n", CommonUtil.LINE_SEPARATOR);
        String subRule = String.format(subRuleFormat, funcInvocation, funcInvocationStatement);
        return new ImmutablePair(SignatureHelpUtil.parseAndGetFunctionInvocationPath(subRule, serviceContext), (Object)paramIndex);
    }

    private static Pair<String, Integer> extractSourcePrunedInvocationDetails(LSContext context) {
        int lastIndex;
        int parameterOffset = 0;
        ArrayList<String> tokenTexts = new ArrayList<String>();
        int[] pendingRParenthesisCount = new int[]{0};
        Consumer<Integer> tokenAcceptor = type -> {
            if (type == 101) {
                pendingRParenthesisCount[0] = pendingRParenthesisCount[0] - 1;
            } else if (type == 102) {
                pendingRParenthesisCount[0] = pendingRParenthesisCount[0] + 1;
            }
        };
        List lhsTokens = (List)context.get(SourcePruneKeys.LHS_TOKENS_KEY);
        if (lhsTokens != null) {
            while (((CommonToken)lhsTokens.get(0)).getType() == 98) {
                lhsTokens.remove(0);
            }
            boolean isLastLeftParenthesisProcessed = false;
            for (int i = lhsTokens.size() - 1; i >= 0; --i) {
                Token commonToken = (Token)lhsTokens.get(i);
                int tokenType = commonToken.getType();
                if (tokenType == 101) {
                    isLastLeftParenthesisProcessed = true;
                }
                if (tokenType == 98) {
                    if (i - 1 >= 0 && ((CommonToken)lhsTokens.get(i - 1)).getType() == 102) {
                        parameterOffset = 1;
                        continue;
                    }
                    tokenTexts.add(commonToken.getText());
                    if (pendingRParenthesisCount[0] != 0 || isLastLeftParenthesisProcessed) continue;
                    ++parameterOffset;
                    continue;
                }
                tokenAcceptor.accept(tokenType);
                tokenTexts.add(commonToken.getText());
            }
        }
        Collections.reverse(tokenTexts);
        List rhsTokens = (List)context.get(SourcePruneKeys.RHS_TOKENS_KEY);
        if (rhsTokens != null && !rhsTokens.isEmpty()) {
            Token commonToken;
            int tokenType;
            for (lastIndex = tokenTexts.size() - 1; lastIndex >= 0 && COMMA.equals(tokenTexts.get(lastIndex)) && ((CommonToken)rhsTokens.get(0)).getType() == 102; --lastIndex) {
                tokenTexts.remove(lastIndex);
            }
            Iterator iterator = rhsTokens.iterator();
            while (iterator.hasNext() && (tokenType = (commonToken = (Token)iterator.next()).getType()) != 169 && tokenType != 170) {
                tokenAcceptor.accept(commonToken.getType());
                tokenTexts.add(commonToken.getText());
            }
        }
        if (COMMA.equals(tokenTexts.get(lastIndex = tokenTexts.size() - 1)) && pendingRParenthesisCount[0] <= 0) {
            tokenTexts.remove(lastIndex);
        }
        if (SEMI_COLON.equals(tokenTexts.get(lastIndex = tokenTexts.size() - 1))) {
            tokenTexts.remove(lastIndex);
        }
        while (pendingRParenthesisCount[0] < 0) {
            tokenTexts.add(")");
            pendingRParenthesisCount[0] = pendingRParenthesisCount[0] + 1;
        }
        return Pair.of((Object)String.join((CharSequence)"", tokenTexts), (Object)parameterOffset);
    }

    private static Optional<String> parseAndGetFunctionInvocationPath(String subRule, LSContext context) throws CompilationFailedException {
        Optional bLangPackage = ExtendedLSCompiler.compileContent((String)(subRule = subRule.replaceAll("\\?.", ".")), (CompilerPhase)CompilerPhase.CODE_ANALYZE).getBLangPackage();
        if (!bLangPackage.isPresent()) {
            return Optional.empty();
        }
        List topLevelNodes = ((BLangCompilationUnit)((BLangPackage)bLangPackage.get()).getCompilationUnits().get(0)).getTopLevelNodes();
        if (topLevelNodes.isEmpty()) {
            return Optional.empty();
        }
        BLangStatement evalStatement = (BLangStatement)((BLangBlockFunctionBody)((BLangFunction)topLevelNodes.get((int)0)).body).stmts.get(0);
        if (evalStatement instanceof BLangExpressionStmt && ((BLangExpressionStmt)evalStatement).expr instanceof BLangTypeInit && topLevelNodes.size() >= 2) {
            BLangStatement stmt = (BLangStatement)((BLangBlockFunctionBody)((BLangFunction)topLevelNodes.get((int)1)).body).stmts.get(0);
            if (stmt instanceof BLangSimpleVariableDef) {
                BLangSimpleVariableDef varDef = (BLangSimpleVariableDef)stmt;
                if (varDef.var.typeNode instanceof BLangUserDefinedType) {
                    BLangUserDefinedType typeNode = (BLangUserDefinedType)varDef.var.typeNode;
                    return Optional.of(SignatureHelpUtil.addPackagePrefix((IdentifierNode)typeNode.pkgAlias, context, typeNode.typeName + INIT_SYMBOL));
                }
                return Optional.of(varDef.var.typeNode.toString() + INIT_SYMBOL);
            }
            if (stmt instanceof BLangExpressionStmt && ((BLangExpressionStmt)stmt).expr instanceof BLangTypeInit) {
                BLangTypeInit bLangTypeInit = (BLangTypeInit)((BLangExpressionStmt)stmt).expr;
                if (bLangTypeInit.type.tag != 14) {
                    BLangUserDefinedType type = (BLangUserDefinedType)bLangTypeInit.userDefinedType;
                    return Optional.of(SignatureHelpUtil.addPackagePrefix((IdentifierNode)type.pkgAlias, context, type.typeName + INIT_SYMBOL));
                }
            }
        }
        return SignatureHelpUtil.resolveSymbolPath(context, (BLangNode)evalStatement, new Stack<String>());
    }

    private static Optional<String> resolveSymbolPath(LSContext context, BLangNode bLangNode, Stack<String> path) {
        if (bLangNode instanceof BLangInvocation) {
            BLangInvocation invocationNode = (BLangInvocation)bLangNode;
            String value = SignatureHelpUtil.getFullyQualifiedName(invocationNode, context);
            path.push(value);
            return SignatureHelpUtil.resolveSymbolPath(context, (BLangNode)invocationNode.getExpression(), path);
        }
        if (bLangNode instanceof BLangSimpleVarRef) {
            path.push(((BLangSimpleVarRef)bLangNode).variableName.value);
        } else {
            BLangExpression innerExpression;
            if (bLangNode instanceof BLangFieldBasedAccess) {
                path.push(((BLangFieldBasedAccess)bLangNode).field.value);
            }
            if ((innerExpression = SignatureHelpUtil.getInnerExpression(bLangNode)) != null) {
                return SignatureHelpUtil.resolveSymbolPath(context, (BLangNode)innerExpression, path);
            }
        }
        StringJoiner pathStr = new StringJoiner(".");
        while (!path.empty()) {
            pathStr.add(path.pop());
        }
        return Optional.of(pathStr.toString());
    }

    private static BLangExpression getInnerExpression(BLangNode node) {
        try {
            if (node == null) {
                return null;
            }
            HashMap<Field, BLangExpression> exprs = new HashMap<Field, BLangExpression>();
            for (Field field : node.getClass().getFields()) {
                Object obj = field.get(node);
                if (!(obj instanceof BLangExpression) || field.getName().equals("parent")) continue;
                exprs.put(field, (BLangExpression)obj);
            }
            if (!exprs.isEmpty()) {
                Comparator<Map.Entry> byExpr = Comparator.comparing(e -> "expr".equals(((Field)e.getKey()).getName()));
                Comparator<Map.Entry> byStartsWithExpr = Comparator.comparing(e -> ((Field)e.getKey()).getName().startsWith("expr"));
                return exprs.entrySet().stream().sorted(byStartsWithExpr).max(byExpr).map(Map.Entry::getValue).orElse(null);
            }
            return null;
        }
        catch (IllegalAccessException | IllegalArgumentException e2) {
            return null;
        }
    }

    public static Optional<Scope.ScopeEntry> getFuncScopeEntry(LSContext context, String funcName, List<Scope.ScopeEntry> visibleSymbols) {
        CompilerContext compilerContext = (CompilerContext)context.get(DocumentServiceKeys.COMPILER_CONTEXT_KEY);
        SymbolTable symbolTable = SymbolTable.getInstance((CompilerContext)compilerContext);
        Types types = Types.getInstance((CompilerContext)compilerContext);
        String[] nameComps = funcName.split("\\.");
        Optional<Scope.ScopeEntry> searchSymbol = Optional.empty();
        for (int index = 0; index < nameComps.length; ++index) {
            BUnionType bUnionType;
            ArrayList memberTypes;
            BTypeSymbol typeSymbol;
            BObjectTypeSymbol objectTypeSymbol;
            boolean hasNextNameComp;
            boolean hasPkgPrefix;
            String name = nameComps[index];
            int pkgPrefix = name.indexOf(":");
            boolean bl = hasPkgPrefix = pkgPrefix > -1;
            if (!hasPkgPrefix) {
                searchSymbol = visibleSymbols.stream().filter(symbol -> name.equals(CommonUtil.getLastItem(symbol.symbol.name.getValue().split("\\.")))).findFirst();
            } else {
                String[] moduleComps = name.substring(0, pkgPrefix).split("/");
                String alias = moduleComps[1].split(" ")[0];
                Optional<Scope.ScopeEntry> moduleSymbol = visibleSymbols.stream().filter(entry -> entry.symbol.name.getValue().equals(alias)).findFirst();
                visibleSymbols = new ArrayList(moduleSymbol.get().symbol.scope.entries.values());
                searchSymbol = visibleSymbols.stream().filter(entry -> name.substring(pkgPrefix + 1).equals(CommonUtil.getLastItem(entry.symbol.name.getValue().split("\\.")))).findFirst();
            }
            if (!searchSymbol.isPresent()) break;
            boolean isInvocation = searchSymbol.get().symbol instanceof BInvokableSymbol;
            boolean isObject = searchSymbol.get().symbol instanceof BObjectTypeSymbol;
            boolean isVariable = searchSymbol.get().symbol instanceof BVarSymbol;
            boolean bl2 = hasNextNameComp = index + 1 < nameComps.length;
            if (isInvocation && hasNextNameComp) {
                BInvokableSymbol invokableSymbol = (BInvokableSymbol)searchSymbol.get().symbol;
                BTypeSymbol returnTypeSymbol = invokableSymbol.getReturnType().tsymbol;
                if (!(returnTypeSymbol instanceof BObjectTypeSymbol)) continue;
                objectTypeSymbol = (BObjectTypeSymbol)returnTypeSymbol;
                visibleSymbols = new ArrayList(objectTypeSymbol.methodScope.entries.values());
                continue;
            }
            if (isObject && hasNextNameComp) {
                BObjectTypeSymbol bObjectTypeSymbol = (BObjectTypeSymbol)searchSymbol.get().symbol;
                typeSymbol = bObjectTypeSymbol.type.tsymbol;
                if (!(typeSymbol instanceof BObjectTypeSymbol)) continue;
                objectTypeSymbol = (BObjectTypeSymbol)typeSymbol;
                visibleSymbols = new ArrayList(objectTypeSymbol.methodScope.entries.values());
                continue;
            }
            if (!isVariable || !hasNextNameComp) continue;
            BVarSymbol bVarSymbol = (BVarSymbol)searchSymbol.get().symbol;
            typeSymbol = bVarSymbol.type.tsymbol;
            if (typeSymbol.type instanceof BUnionType && (memberTypes = new ArrayList((bUnionType = (BUnionType)typeSymbol.type).getMemberTypes())).size() == 2) {
                boolean isLeftNil = memberTypes.get(0) instanceof BNilType;
                boolean isRightNil = memberTypes.get(1) instanceof BNilType;
                if (isLeftNil || isRightNil) {
                    BTypeSymbol bTypeSymbol = typeSymbol = isLeftNil ? ((BType)memberTypes.get((int)1)).tsymbol : ((BType)memberTypes.get((int)0)).tsymbol;
                }
            }
            if (typeSymbol instanceof BObjectTypeSymbol) {
                objectTypeSymbol = (BObjectTypeSymbol)typeSymbol;
                visibleSymbols = new ArrayList(objectTypeSymbol.methodScope.entries.values());
                visibleSymbols.addAll(objectTypeSymbol.scope.entries.values());
                continue;
            }
            if (typeSymbol instanceof BRecordTypeSymbol) {
                BRecordTypeSymbol bRecordTypeSymbol = (BRecordTypeSymbol)typeSymbol;
                visibleSymbols = new ArrayList(bRecordTypeSymbol.scope.entries.values());
                continue;
            }
            visibleSymbols = new ArrayList<Scope.ScopeEntry>(FilterUtils.getLangLibScopeEntries(typeSymbol.type, symbolTable, types).values());
        }
        return searchSymbol;
    }

    public static SignatureInformation getSignatureInformation(BInvokableSymbol bInvokableSymbol, LSContext context) {
        ArrayList parameterInformationList = new ArrayList();
        SignatureInformation signatureInformation = new SignatureInformation();
        SignatureInfoModel signatureInfoModel = SignatureHelpUtil.getSignatureInfoModel(bInvokableSymbol, context);
        String label = bInvokableSymbol.name.value;
        int initIndex = label.indexOf(INIT_SYMBOL);
        if (initIndex > -1) {
            label = "new " + label.substring(0, initIndex);
        }
        String paramsJoined = signatureInfoModel.getParameterInfoModels().stream().map(parameterInfoModel -> {
            parameterInformationList.add(SignatureHelpUtil.getParameterInformation(parameterInfoModel));
            return parameterInfoModel.toString();
        }).collect(Collectors.joining(", "));
        signatureInformation.setLabel(label + "(" + paramsJoined + ")");
        signatureInformation.setParameters(parameterInformationList);
        signatureInformation.setDocumentation(signatureInfoModel.signatureDescription);
        return signatureInformation;
    }

    private static String getFullyQualifiedName(BLangInvocation bLangInvocation, LSContext context) {
        String result = bLangInvocation.getName().getValue();
        return SignatureHelpUtil.addPackagePrefix(bLangInvocation.getPackageAlias(), context, result);
    }

    private static String addPackagePrefix(IdentifierNode identifierNode, LSContext context, String nodeName) {
        String pkgAlias = identifierNode.getValue();
        if (!pkgAlias.isEmpty()) {
            Optional<BLangImportPackage> optImport = CommonUtil.getCurrentFileImports(context).stream().filter(p -> pkgAlias.equals(p.alias.value)).findFirst();
            nodeName = optImport.map(pkg -> pkg.getQualifiedPackageName() + ":").orElse("") + nodeName;
        }
        return nodeName;
    }

    private static SignatureInfoModel getSignatureInfoModel(BInvokableSymbol bInvokableSymbol, LSContext signatureCtx) {
        HashMap paramToDesc = new HashMap();
        SignatureInfoModel signatureInfoModel = new SignatureInfoModel();
        ArrayList<ParameterInfoModel> paramModels = new ArrayList<ParameterInfoModel>();
        MarkdownDocAttachment docAttachment = bInvokableSymbol.getMarkdownDocAttachment();
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        if (bInvokableSymbol.kind == SymbolKind.ERROR_CONSTRUCTOR) {
            docAttachment = bInvokableSymbol.type.tsymbol.markdownDocumentation;
            if (bInvokableSymbol.type instanceof BErrorType) {
                boolean isDirectErrorConstructor;
                BErrorType bErrorType = (BErrorType)bInvokableSymbol.type;
                boolean bl = isDirectErrorConstructor = bInvokableSymbol.type.tsymbol.kind == null;
                if (isDirectErrorConstructor) {
                    BType reasonType = bErrorType.reasonType;
                    parameters.add(new Parameter(" ", reasonType, false, false));
                }
                if (bErrorType.detailType instanceof BRecordType) {
                    BRecordType bRecordType = (BRecordType)bErrorType.detailType;
                    bRecordType.fields.forEach(p -> {
                        BVarSymbol symbol = p.symbol;
                        parameters.add(new Parameter(symbol.name.getValue(), symbol.type, Symbols.isOptional((BSymbol)symbol), false));
                    });
                    BType restFieldType = bRecordType.restFieldType;
                    if (restFieldType != null) {
                        parameters.add(new Parameter(restFieldType.name.getValue(), restFieldType, false, true));
                    }
                }
            }
        }
        if (docAttachment != null) {
            if (docAttachment.description != null) {
                signatureInfoModel.setSignatureDescription(docAttachment.description.trim(), signatureCtx);
            }
            docAttachment.parameters.forEach(attribute -> paramToDesc.put(attribute.getName(), attribute.getDescription()));
        }
        bInvokableSymbol.getParameters().forEach(p -> parameters.add(new Parameter(p.name.value, p.type, Symbols.isOptional((BSymbol)p), false)));
        BVarSymbol restParam = bInvokableSymbol.restParam;
        if (restParam != null) {
            parameters.add(new Parameter(restParam.name.value, restParam.type, false, true));
        }
        parameters.forEach(param -> {
            String name = ((Parameter)param).isOptional ? ((Parameter)param).name + "?" : ((Parameter)param).name;
            String desc = "";
            if (paramToDesc.containsKey(((Parameter)param).name)) {
                desc = (String)paramToDesc.get(((Parameter)param).name);
            }
            String type = CommonUtil.getBTypeName(((Parameter)param).type, signatureCtx, true);
            if (((Parameter)param).isRestArg && !"".equals(type)) {
                if (type.contains("[]")) {
                    type = type.substring(0, type.length() - 2);
                }
                type = type + "...";
            }
            paramModels.add(new ParameterInfoModel(name, type, desc));
        });
        signatureInfoModel.setParameterInfoModels(paramModels);
        return signatureInfoModel;
    }

    private static ParameterInformation getParameterInformation(ParameterInfoModel parameterInfoModel) {
        MarkupContent paramDocumentation = new MarkupContent();
        paramDocumentation.setKind("markdown");
        String type = parameterInfoModel.paramType;
        String markupContent = "**Parameter**" + CommonUtil.MD_LINE_SEPARATOR;
        markupContent = markupContent + "**" + (!type.isEmpty() ? "`" + type + "`" : "");
        markupContent = markupContent + parameterInfoModel.paramValue + "**: ";
        paramDocumentation.setValue(markupContent + parameterInfoModel.description);
        return new ParameterInformation(parameterInfoModel.toString(), paramDocumentation);
    }

    public static void pruneSource(LSContext lsContext) throws SourcePruneException, WorkspaceDocumentException {
        WorkspaceDocumentManager documentManager = (WorkspaceDocumentManager)lsContext.get(DocumentServiceKeys.DOC_MANAGER_KEY);
        String uri = (String)lsContext.get(DocumentServiceKeys.FILE_URI_KEY);
        if (uri == null) {
            throw new SourcePruneException("fileUri cannot be null!");
        }
        Path filePath = Paths.get(URI.create(uri));
        SignatureTokenTraverserFactory tokenTraverserFactory = new SignatureTokenTraverserFactory(filePath, documentManager, SourcePruner.newContext());
        SourcePruner.pruneSource(lsContext, tokenTraverserFactory);
        documentManager.setPrunedContent(filePath, tokenTraverserFactory.getTokenStream().getText());
    }

    private static class SignatureInfoModel {
        private List<ParameterInfoModel> parameterInfoModels;
        private Either<String, MarkupContent> signatureDescription;

        private SignatureInfoModel() {
        }

        List<ParameterInfoModel> getParameterInfoModels() {
            return this.parameterInfoModels;
        }

        void setParameterInfoModels(List<ParameterInfoModel> parameterInfoModels) {
            this.parameterInfoModels = parameterInfoModels;
        }

        void setSignatureDescription(String signatureDescription, LSContext signatureContext) {
            List documentationFormat;
            SignatureInformationCapabilities capabilities = ((SignatureHelpCapabilities)signatureContext.get(SignatureKeys.SIGNATURE_HELP_CAPABILITIES_KEY)).getSignatureInformation();
            List list = documentationFormat = capabilities != null ? capabilities.getDocumentationFormat() : new ArrayList();
            if (documentationFormat != null && !documentationFormat.isEmpty() && ((String)documentationFormat.get(0)).equals("markdown")) {
                MarkupContent signatureMarkupContent = new MarkupContent();
                signatureMarkupContent.setKind("markdown");
                signatureMarkupContent.setValue("**Description**" + CommonUtil.MD_LINE_SEPARATOR + signatureDescription);
                this.signatureDescription = Either.forRight((Object)signatureMarkupContent);
            } else {
                this.signatureDescription = Either.forLeft((Object)("Description" + CommonUtil.LINE_SEPARATOR + signatureDescription));
            }
        }
    }

    private static class ParameterInfoModel {
        private final String paramValue;
        private final String paramType;
        private final String description;

        public ParameterInfoModel(String name, String type, String desc) {
            this.paramValue = name;
            this.paramType = type;
            this.description = desc;
        }

        public String toString() {
            return this.paramType + " " + this.paramValue;
        }
    }

    private static class Parameter {
        private final String name;
        private final BType type;
        private final boolean isRestArg;
        private final boolean isOptional;

        public Parameter(String name, BType type, boolean isOptional, boolean isRestArg) {
            this.name = name;
            this.type = type;
            this.isOptional = isOptional;
            this.isRestArg = isRestArg;
        }
    }
}

