/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.symbols;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.ballerinalang.langserver.common.LSNodeVisitor;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.commons.LSContext;
import org.ballerinalang.langserver.compiler.DocumentServiceKeys;
import org.eclipse.lsp4j.DocumentSymbol;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.SymbolKind;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.tree.BLangBlockFunctionBody;
import org.wso2.ballerinalang.compiler.tree.BLangCompilationUnit;
import org.wso2.ballerinalang.compiler.tree.BLangFunction;
import org.wso2.ballerinalang.compiler.tree.BLangNode;
import org.wso2.ballerinalang.compiler.tree.BLangNodeVisitor;
import org.wso2.ballerinalang.compiler.tree.BLangService;
import org.wso2.ballerinalang.compiler.tree.BLangSimpleVariable;
import org.wso2.ballerinalang.compiler.tree.BLangTypeDefinition;
import org.wso2.ballerinalang.compiler.tree.BLangWorker;
import org.wso2.ballerinalang.compiler.tree.BLangXMLNS;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangConstant;
import org.wso2.ballerinalang.compiler.tree.statements.BLangBlockStmt;
import org.wso2.ballerinalang.compiler.tree.statements.BLangSimpleVariableDef;
import org.wso2.ballerinalang.compiler.tree.types.BLangObjectTypeNode;

public class SymbolFindingVisitor
extends LSNodeVisitor {
    private List<Either<SymbolInformation, DocumentSymbol>> symbols;
    private String uri;
    private String query;

    public SymbolFindingVisitor(LSContext documentServiceContext) {
        this.symbols = (List)documentServiceContext.get(DocumentServiceKeys.SYMBOL_LIST_KEY);
        this.uri = (String)documentServiceContext.get(DocumentServiceKeys.FILE_URI_KEY);
        this.query = (String)documentServiceContext.get(DocumentServiceKeys.SYMBOL_QUERY);
    }

    @Override
    public void visit(BLangCompilationUnit compUnit) {
        compUnit.getTopLevelNodes().stream().filter(CommonUtil.checkInvalidTypesDefs()).forEach(node -> ((BLangNode)node).accept((BLangNodeVisitor)this));
    }

    @Override
    public void visit(BLangFunction funcNode) {
        SymbolKind symbolKind = SymbolKind.Function;
        if ("new".equals(funcNode.name.value) || !funcNode.hasBody()) {
            return;
        }
        this.addSymbol((BLangNode)funcNode, (BSymbol)funcNode.symbol, symbolKind);
        if (!funcNode.getWorkers().isEmpty()) {
            funcNode.getWorkers().forEach(bLangWorker -> bLangWorker.accept((BLangNodeVisitor)this));
            return;
        }
        funcNode.body.accept((BLangNodeVisitor)this);
    }

    @Override
    public void visit(BLangTypeDefinition typeDefinition) {
        this.addSymbol((BLangNode)typeDefinition, (BSymbol)typeDefinition.symbol, SymbolKind.Class);
        typeDefinition.typeNode.accept((BLangNodeVisitor)this);
    }

    @Override
    public void visit(BLangConstant constant) {
        this.addSymbol((BLangNode)constant, (BSymbol)constant.symbol, SymbolKind.Class);
        constant.typeNode.accept((BLangNodeVisitor)this);
    }

    @Override
    public void visit(BLangObjectTypeNode objectTypeNode) {
        if (objectTypeNode.initFunction != null) {
            this.visit(objectTypeNode.initFunction);
        }
        objectTypeNode.fields.forEach(field -> this.addSymbol((BLangNode)field, (BSymbol)field.symbol, SymbolKind.Field));
        objectTypeNode.functions.forEach(this::visit);
    }

    @Override
    public void visit(BLangService serviceNode) {
        this.addSymbol((BLangNode)serviceNode, serviceNode.symbol, SymbolKind.Class);
        BLangObjectTypeNode serviceType = (BLangObjectTypeNode)serviceNode.serviceTypeDefinition.typeNode;
        ArrayList<Object> serviceContent = new ArrayList<Object>();
        List serviceFunctions = ((BLangObjectTypeNode)serviceNode.serviceTypeDefinition.typeNode).getFunctions();
        List serviceFields = serviceType.getFields().stream().map(simpleVar -> (BLangSimpleVariable)simpleVar).collect(Collectors.toList());
        serviceContent.addAll(serviceFunctions);
        serviceContent.addAll(serviceFields);
        serviceContent.sort(new CommonUtil.BLangNodeComparator());
        serviceContent.forEach(serviceField -> serviceField.accept((BLangNodeVisitor)this));
    }

    @Override
    public void visit(BLangSimpleVariable variableNode) {
        SymbolKind kind;
        String btype = "";
        if (variableNode.getTypeNode() != null) {
            btype = variableNode.getTypeNode().toString();
        } else if (variableNode.symbol != null) {
            btype = variableNode.symbol.type.toString();
        }
        switch (btype) {
            case "boolean": {
                kind = SymbolKind.Boolean;
                break;
            }
            case "int": {
                kind = SymbolKind.Number;
                break;
            }
            case "float": {
                kind = SymbolKind.Number;
                break;
            }
            case "string": {
                kind = SymbolKind.String;
                break;
            }
            case "package": {
                kind = SymbolKind.Package;
                break;
            }
            default: {
                kind = btype.endsWith("[]") ? SymbolKind.Array : SymbolKind.Variable;
            }
        }
        this.addSymbol((BLangNode)variableNode, (BSymbol)variableNode.symbol, kind);
    }

    @Override
    public void visit(BLangBlockStmt blockNode) {
        blockNode.stmts.forEach(stmt -> stmt.accept((BLangNodeVisitor)this));
    }

    @Override
    public void visit(BLangBlockFunctionBody blockFuncBody) {
        blockFuncBody.stmts.forEach(stmt -> stmt.accept((BLangNodeVisitor)this));
    }

    @Override
    public void visit(BLangSimpleVariableDef varDefNode) {
        if (varDefNode.getVariable().getName().getValue().startsWith("0")) {
            return;
        }
        varDefNode.getVariable().accept((BLangNodeVisitor)this);
    }

    @Override
    public void visit(BLangXMLNS xmlnsNode) {
        this.addSymbol((BLangNode)xmlnsNode, xmlnsNode.symbol, SymbolKind.Namespace);
    }

    @Override
    public void visit(BLangWorker workerNode) {
        this.addSymbol((BLangNode)workerNode, (BSymbol)workerNode.symbol, SymbolKind.Class);
        workerNode.body.accept((BLangNodeVisitor)this);
    }

    private void addSymbol(BLangNode node, BSymbol balSymbol, SymbolKind kind) {
        List<String> symbolNameComponents = Arrays.asList(balSymbol.getName().getValue().split("\\."));
        String symbolName = CommonUtil.getLastItem(symbolNameComponents);
        if (this.query != null && !this.query.isEmpty() && !symbolName.startsWith(this.query) || CommonUtil.isInvalidSymbol(balSymbol)) {
            return;
        }
        SymbolInformation lspSymbol = new SymbolInformation();
        lspSymbol.setName(symbolName);
        lspSymbol.setKind(kind);
        lspSymbol.setLocation(new Location(this.uri, this.getRange(node)));
        this.symbols.add((Either<SymbolInformation, DocumentSymbol>)Either.forLeft((Object)lspSymbol));
    }

    private Range getRange(BLangNode node) {
        Range r = new Range();
        int startLine = node.getPosition().getStartLine() - 1;
        int startChar = node.getPosition().getStartColumn() - 1;
        int endLine = node.getPosition().getEndLine() - 1;
        int endChar = node.getPosition().getEndColumn() - 1;
        if (endLine <= 0) {
            endLine = startLine;
        }
        if (endChar <= 0) {
            endChar = startChar + 1;
        }
        r.setStart(new Position(startLine, startChar));
        r.setEnd(new Position(endLine, endChar));
        return r;
    }
}

