/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.util;

import java.nio.file.Path;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class Debouncer {
    private final ScheduledExecutorService sched = Executors.newScheduledThreadPool(1);
    private final ConcurrentHashMap<Path, Future<?>> delayedMap = new ConcurrentHashMap();
    private final int interval;

    public Debouncer(int interval) {
        this.interval = interval;
    }

    public void call(Path path, Runnable runnable) {
        Future prev = this.delayedMap.put(path, this.sched.schedule(() -> {
            try {
                runnable.run();
            }
            finally {
                this.delayedMap.remove(path);
            }
        }, (long)this.interval, TimeUnit.MILLISECONDS));
        if (prev != null) {
            prev.cancel(true);
        }
    }

    public void terminate() {
        this.sched.shutdownNow();
    }
}

